<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
  <xsl:key name="ext" match="method/htmlExtend" use="htmlExtend" />
  <xsl:template match="/">
    <xsl:apply-templates select="javadoc" />
  </xsl:template>

  <xsl:template match="javadoc">
    <ROWSET tableName="GE12">
<!--
      <EXEC_SQL>delete from GE12 where SYSTEM_ID='**' and KBSAKU='1'</EXEC_SQL>
-->
      <xsl:for-each select="classDoc">
        <xsl:element name="ROW">
          <xsl:attribute name="num">
            <xsl:number level="any" format="1" count="classDoc" />
          </xsl:attribute>
          <SYSTEM_ID>**</SYSTEM_ID>
          <PARAM_ID><xsl:value-of select="attKey" /></PARAM_ID>
          <SEQNO><xsl:value-of select="seq" /></SEQNO>
          <TITLE><xsl:value-of select="description" /></TITLE>
          <PARAM><xsl:value-of select="attClass" /></PARAM>
          <CONTENTS><xsl:value-of select="contents" /></CONTENTS>
          <PARAM_LVL>1</PARAM_LVL>
          <FGCRYPT>0</FGCRYPT>
          <KBSAKU>1</KBSAKU>
          <FGJ>1</FGJ>
        </xsl:element>
      </xsl:for-each>
    </ROWSET>
  </xsl:template>

</xsl:stylesheet>
