/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.filter;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.StringUtil;

public final class URLCheckFilter
implements Filter {
    private static final HybsCryptography HYBS_CRYPTOGRAPHY = new HybsCryptography();
    private String filename = null;
    private boolean isDebug = false;
    private boolean isDecode = true;
    private String ignoreURL = null;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.isValidAccess(servletRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            String string;
            servletResponse.setContentType("text/html; charset=UTF-8");
            PrintWriter printWriter = servletResponse.getWriter();
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.filename), "UTF-8"));
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.println(string);
            }
            printWriter.flush();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                String string = "\u6307\u5b9a\u3055\u308c\u305f\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002[UTF-8]";
                throw new RuntimeException(string, unsupportedEncodingException);
                catch (IOException iOException) {
                    String string2 = "\u30b9\u30c8\u30ea\u30fc\u30e0\u304c\u30aa\u30fc\u30d7\u30f3\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + this.filename + "]";
                    throw new RuntimeException(string2, iOException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedReader);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)bufferedReader);
    }

    public void init(FilterConfig filterConfig) {
        ServletContext servletContext = filterConfig.getServletContext();
        String string = servletContext.getRealPath("") + File.separator;
        this.filename = string + filterConfig.getInitParameter("filename");
        this.isDebug = StringUtil.nval((String)filterConfig.getInitParameter("debug"), (boolean)false);
        this.isDecode = StringUtil.nval((String)filterConfig.getInitParameter("decode"), (boolean)true);
        this.ignoreURL = filterConfig.getInitParameter("ignoreURL");
    }

    public void destroy() {
    }

    private boolean isValidAccess(ServletRequest servletRequest) {
        boolean bl;
        block13: {
            String string = servletRequest.getParameter("h_urlCheck");
            if (string == null || string.length() == 0) {
                if (this.isDebug) {
                    System.out.println("  check NG [ No Check Key ]");
                }
                return false;
            }
            bl = false;
            try {
                string = HYBS_CRYPTOGRAPHY.decrypt(string).replace("&amp;", "&");
                if (this.isDebug) {
                    System.out.println("checkKey=" + string);
                }
                String string2 = string.substring(0, string.lastIndexOf(",time="));
                long l = Long.parseLong(string.substring(string.lastIndexOf(",time=") + 6, string.lastIndexOf(",userid=")));
                String string3 = string.substring(string.lastIndexOf(",userid=") + 8);
                String[] stringArray = StringUtil.csv2Array((String)string3);
                if (this.ignoreURL != null && this.ignoreURL.length() > 0 && string2.indexOf(this.ignoreURL) == 0) {
                    string2 = string2.substring(this.ignoreURL.length());
                }
                if (this.isDebug) {
                    System.out.println(" [ignoreURL]=" + this.ignoreURL);
                    System.out.println(" [url]    =" + string2);
                    System.out.println(" [vtime]  =" + l);
                    System.out.println(" [userid] =" + string3);
                }
                String string4 = ((HttpServletRequest)servletRequest).getRequestURL().toString() + "?" + ((HttpServletRequest)servletRequest).getQueryString();
                if (this.isDecode) {
                    if (this.isDebug) {
                        System.out.println("[BeforeURIDecode]=" + string4);
                    }
                    string4 = StringUtil.urlDecode((String)string4);
                }
                string4 = string4.substring(0, string4.lastIndexOf("h_urlCheck") - 1);
                String string5 = ((HttpServletRequest)servletRequest).getRemoteUser();
                if (this.isDebug) {
                    System.out.println(" [reqURL] =" + string4);
                    System.out.println(" [ctime]  =" + System.currentTimeMillis());
                    System.out.println(" [reqUser]=" + string5);
                }
                if (!string4.endsWith(string2) || System.currentTimeMillis() - l >= 0L || stringArray == null || stringArray.length <= 0) break block13;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!"*".equals(stringArray[i]) && !string5.equals(stringArray[i])) continue;
                    bl = true;
                    if (this.isDebug) {
                        System.out.println("  check OK");
                    }
                    break;
                }
            }
            catch (RuntimeException runtimeException) {
                if (this.isDebug) {
                    String string6 = "\u30c1\u30a7\u30c3\u30af\u30a8\u30e9\u30fc\u3002  checkKey=" + string + " " + runtimeException.getMessage();
                    System.out.println(string6);
                    runtimeException.printStackTrace();
                }
                bl = false;
            }
        }
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UrlCheckFilter");
        stringBuilder.append("[").append(this.filename).append("],");
        return stringBuilder.toString();
    }
}

