/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.opengion.fukurou.model.NativeType;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.plugin.io.TableWriter_Default;

public class TableWriter_Excel
extends TableWriter_Default {
    private static final String VERSION = "5.7.6.3 (2014/05/23)";
    private Workbook wb = null;
    private Sheet sheet = null;
    protected int nRowIndex = 0;
    private String sheetName = "Sheet1";
    private String refSheetName = null;
    private String filename = null;
    private String refFilename = null;
    private String fontName = null;
    private short fontPoint = (short)-1;
    private CreationHelper createHelper = null;
    private boolean useNumber = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeDBTable() {
        boolean bl;
        boolean bl2;
        if (!this.createDBColumn()) {
            return;
        }
        this.useNumber = this.isUseNumber();
        if (this.filename == null) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = bl2 = this.checkAvailabity(this.filename);
        String string = this.filename;
        boolean bl6 = bl = null != this.refSheetName && 0 <= this.refSheetName.length();
        if (bl && null != this.refFilename && 0 < this.refFilename.length()) {
            if (bl2) {
                if (0 != this.refFilename.compareToIgnoreCase(this.filename)) {
                    String string2 = "\u8ffd\u52a0\u306e\u6642\u3001\u96db\u578b\u30d5\u30a1\u30a4\u30eb\u540d\u3068\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u540c\u3058\u3057\u304b\u5bfe\u5fdc\u3057\u3066\u3044\u306a\u304b\u3063\u305f[" + this.refFilename + "]";
                    throw new HybsSystemException(string2);
                }
                string = this.filename;
                bl5 = true;
            } else {
                string = this.refFilename;
                bl5 = true;
                bl4 = true;
            }
        }
        if (bl5) {
            this.wb = this.createWorkbook(string);
        } else {
            this.wb = this.filename.toLowerCase(Locale.JAPAN).endsWith(".xlsx") ? new XSSFWorkbook() : new HSSFWorkbook();
            Font font = this.wb.getFontAt((short)0);
            if (this.fontName != null) {
                font.setFontName(this.fontName);
            }
            if (this.fontPoint > 0) {
                font.setFontHeightInPoints(this.fontPoint);
            }
        }
        int n = this.wb.getSheetIndex(this.sheetName);
        int n2 = -1;
        if (bl3) {
            this.sheet = this.wb.createSheet();
        } else {
            if (bl) {
                n2 = this.wb.getSheetIndex(this.refSheetName);
            }
            if (bl4) {
                int n3;
                if (-1 >= n2) {
                    String string3 = "\u96db\u578b\u306e\u4e2d\u306b\u53c2\u7167\u3068\u3057\u3066\u306e\u30b7\u30fc\u30c8\u304c\u5b58\u5728\u3057\u307e\u305b\u3093[" + this.refFilename + "]";
                    throw new HybsSystemException(string3);
                }
                while (1 != (n3 = this.wb.getNumberOfSheets())) {
                    for (int i = n3 - 1; i >= 0; --i) {
                        if (i == n2) continue;
                        this.wb.removeSheetAt(i);
                    }
                    if (!bl) continue;
                    n2 = this.wb.getSheetIndex(this.refSheetName);
                }
            } else if (-1 < n && !this.isAppend() && n != n2 && bl5) {
                this.wb.removeSheetAt(n);
            }
            if (bl) {
                n2 = this.wb.getSheetIndex(this.refSheetName);
            }
            Sheet sheet = this.sheet = -1 >= n2 ? this.wb.createSheet() : this.wb.cloneSheet(n2);
            if (bl4) {
                this.wb.removeSheetAt(n2);
            }
        }
        this.wb.setSheetName(this.wb.getNumberOfSheets() - 1, this.getNewSheetNameByName(this.wb, this.sheetName));
        this.createHelper = this.wb.getCreationHelper();
        this.nRowIndex = 0;
        super.writeDBTable(null);
        this.removeSheetRow(this.sheet, this.nRowIndex);
        try {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.filename);
                this.wb.write((OutputStream)fileOutputStream);
            }
            catch (Throwable throwable) {
                Closer.ioClose(fileOutputStream);
                if (null != this.sheet) {
                    this.sheet = null;
                }
                if (null == this.wb) throw throwable;
                this.wb = null;
                throw throwable;
            }
            Closer.ioClose((Closeable)fileOutputStream);
            if (null != this.sheet) {
                this.sheet = null;
            }
            if (null == this.wb) return;
            this.wb = null;
            return;
        }
        catch (IOException iOException) {
            String string4 = "\u30d5\u30a1\u30a4\u30eb\u3078\u66f8\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002  File=" + this.filename;
            throw new HybsSystemException(string4, (Throwable)iOException);
        }
    }

    @Override
    public void writeDBTable(PrintWriter printWriter) {
        String string = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string);
    }

    protected void writeLabel(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        int n2 = n;
        n = (short)(n + 1);
        Row row = this.setFirstCellValue(this.nRowIndex++, n2, "#Label");
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            String string = this.dbColumn[n3].getLabel();
            if (i == 0 && !this.useNumber) {
                n = (short)(n - 1);
                string = "#" + string;
            }
            int n4 = n;
            n = (short)(n + 1);
            this.setRowCellValue(row, n4, string, 1);
        }
        this.removeRowCell(row, n);
    }

    protected void writeName(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        int n2 = n;
        n = (short)(n + 1);
        Row row = this.setFirstCellValue(this.nRowIndex++, n2, "#Name");
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            String string = dBTableModel.getColumnName(n3);
            if (i == 0 && !this.useNumber) {
                n = (short)(n - 1);
                string = "#" + string;
            }
            int n4 = n;
            n = (short)(n + 1);
            this.setRowCellValue(row, n4, string, 1);
        }
        this.removeRowCell(row, n);
    }

    protected void writeSize(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        int n2 = n;
        n = (short)(n + 1);
        Row row = this.setFirstCellValue(this.nRowIndex++, n2, "#Size");
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            String string = String.valueOf(this.dbColumn[n3].getTotalSize());
            if (i == 0 && !this.useNumber) {
                n = (short)(n - 1);
                string = "#" + string;
            }
            int n4 = n;
            n = (short)(n + 1);
            this.setRowCellValue(row, n4, string, 0);
        }
        this.removeRowCell(row, n);
    }

    protected void writeClass(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        int n2 = n;
        n = (short)(n + 1);
        Row row = this.setFirstCellValue(this.nRowIndex++, n2, "#Class");
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            String string = this.dbColumn[n3].getClassName();
            if (i == 0 && !this.useNumber) {
                n = (short)(n - 1);
                string = "#" + string;
            }
            int n4 = n;
            n = (short)(n + 1);
            this.setRowCellValue(row, n4, string, 1);
        }
        this.removeRowCell(row, n);
    }

    protected void writeSeparator(DBTableModel dBTableModel, PrintWriter printWriter) {
        String string = "----";
        int n = 0;
        int n2 = n;
        n = (short)(n + 1);
        Row row = this.setFirstCellValue(this.nRowIndex++, n2, "#----");
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (i == 0 && !this.useNumber) continue;
            int n3 = n;
            n = (short)(n + 1);
            this.setRowCellValue(row, n3, string, 1);
        }
        this.removeRowCell(row, n);
    }

    @Override
    protected void writeData(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n;
        int n2;
        int n3 = dBTableModel.getRowCount();
        boolean[] blArray = new boolean[this.numberOfColumns];
        int[] nArray = new int[this.numberOfColumns];
        for (n2 = 0; n2 < this.numberOfColumns; ++n2) {
            n = this.clmNo[n2];
            NativeType nativeType = this.dbColumn[n].getNativeType();
            switch (nativeType) {
                case INT: 
                case LONG: 
                case DOUBLE: {
                    nArray[n2] = 0;
                    break;
                }
                default: {
                    nArray[n2] = 1;
                }
            }
            blArray[n2] = "NVAR".equals(this.dbColumn[n].getDbType());
            if (!this.isUseRenderer() || !this.dbColumn[n].isStringOutput()) continue;
            nArray[n2] = 1;
        }
        n2 = this.isUseRenderer() ? 1 : 0;
        for (n = 0; n < n3; ++n) {
            int n4 = 0;
            int n5 = n4;
            n4 = (short)(n4 + 1);
            Row row = this.setFirstCellValue(this.nRowIndex++, n5, String.valueOf(n + 1));
            if (!this.useNumber) {
                n4 = (short)(n4 - 1);
            }
            for (int i = 0; i < this.numberOfColumns; ++i) {
                int n6 = this.clmNo[i];
                String string = (String)dBTableModel.getValue(n, n6);
                if (blArray[i]) {
                    string = StringUtil.getReplaceEscape((String)string);
                } else if (n2 != 0) {
                    string = StringUtil.spanCut((String)this.dbColumn[n6].getRendererValue(string));
                }
                int n7 = n4;
                n4 = (short)(n4 + 1);
                this.setRowCellValue(row, n7, string, nArray[i]);
            }
            this.removeRowCell(row, n4);
        }
    }

    protected Row setFirstCellValue(int n, int n2, String string) {
        Cell cell;
        Row row = this.sheet.getRow(n);
        if (row == null) {
            row = this.sheet.createRow(n);
        }
        if (null == (cell = row.getCell(n2))) {
            cell = row.createCell(n2);
        }
        RichTextString richTextString = this.createHelper.createRichTextString(string);
        cell.setCellValue(richTextString);
        return row;
    }

    protected void setRowCellValue(Row row, int n, String string, int n2) {
        Cell cell = row.getCell(n);
        if (null == cell) {
            cell = row.createCell(n);
        }
        if (n2 == 0) {
            cell.setCellValue(StringUtil.parseDouble((String)string));
        } else {
            RichTextString richTextString = this.createHelper.createRichTextString(string);
            cell.setCellValue(richTextString);
        }
    }

    protected void removeRowCell(Row row, int n) {
        short s = row.getLastCellNum();
        for (int i = n; i <= s; ++i) {
            Cell cell = row.getCell(i);
            if (null == cell) continue;
            row.removeCell(cell);
        }
    }

    private void removeSheetRow(Sheet sheet, int n) {
        int n2 = sheet.getLastRowNum();
        for (int i = n; i <= n2; ++i) {
            Row row = sheet.getRow(i);
            if (null == row) continue;
            sheet.removeRow(row);
        }
    }

    protected String getNewSheetNameByName(Workbook workbook, String string) {
        String string2 = string;
        int n = 30;
        int n2 = 1;
        int n3 = 0;
        while (n3 > -1) {
            if (n2 >= 2) {
                String string3 = "(" + Integer.toString(n2) + ")";
                string2 = string.length() < n - string3.length() ? string + string3 : string.substring(0, n - string3.length()) + string3;
            }
            n3 = workbook.getSheetIndex(string2);
            ++n2;
        }
        return string2;
    }

    public void setSheetName(String string) {
        if (string != null) {
            this.sheetName = string;
        }
    }

    public void setRefSheetName(String string) {
        if (string != null) {
            this.refSheetName = string;
        }
    }

    public boolean isExcel() {
        return true;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public void setRefFilename(String string) {
        this.refFilename = string;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public void setFontPoint(short s) {
        this.fontPoint = s;
    }

    protected Workbook createWorkbook(String string) {
        Workbook workbook;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            workbook = WorkbookFactory.create((InputStream)fileInputStream);
        }
        catch (Exception exception) {
            try {
                String string2 = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + string + "]";
                throw new HybsSystemException(string2, (Throwable)exception);
            }
            catch (Throwable throwable) {
                Closer.ioClose(fileInputStream);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)fileInputStream);
        return workbook;
    }

    private boolean checkAvailabity(String string) {
        File file;
        boolean bl = false;
        if (this.isAppend() && null != string && (file = new File(string)).exists() && file.isFile() && file.length() > 0L) {
            bl = true;
        }
        return bl;
    }
}

