/*
 * YUI Compressor
 * Author: Julien Lecomte <jlecomte@yahoo-inc.com>
 * Copyright (c) 2007, Yahoo! Inc. All rights reserved.
 * Code licensed under the BSD License:
 *	   http://developer.yahoo.net/yui/license.txt
 */

package org.opengion.tools;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import com.yahoo.platform.yui.compressor.CssCompressor;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

import java.io.File;
import java.io.InputStreamReader;
import java.io.FileInputStream;
import java.io.OutputStreamWriter;
import java.io.FileOutputStream;
import java.io.FileFilter;
import java.io.Reader;
import java.io.Writer;
import java.io.IOException;

/**
 * OGCompressor ́Acom.yahoo.platform.yui.compressor.YUICompressor QlɁA
 * tH_ꊇ邽߂́AmainNXłB
 * js t@C css t@Ck܂B
 * ȂAIWĩt@Cƈk̃t@C̃^CX^vꍇ́A
 * XLbv܂B
 * ܂AkΐAIWĩ^CX^vňkt@C̃^CX^v
 * ܂B
 *
 * ӁF̃NX́AĂ܂B
 *
 * @og.rev 5.2.1.0 (2010/10/01) VKǉ
 *
 * @version  5.2
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class OGCompressor {

	/**
	 * N郁C\bhłB
	 *
	 *	&lt;java classname="org.opengion.tools.OGCompressor" classpath="${env.DEV_PATH}/yuicompressor-2.4.2og.jar" fork="yes"&gt;
	 *		&lt;arg value="-dir" /&gt;
	 *		&lt;arg value="${env.DEV_PATH}/src/script" /&gt;
	 *		&lt;arg value="${env.DEV_PATH}/jsp" /&gt;
	 *	&lt;/java&gt;
	 *
	 * @param	args[]	z
	 */
	public static void main( final String args[] ) {

		// ʔł́Aargs ̂܂܎gp܂B(-dir inDir outDir)
		if( args.length == 3 && "-dir".equals( args[0] ) ) {
			copyFile( new File(args[1]) , new File(args[2]) );
		}
	}

	/**
	 * ĂяoRs[\bhłB
	 *
	 * ̃\bh́AċNĂяoŃfBNgĂ܂B
	 * Ώۂ́A.js  .css t@Ĉ݂łB
	 * fBNg̃t@Cɑ΂Rs[s܂B
	 * ϊƕϊ̃^CX^vقȂꍇ̂ݕϊA
	 * ϊ̃t@ĆAϊÕ^CX^vɕύX܂B
	 *
	 * @param	inDir	̓tH_
	 * @param	outDir	o̓tH_
	 */
	private static void copyFile( final File inDir , final File outDir ) {

		File[] files = inDir.listFiles(
			// Ώۂ́A.js  .css t@Ĉ݂łB
			new FileFilter() {
				public boolean accept( final File pathname ) {
					if( pathname.isDirectory() ) { return true; }
					String name = pathname.getName().toLowerCase();
					return name.endsWith(".js") || name.endsWith(".css") ;
				}
			}
		);

		// o͐tH_𐶐
		if( !outDir.exists() && !outDir.mkdirs() ) {
			System.err.println("\n[ERROR] " + outDir + "tH_쐬ł܂łB" );
			return ;
		}

		// fBNg̃t@Cɑ΂Rs[s
		for( int i = 0; i<files.length; i++ ){
			File outFile = new File( outDir , files[i].getName() );
			if( files[i].isDirectory() ) {
				copyFile( files[i] , outFile );
			}
			else {
				// ϊƕϊ̃^CX^vقȂꍇ̂ݕϊ܂B
				long srcTime = files[i].lastModified();
				if( srcTime != outFile.lastModified() ) {
					exec( files[i] , outFile );
					outFile.setLastModified( srcTime );		// ϊ̃t@ĆAϊÕ^CX^vɕύX
				}
			}
		}
	}

	/**
	 * ks\bhłB
	 *
	 * ̃\bh́Aۂ̈ks\bhłB
	 *
	 * @param	inDir	̓tH_
	 * @param	outDir	o̓tH_
	 */
	private static void exec( final File inFile , final File outFile ) {
		System.err.println( "IN:" + inFile );	// ̃NXŁAerr  out ɕϊĂ̂ŁA邽߁Aerr ƂB

		Reader in = null;
		Writer out = null;

		try {
			String charset = "UTF-8" ;

			int linebreakpos = -1;

			in = new InputStreamReader(new FileInputStream(inFile), charset);

			String fname = inFile.getName().toLowerCase();
			if ( fname.endsWith(".js") ) {
				try {
					JavaScriptCompressor compressor = new JavaScriptCompressor(in, new ErrorReporter() {
						public void warning(String message, String sourceName,
								int line, String lineSource, int lineOffset) {
							if (line < 0) {
								System.err.println("\n[WARNING] " + inFile + ": " + message);
							} else {
								System.err.println("\n[WARNING] " + inFile + "(" + line + ':' + lineOffset + "): " + message);
							}
							System.err.println("\t" + lineSource);
						}

						public void error(String message, String sourceName,
								int line, String lineSource, int lineOffset) {
							if (line < 0) {
								System.err.println("\n[ERROR] " + inFile + ": " + message);
							} else {
								System.err.println("\n[ERROR] " + inFile + "(" + line + ':' + lineOffset + "): " + message);
							}
							System.err.println("\t" + lineSource);
						}

						public EvaluatorException runtimeError(String message, String sourceName,
								int line, String lineSource, int lineOffset) {
							error(message, sourceName, line, lineSource, lineOffset);
							return new EvaluatorException(message);
						}
					});

					// Close the input stream first, and then open the output stream,
					// in case the output file should override the input file.
					in.close(); in = null;

					out = new OutputStreamWriter(new FileOutputStream(outFile), charset);

					boolean verbose = false;
					boolean munge = true;
					boolean preserveAllSemiColons = false;
					boolean disableOptimizations = false;

					compressor.compress(out, linebreakpos, munge, verbose,
							preserveAllSemiColons, disableOptimizations);

				} catch (EvaluatorException e) {
					e.printStackTrace();
					// Return a special error code used specifically by the web front-end.
		//			System.exit(2);
				}
			} else if( fname.endsWith(".css") ) {

				CssCompressor compressor = new CssCompressor(in);

				// Close the input stream first, and then open the output stream,
				// in case the output file should override the input file.
				in.close(); in = null;

				out = new OutputStreamWriter(new FileOutputStream(outFile), charset);
				compressor.compress(out, linebreakpos);
			}
		}
		catch (IOException e) {
			e.printStackTrace();
	//		System.exit(1);
		}
		finally {
			if (in != null) {
				try {
					in.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			if (out != null) {
				try {
					out.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}
}
