/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.db;

// import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.hayabusa.resource.CodeData;
import static org.opengion.fukurou.util.HybsConst.CR ;				// 6.1.0.0 (2014/12/26)
import static org.opengion.fukurou.util.HybsConst.BUFFER_MIDDLE;	// 6.1.0.0 (2014/12/26) refactoring

/**
 * データのコード情報を取り扱うクラスです。
 *
 * コードのキーとラベルの情報から、HTMLのメニューやリストを作成するための オプション
 * タグを作成したり、与えられたキーをもとに、チェック済みのオプションタグを作成したり
 * します。
 *
 * @og.rev 5.7.7.1 (2014/06/13) Selection_NULL を 基本実装とします。
 * @og.group 選択データ制御
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
// public class Selection_CODE implements Selection {
public class Selection_CODE extends Selection_NULL {
	private final CodeData codeData ;

	private final int[]    ADRS  ;
	private final String   CACHE ;
	private final int      LEN   ;

	private final int[]    LADRS  ;		// 5.1.3.0 (2010/02/01)
	private final String   LCACHE ;		// 5.1.3.0 (2010/02/01)
	private final int      LLEN   ;		// 5.1.3.0 (2010/02/01)

	private final String addKeyLabel ;	// 6.2.0.0 (2015/02/27) キー:ラベル形式

	/**
	 * コンストラクター
	 *
	 * @og.rev 4.0.0.0 (2007/11/07) コードリソースの有無はDBColumnでチェックする。
	 * @og.rev 4.3.8.0 (2009/08/01) ツールチップ表示機能追加
	 * @og.rev 5.1.3.0 (2010/02/01) 一覧表示以外は、ツールチップ表示しない
	 * @og.rev 5.1.9.0 (2010/08/01) グループ機能とパラメータ機能の追加
	 * @og.rev 5.6.8.2 (2013/09/20) ツールチップは未加工のlongLabelを利用に修正
	 * @og.rev 5.7.7.1 (2014/06/13) Selection_NULL を 継承するため、super( null ); を追加します。
	 * @og.rev 6.2.0.0 (2015/02/27) コードリソースのパラメータの指定方法を変更します。
	 * @og.rev 6.2.0.0 (2015/02/27) キー:ラベル形式で表示するかどうかを、指定できるようにします。
	 *
	 * @param	cdData	コードデータオブジェクト
	 * @param	addKeyLabel キー:ラベル形式で表示するかどうか[true/false/null]
	 */
//	public Selection_CODE( final CodeData cdData ) {
	public Selection_CODE( final CodeData cdData,final String addKeyLabel ) {
		codeData = cdData ;
		this.addKeyLabel = addKeyLabel;			// 6.2.0.0 (2015/02/27) キー:ラベル形式
		final int size = codeData.getSize();

		// 5.1.9.0 (2010/08/01) グループ機能とパラメータの判定
		final boolean isLbl = codeData.useLebel();
		final boolean isCls = codeData.useParam();
		boolean isLblSet = false;				// optgroup の設定に使う。

		ADRS  = new int[size];
		final StringBuilder buf = new StringBuilder( BUFFER_MIDDLE );
		boolean useTitle = false;								// 4.3.8.0 (2009/08/01) title属性付加フラグ
		for( int i=0; i<size; i++ ) {
			if( ! codeData.isUse(i) ) { continue; }

			// 6.2.0.0 (2015/02/27) キー:ラベル形式
			final String cdkey = codeData.getCodeKey(i);
			final String kv = "true".equalsIgnoreCase( addKeyLabel ) ? cdkey + ':' : "" ;
			final String rslbl = codeData.getRawShortLabel(i);
//			// String lblb  = codeData.getLongLabel(i);
//			final String lblb  = codeData.getRawLongLabel(i);	// 5.6.8.2 (2013/09/20) ここでは生の名称長を取る

			// 5.1.9.0 (2010/08/01) コードレベルの判定
			if( isLbl && "0".equals( codeData.getCodeLebel(i) ) ) {
				if( isLblSet ) { buf.append( "</optgroup>" ); }

				buf.append( "<optgroup label=\"" + rslbl + "\">" );
				isLblSet = true;
				continue;
			}

			// 6.0.2.5 (2014/10/31) char を append する。
			// 6.2.0.0 (2015/02/27) キー:ラベル形式
//			buf.append( "<option value=\"" ).append( codeData.getCodeKey(i) ).append( '"' );
			buf.append( "<option value=\"" ).append( cdkey ).append( '"' );
			ADRS[i] = buf.length() ;

			// 5.1.9.0 (2010/08/01) パラメータの利用
			if( isCls ) {
				// 6.2.0.0 (2015/02/27) コードリソースのパラメータの指定方法を変更します。
//				final String classKey = codeData.getCodeParam(i);
//				if( ! "".equals( classKey ) ) {
//					buf.append( " class=\"" ).append( classKey ).append( '"' );
//				}
				final String paramKey = codeData.getCodeParam(i);
				setCodeParam( buf,paramKey );
			}

			// 6.2.0.0 (2015/02/27) Description があれば、優先して title 属性に設定します。
			final String desc = codeData.getDescription(i);
			if( desc.isEmpty() ) {
				// 4.3.8.0 (2009/08/01) LongLabelはRawShortLabelと異なるときにツールチップとして表示させる
				final String lblb  = codeData.getRawLongLabel(i); // 5.6.8.2 (2013/09/20) ここでは生の名称長を取る
				if( ! rslbl.equals( lblb ) ){
					buf.append(" title=\"").append( lblb ).append( '"' );
					useTitle = true;
				}
			}
			else {
				buf.append(" title=\"").append( desc ).append( '"' );
				useTitle = true;
			}

			// ShortLabelをBODYにする。
			// 6.2.0.0 (2015/02/27) キー:ラベル形式
//			buf.append( '>' ).append( rslbl ).append( "</option>" );
			buf.append( '>' ).append( kv ).append( rslbl ).append( "</option>" );
		}
		if( isLbl ) {
			buf.append( "</optgroup>" );
		}

		CACHE = buf.toString();
		LEN   = CACHE.length() + 30;

		// 5.1.3.0 (2010/02/01) ツールチップ表示が適用されている場合のみ、ツールチップなしの状態のoptionをキャッシュする。
		if( useTitle ) {
			isLblSet = false;

			LADRS  = new int[size];
			final StringBuilder lbuf = new StringBuilder( BUFFER_MIDDLE );
			for( int i=0; i<size; i++ ) {
				// 6.2.0.0 (2015/02/27) キー:ラベル形式
				final String cdkey = codeData.getCodeKey(i);
				final String kv = "true".equalsIgnoreCase( addKeyLabel ) ? cdkey + ':' : "" ;
				final String lblb  = codeData.getLongLabel(i);
				// 5.1.9.0 (2010/08/01) グループ機能の判定
				if( isLbl && "0".equals( codeData.getCodeLebel(i) ) ) {
					if( isLblSet ) { lbuf.append( "</optgroup>" ); }

					lbuf.append( "<optgroup label=\"" + lblb + "\">" );
					isLblSet = true;
					continue;
				}

				// 6.0.2.5 (2014/10/31) char を append する。
				// 6.2.0.0 (2015/02/27) キー:ラベル形式
//				lbuf.append( "<option value=\"" ).append( codeData.getCodeKey(i) ).append( '"' );
				lbuf.append( "<option value=\"" ).append( cdkey ).append( '"' );
				LADRS[i] = lbuf.length() ;

				// 5.1.9.0 (2010/08/01) パラメータの利用
				if( isCls ) {
					// 6.2.0.0 (2015/02/27) コードリソースのパラメータの指定方法を変更します。
//					final String classKey = codeData.getCodeParam(i);
//					if( ! "".equals( classKey ) ) {
//						lbuf.append( " class=\"" ).append( classKey ).append( '"' );
//					}
					final String paramKey = codeData.getCodeParam(i);
					setCodeParam( lbuf,paramKey );
				}

				// 6.2.0.0 (2015/02/27) キー:ラベル形式
//				lbuf.append( '>' ).append( lblb ).append( "</option>" );
				lbuf.append( '>' ).append( kv ).append( lblb ).append( "</option>" );
			}
			if( isLbl ) {
				buf.append( "</optgroup>" );
			}

			LCACHE = lbuf.toString();
			LLEN   = LCACHE.length() + 30;
		}
		else {
			LADRS  = ADRS;
			LCACHE = CACHE;
			LLEN   = LEN;
		}
	}

//	/**
//	 * 初期値が選択済みの 選択肢(オプション)を返します。
//	 * このオプションは、引数の値を初期値とするオプションタグを返します。
//	 * このメソッドでは、ラベル(短)が設定されている場合でも、これを使用せずに必ずラベル(長)を使用します。
//	 *
//	 * @og.rev 3.6.0.6 (2004/10/22) シーケンスアクセス機能を指定する seqFlag を導入
//	 * @og.rev 4.0.0.0 (2005/01/31) selectValue が、null/ゼロ文字列でない場合に、選択肢にない場合は、エラー
//	 * @og.rev 5.7.7.1 (2014/06/13) Selection_NULL を 継承するため、削除
//	 *
//	 * @param   selectValue  選択されている値
//	 * @param   seqFlag  シーケンスアクセス機能 [true:ON/false:OFF]
//	 *
//	 * @return  オプションタグ
//	 * @see     #getOption( String, boolean, boolean )
//	 */
//	public String getOption( final String selectValue,final boolean seqFlag ) {
//		return getOption( selectValue, seqFlag, false );
//	}

	/**
	 * 初期値が選択済みの 選択肢(オプション)を返します。
	 * このオプションは、引数の値を初期値とするオプションタグを返します。
	 * このメソッドでは、引数のuseShortLabelがtrueに指定された場合に、ラベル(短)をベースとした
	 * ツールチップ表示を行います。
	 *
	 * @og.rev 5.1.3.0 (2010/02/01) 追加
	 *
	 * @param   selectValue  選択されている値
	 * @param   seqFlag  シーケンスアクセス機能 [true:ON/false:OFF]
	 * @param   useShortLabel ラベル(短)をベースとしたオプション表示を行うかどうか。
	 *
	 * @return  オプションタグ
	 * @og.rtnNotNull
	 * @see     #getOption( String, boolean )
	 */
	@Override
	public String getOption( final String selectValue,final boolean seqFlag, final boolean useShortLabel ) {
		int[] adrs = null;
		String cache = null;
		int len = 0;
		if( useShortLabel ) {
			adrs  = ADRS;
			cache = CACHE;
			len   = LEN;
		}
		else {
			adrs  = LADRS;
			cache = LCACHE;
			len   = LLEN;
		}

		// マッチするアドレスを探す。
		final int selected = codeData.getAddress( selectValue );

		if( selected < 0 ) {
			// 4.0.0 (2005/01/31)
			if( selectValue != null && selectValue.length() > 0 ) {
				final String errMsg = "コードに存在しない値が指定されました。"
							+ " value=[" + selectValue + "]"
							+ CR + codeData ;
				LogWriter.log( errMsg );
			}
			return cache;
		}
		else {
//			final StringBuilder buf = new StringBuilder( len );
			final StringBuilder buf = new StringBuilder( len + 100 );						// 6.1.0.0 (2014/12/26) refactoring
			// 3.6.0.6 (2004/10/22) シーケンスアクセス機能を指定する seqFlag を導入
			if( seqFlag ) {
				buf.append( "<option value=\"" ).append( codeData.getCodeKey(selected) ).append( '"' );		// 6.0.2.5 (2014/10/31) char を append する。
			}
			else {
				buf.append( cache.substring( 0,adrs[selected] ) );
			}
			buf.append( " selected=\"selected\"" )
				.append( cache.substring( adrs[selected] ) );
			return buf.toString() ;
		}
	}

//	/**
//	 * 初期値が選択済みの 選択肢(オプション)を返します。
//	 * このオプションは、引数の値を初期値とするオプションタグを返します。
//	 * ※ このクラスでは実装されていません。
//	 *
//	 * @og.rev 2.1.0.1 (2002/10/17) 選択リストを、正方向にしか選べないようにする sequenceFlag を導入する
//	 * @og.rev 3.8.6.0 (2006/09/29) useLabel 属性 追加
//	 * @og.rev 5.7.7.1 (2014/06/13) Selection_NULL を 継承するため、削除
//	 *
//	 * @param   name         ラジオの name
//	 * @param   selectValue  選択されている値
//	 * @param   useLabel     ラベル表示の有無 [true:有/false:無]
//	 *
//	 * @return  オプションタグ
//	 */
//	public String getRadio( final String name,final String selectValue,final boolean useLabel ) {
//	final String errMsg = "このクラスでは実装されていません。";
//		throw new UnsupportedOperationException( errMsg );
//	}

//	/**
//	 * 初期値が選択済みの 選択肢(オプション)を返します。
//	 * このオプションは、引数の値を初期値とするオプションタグを返します。
//	 * ※ このクラスでは実装されていません。
//	 *
//	 * @og.rev 5.7.7.1 (2014/06/13) Selection_NULL を 継承するため、削除
//	 *
//	 * @param   selectValue  選択されている値
//	 *
//	 * @return  オプションタグ
//	 */
//	public String getRadioLabel( final String selectValue ) {
//	final String errMsg = "このクラスでは実装されていません。";
//		throw new UnsupportedOperationException( errMsg );
//	}

//	/**
//	 * 選択肢(value)に対するラベルを返します。
//	 * 選択肢(value)が、存在しなかった場合は、選択肢そのものを返します。
//	 * getValueLabel( XX ) は、getValueLabel( XX,false ) と同じです。
//	 *
//	 * @og.rev 5.7.7.1 (2014/06/13) Selection_NULL を 継承するため、削除
//	 *
//	 * @param   selectValue 選択肢の値
//	 *
//	 * @return  選択肢のラベル
//	 * @see     #getValueLabel( String,boolean )
//	 */
//	public String getValueLabel( final String selectValue ) {
//		return getValueLabel( selectValue,false );
//	}

	/**
	 * 選択肢(value)に対するラベルを返します。
	 * 選択肢(value)が、存在しなかった場合は、選択肢そのものを返します。
	 * このメソッドでは、短縮ラベルを返すかどうかを指定するフラグを指定します。
	 * getValueLabel( XX,false ) は、getValueLabel( XX ) と同じです。
	 *
	 * @og.rev 4.0.0.0 (2005/11/30) を追加
	 * @og.rev 6.2.0.0 (2015/02/27) キー:ラベル形式で表示するかどうかを、指定できるようにします。
	 *
	 * @param	selectValue	選択肢の値
	 * @param	flag	短縮ラベル使用可否 [true:使用する/false:しない]
	 *
	 * @return  選択肢のラベル
	 * @see     #getValueLabel( String )
	 */
	@Override
	public String getValueLabel( final String selectValue,final boolean flag ) {
		// マッチするアドレスを探す。
		final int selected = codeData.getAddress( selectValue );

		if( selected < 0 ) {
			// マッチしなければ、選択肢そのものを返す。
			return selectValue;
		}
		else {
			// 6.2.0.0 (2015/02/27) キー:ラベル形式
//			if( flag ) {
//				return codeData.getShortLabel(selected);
//			}
//			else {
//				return codeData.getLongLabel(selected);
//			}
			final String lbl = flag ? codeData.getShortLabel(selected) : codeData.getLongLabel(selected);

			return "true".equalsIgnoreCase( addKeyLabel ) ? selectValue + ':' + lbl : lbl ;
		}
	}

//	/**
//	 * マルチ・キーセレクトを使用するかどうかを返します。
//	 * true：使用する。false:使用しない です。
//	 * ただし、実際に使用するかどうかは、HTML出力時に決めることが出来ます。
//	 * ここでは、USE_MULTI_KEY_SELECT が true で、USE_SIZE(=20)以上の場合に
//	 * true を返します。
//	 *
//	 * @og.rev 3.5.5.7 (2004/05/10) 新規作成
//	 * @og.rev 6.0.4.0 (2014/11/28) Column 側に移動。
//	 *
//	 * @return  選択リストで、マルチ・キーセレクトを使用するかどうか(true:使用する)
//	 */
//	@Override
//	public boolean useMultiSelect() {
//		return codeData.useMultiSelect();
//	}

//	/**
//	 * オブジェクトのキャッシュが時間切れかどうかを返します。
//	 * キャッシュが時間切れ(無効)であれば、true を、有効であれば、
//	 * false を返します。
//	 *
//	 * @og.rev 4.0.0.0 (2005/01/31) 新規作成
//	 * @og.rev 5.7.7.1 (2014/06/13) Selection_NULL を 継承するため、削除
//	 *
//	 * @return  キャッシュが時間切れなら true
//	 */
//	public boolean isTimeOver() {
//		return false;
//	}
}
