/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

// import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;

/**
 * YMD レンデラーは、カラムのデータを日付(月/日)表示する場合に使用するクラスです。
 * 元の文字列の5,6桁目を月として、7,8桁目を日として表示します。
 *
 * このクラスは、不変オブジェクトとして、共有されます。
 *
 * @og.group データ表示
 *
 * @og.rev 4.3.7.1 (2009/06/08) 新規作成
 *
 * @version  4.0
 * @author   Takahashi Masakazu
 * @since    JDK5.0,
 */
public class Renderer_MD extends AbstractRenderer {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.0.4.0 (2014/11/28)" ;

	private static final CellRenderer dbCell = new Renderer_MD() ;

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellRendererオブジェクト
	 * @og.rtnNotNull
	 */
	public CellRenderer newInstance( final DBColumn clm ) {
		return dbCell;
	}

	/**
	 * データの表示用文字列を返します。
	 * ここでは、null か ゼロ文字列の場合は、ゼロ文字列を返します。
	 * ４ケタ以外の８ケタ以下のデータなど、正常に処理できなかった場合は、エラー表示を行います。
	 * 元が８ケタ以上の場合は先頭から8文字をYYYYMMDD として、MM/DD を返します。
	 * ４ケタの場合は、MMDD を、MM/DD として返します。
	 *
	 * @og.rev 5.5.7.2 (2012/10/09) 処理ロジックの見直し
	 * @og.rev 5.5.8.1 (2012/11/05) コロンをスラッシュに修正、8文字以上の処理
	 * @og.rev 6.0.4.0 (2014/11/28) ロジックの共通化
	 *
	 * @param   value 入力値
	 *
	 * @return  データの表示用文字列
	 * @og.rtnNotNull
	 */
	@Override
	public String getValue( final String value ) {
		return getValue( value , true );

//		if( value == null || value.length() == 0 ) { return ""; }
//
//		String rtn = value;
//
//		char[] ch1 = new char[5];
//		if( rtn.length() == 4 ) {
//			ch1[0] = rtn.charAt(0);
//			ch1[1] = rtn.charAt(1);
//			ch1[2] = '/' ; // 5.5.8.1 (2012/11/05)
//			ch1[3] = rtn.charAt(2);
//			ch1[4] = rtn.charAt(3);
//
//			rtn = new String( ch1 );
//		}
//		else if( rtn.length() >= 8 ) {
//			ch1[0] = rtn.charAt(4);
//			ch1[1] = rtn.charAt(5);
//			ch1[2] = '/' ; // 5.5.8.1 (2012/11/05)
//			ch1[3] = rtn.charAt(6);
//			ch1[4] = rtn.charAt(7);
//
//			rtn = new String( ch1 );
//		}
//		else {
//			rtn = "<span class=\"error\">" + value + "</span>";
//		}
//		return rtn;
	}

	/**
	 * データ出力用の文字列を作成します。
	 * ファイル等に出力する形式を想定しますので、HTMLタグを含まない
	 * データを返します。
	 * 基本は、#getValue( String ) をそのまま返します。
	 *
	 * @og.rev 6.0.4.0 (2014/11/28) データ出力用のレンデラー
	 *
	 * @param   value 入力値
	 *
	 * @return  データ出力用の文字列
	 * @og.rtnNotNull
	 * @see		#getValue( String )
	 */
	@Override
	public String getWriteValue( final String value ) {
		return getValue( value , false );
	}

	/**
	 * データ表示用/出力用の文字列を作成します。
	 * 第二引数の isView == true で、データ表示用文字列を、false で
	 * データ出力用の文字列を作成します。
	 * 処理の共通化を行うためのメソッドです。
	 *
	 * @og.rev 6.0.4.0 (2014/11/28) ロジックの共通化
	 *
	 * @param   value  入力値
	 * @param   isView データ表示用かどうか(true:表示用/false:出力用)
	 *
	 * @return  データ表示用/出力用の文字列
	 * @og.rtnNotNull
	 * @see		#getValue( String )
	 */
	private String getValue( final String value , final boolean isView ) {
//		if( value == null || value.length() == 0 ) { return ""; }
		if( value == null || value.isEmpty() ) { return ""; }

		String rtn = value;			// 初期値:isView = false の時の値

		char[] ch1 = new char[5];
		if( rtn.length() == 4 ) {
			ch1[0] = rtn.charAt(0);
			ch1[1] = rtn.charAt(1);
			ch1[2] = '/' ; // 5.5.8.1 (2012/11/05)
			ch1[3] = rtn.charAt(2);
			ch1[4] = rtn.charAt(3);

			rtn = new String( ch1 );
		}
		else if( rtn.length() >= 8 ) {
			ch1[0] = rtn.charAt(4);
			ch1[1] = rtn.charAt(5);
			ch1[2] = '/' ; // 5.5.8.1 (2012/11/05)
			ch1[3] = rtn.charAt(6);
			ch1[4] = rtn.charAt(7);

			rtn = new String( ch1 );
		}
		else {
			if( isView ) {
				rtn = "<span class=\"error\">" + value + "</span>";
			}
		}
		return rtn;
	}
}
