/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opengion.fukurou.model.DataModel;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.security.URLHashMap;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.html.CreateToken;
import org.opengion.hayabusa.html.ViewMarker;

public class ViewLink_LINK
implements ViewMarker {
    private static final String REQ_KEY = "h_r";
    private static final int ACCS_LVL = HybsSystem.sysInt("URL_ACCESS_SECURITY_LEVEL");
    private static final int MARK_NULL = -1;
    private static final int MARK_TRUE = 1;
    private static final int MARK_FALSE = 0;
    private List<Attributes> markData;
    private Map<Integer, Formatter> formMap = new HashMap<Integer, Formatter>();
    private DBTableModel table;
    private int[] markCmlNo;
    private int[] isMark;
    private int[] encodeIn;
    private int[] encodeOut;
    private String[] markKey;
    private String[] markLists;
    private int[] markListNo;
    private boolean[] useURLCheck;
    private String[] urlCheckUser;
    private long[] urlCheckTime;
    private boolean[] useHrefEncode;
    private String[] extToken;
    private Map<Integer, List<Integer>> clmMap = new HashMap<Integer, List<Integer>>();

    @Override
    public void clear() {
        this.markData = null;
        this.formMap = new HashMap<Integer, Formatter>();
        this.table = null;
        this.isMark = null;
        this.encodeIn = null;
        this.encodeOut = null;
        this.markKey = null;
        this.markLists = null;
        this.markListNo = null;
        this.clmMap = new HashMap<Integer, List<Integer>>();
        this.useURLCheck = null;
        this.urlCheckUser = null;
        this.urlCheckTime = null;
        this.useHrefEncode = null;
        this.extToken = null;
    }

    @Override
    public void addAttribute(Attributes attributes) {
        if (this.markData == null) {
            this.markData = new ArrayList<Attributes>();
        }
        this.markData.add(attributes);
    }

    @Override
    public void setDBTableModel(DBTableModel dBTableModel) {
        this.table = dBTableModel;
        int n = this.markData.size();
        this.isMark = new int[n];
        this.markKey = new String[n];
        this.markCmlNo = new int[n];
        this.markLists = new String[n];
        this.markListNo = new int[n];
        this.encodeIn = new int[n];
        this.encodeOut = new int[n];
        this.useURLCheck = new boolean[n];
        this.urlCheckUser = new String[n];
        this.urlCheckTime = new long[n];
        this.useHrefEncode = new boolean[n];
        this.extToken = new String[n];
        Arrays.fill(this.isMark, 0);
        Arrays.fill(this.markCmlNo, -1);
        Arrays.fill(this.encodeIn, 10000);
        Arrays.fill(this.encodeOut, -1);
        Arrays.fill(this.useURLCheck, false);
        Arrays.fill(this.urlCheckTime, 0L);
        Arrays.fill(this.useHrefEncode, false);
        for (int i = 0; i < n; ++i) {
            Attributes attributes = this.markData.get(i);
            String string = attributes.get("column");
            int n2 = this.table.getColumnNo(string);
            List<Integer> list = this.clmMap.get(n2);
            if (list == null) {
                list = new ArrayList<Integer>();
            }
            list.add(i);
            this.clmMap.put(n2, list);
            String string2 = attributes.get("linkFormat");
            string2 = StringUtil.replace((String)string2, (String)"%5B", (String)"[");
            string2 = StringUtil.replace((String)string2, (String)"%5D", (String)"]");
            Formatter formatter = new Formatter((DataModel)this.table);
            formatter.setFormat(string2);
            this.formMap.put(i, formatter);
            String[] stringArray = formatter.getFormat();
            boolean bl = false;
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j] != null && stringArray[j].indexOf("href") >= 0) {
                    bl = true;
                }
                if (bl && stringArray[j].indexOf(63) >= 0) {
                    this.encodeIn[i] = j;
                }
                if (!bl || stringArray[j].indexOf("\" ") < 0) continue;
                this.encodeOut[i] = j;
                bl = false;
            }
            this.useURLCheck[i] = StringUtil.nval((String)attributes.get("useURLCheck"), (boolean)false);
            this.urlCheckUser[i] = StringUtil.nval((String)attributes.get("urlCheckUser"), null);
            this.urlCheckTime[i] = StringUtil.nval((String)attributes.get("urlCheckTime"), (long)0L);
            this.useHrefEncode[i] = StringUtil.nval((String)attributes.get("useHrefEncode"), (boolean)false);
            this.extToken[i] = StringUtil.nval((String)attributes.get("extToken"), null);
            this.makeOnLinkFormat(i, attributes);
        }
    }

    @Override
    public String getMarkerString(int n, int n2, String string) {
        int n3;
        int n4 = this.isOnLink(n, n2);
        if (n4 < 0) {
            return string;
        }
        Formatter formatter = this.formMap.get(n4);
        int[] nArray = formatter.getClmNos();
        String[] stringArray = formatter.getFormat();
        StringBuilder stringBuilder = new StringBuilder(500);
        for (n3 = 0; n3 < nArray.length; ++n3) {
            String string2;
            stringBuilder.append(stringArray[n3]);
            if (this.encodeIn[n4] <= n3 && n3 < this.encodeOut[n4]) {
                string2 = StringUtil.urlEncode((String)formatter.getValue(n, nArray[n3]));
            } else if (n2 == nArray[n3]) {
                string2 = string;
                if (this.useHrefEncode[n4] && string2 != null) {
                    string2 = string2.replaceAll("%", "%25").replaceAll(";", "%3B");
                }
            } else {
                string2 = formatter.getValue(n, nArray[n3]);
                if (this.useHrefEncode[n4] && string2 != null) {
                    string2 = string2.replaceAll("%", "%25").replaceAll(";", "%3B");
                }
            }
            stringBuilder.append(string2);
        }
        stringBuilder.append(stringArray[n3]);
        String string3 = stringBuilder.toString();
        String string4 = String.valueOf(n);
        string3 = StringUtil.replace((String)string3, (String)"{I}", (String)string4);
        string3 = StringUtil.replace((String)string3, (String)"%7BI%7D", (String)string4);
        if (this.useURLCheck[n4]) {
            string3 = XHTMLTag.embedURLCheckKey((String)string3, (String)"h_urlCheck", (String)this.urlCheckUser[n4], (long)this.urlCheckTime[n4]);
        }
        if (this.extToken[n4] != null && this.extToken[n4].length() > 0) {
            String[] stringArray2;
            for (String string5 : stringArray2 = StringUtil.csv2Array((String)this.extToken[n4])) {
                String string6 = HybsSystem.sys("CreateToken_" + string5);
                CreateToken createToken = (CreateToken)HybsSystem.newInstance(string6);
                string3 = createToken.embedToken(string3, this.urlCheckTime[n4], null, new String[0]);
            }
        }
        if (ACCS_LVL == 2) {
            string3 = URLHashMap.makeUrlChange((String)string3, (String)REQ_KEY, (boolean)true);
        } else if (ACCS_LVL == 3) {
            string3 = URLHashMap.makeUrlChange((String)string3, (String)REQ_KEY, (boolean)false);
        }
        return string3;
    }

    private void makeOnLinkFormat(int n, Attributes attributes) {
        String string = attributes.get("onLink");
        String string2 = attributes.get("markList");
        this.isMark[n] = -1;
        if (string == null || string.isEmpty() || string2 == null || string2.isEmpty()) {
            this.isMark[n] = 0;
            return;
        }
        if (string.charAt(0) != '[' && string2.charAt(0) != '[') {
            this.isMark[n] = string2.indexOf(string) >= 0 ? 1 : 0;
            return;
        }
        if (string.charAt(0) == '[') {
            this.markCmlNo[n] = this.table.getColumnNo(string.substring(1, string.length() - 1));
        } else {
            this.markCmlNo[n] = -1;
            this.markKey[n] = string;
        }
        if (string2.charAt(0) == '[') {
            this.markListNo[n] = this.table.getColumnNo(string2.substring(1, string2.length() - 1));
        } else {
            this.markListNo[n] = -1;
            this.markLists[n] = string2;
        }
    }

    private int isOnLink(int n, int n2) {
        List<Integer> list = this.clmMap.get(n2);
        if (list == null) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string;
            String string2;
            int n3 = list.get(i);
            if (!(this.isMark[n3] != -1 ? this.isMark[n3] == 1 : (string2 = this.markCmlNo[n3] < 0 ? this.markKey[n3] : (String)this.table.getValue(n, this.markCmlNo[n3])) != null && !string2.isEmpty() && (string = this.markListNo[n3] < 0 ? this.markLists[n3] : (String)this.table.getValue(n, this.markListNo[n3])) != null && !string.isEmpty() && string.indexOf(string2) >= 0)) continue;
            return n3;
        }
        return -1;
    }

    @Override
    public int[] getColumnNos() {
        return new int[0];
    }
}

