/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.opengion.fukurou.model.POIUtil;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.ImageUtil;

public class ExcelModel {
    private static final String VERSION = "6.2.0.0 (2015/02/27)";
    private static final String DEF_SHEET_NAME = "Sheet";
    private static final Map<String, Integer> PICTURE_TYPE = new HashMap<String, Integer>();
    private final String inFilename;
    private final String sufix;
    private final Workbook wkbook;
    private Sheet sheet;
    private Row rowObj;
    private int refSheetIdx = -1;
    private int maxSheetIdx = -1;
    private final CreationHelper createHelper;
    private CellStyle style;
    private CellStyle hLinkStyle;
    private int maxColCount = 5;
    private int dataStartRow = -1;
    private boolean isAutoCellSize;
    private String addTitleSheet;

    public ExcelModel(File file) {
        this(file, true);
    }

    public ExcelModel(File file, boolean bl) {
        this.inFilename = file.getName();
        int n = this.inFilename.lastIndexOf(46);
        if (n < 0) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u306e\u62e1\u5f35\u5b50\u304c\u898b\u5f53\u305f\u308a\u307e\u305b\u3093\u3002(.xls \u304b .xlsx \u3092\u6307\u5b9a\u4e0b\u3055\u3044)" + HybsConst.CR + " filename=[" + file + "]" + HybsConst.CR;
            throw new IllegalArgumentException(string);
        }
        this.sufix = this.inFilename.substring(n).toLowerCase(Locale.JAPAN);
        if (bl) {
            this.wkbook = POIUtil.createWorkbook(file);
            this.maxSheetIdx = this.wkbook.getNumberOfSheets() - 1;
        } else if (".xlsx".equals(this.sufix)) {
            this.wkbook = new XSSFWorkbook();
        } else if (".xls".equals(this.sufix)) {
            this.wkbook = new HSSFWorkbook();
        } else {
            String string = "\u30d5\u30a1\u30a4\u30eb\u306e\u62e1\u5f35\u5b50\u304c\u4e0d\u6b63\u3067\u3059\u3002(.xls \u304b .xlsx \u306e\u307f\u53ef\u80fd)" + HybsConst.CR + " filename=[" + file + "]" + HybsConst.CR;
            throw new IllegalArgumentException(string);
        }
        this.createHelper = this.wkbook.getCreationHelper();
    }

    public void setFont(String string, short s) {
        if (this.style == null) {
            this.style = this.wkbook.createCellStyle();
        }
        Font font = this.wkbook.createFont();
        if (string != null) {
            font.setFontName(string);
        }
        if (s > 0) {
            font.setFontHeightInPoints(s);
        }
        this.style.setFont(font);
    }

    public void setCellStyle() {
        if (this.style == null) {
            this.style = this.wkbook.createCellStyle();
        }
        this.style.setBorderBottom((short)1);
        this.style.setBorderLeft((short)1);
        this.style.setBorderRight((short)1);
        this.style.setBorderTop((short)1);
        this.style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        this.style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        this.style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        this.style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        this.style.setVerticalAlignment((short)0);
    }

    public void useAutoCellSize(boolean bl) {
        this.isAutoCellSize = bl;
    }

    public void useAutoCellSize(boolean bl, int n) {
        this.isAutoCellSize = bl;
        this.maxColCount = n;
    }

    public void setDataStartRow(int n) {
        this.dataStartRow = n;
    }

    public void setAddTitleSheet(String string) {
        this.addTitleSheet = string;
    }

    public int getNumberOfSheets() {
        return this.wkbook.getNumberOfSheets();
    }

    public void setRefSheetName(String string) {
        int n = this.refSheetIdx = string == null ? 0 : this.wkbook.getSheetIndex(string);
        if (this.refSheetIdx < 0) {
            String string2 = "\u6307\u5b9a\u306e\u53c2\u7167\u30b7\u30fc\u30c8\u540d\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsConst.CR + " inFilename=[" + this.inFilename + "] , refSheetName=[" + string + "]" + HybsConst.CR;
            throw new IllegalArgumentException(string2);
        }
    }

    public void createSheet(String string) {
        if (this.refSheetIdx >= 0) {
            this.sheet = this.wkbook.cloneSheet(this.refSheetIdx++);
            if (this.refSheetIdx > this.maxSheetIdx) {
                this.refSheetIdx = this.maxSheetIdx;
            }
        } else {
            this.sheet = this.wkbook.createSheet();
        }
        int n = this.wkbook.getNumberOfSheets() - 1;
        this.setSheetName(n, string);
    }

    public void setSheetName(int n, String string) {
        String string2 = string == null ? DEF_SHEET_NAME : WorkbookUtil.createSafeSheetName((String)string);
        int n2 = 1;
        while (this.wkbook.getSheetIndex(string2) >= 0) {
            string2 = WorkbookUtil.createSafeSheetName((String)(string + "(" + n2 + ")"));
            ++n2;
            if (string2.length() < 31) continue;
            string2 = string2.substring(0, 27);
        }
        this.wkbook.setSheetName(n, string2);
    }

    public String getSheetName(int n) {
        int n2 = this.wkbook.getNumberOfSheets();
        String string = null;
        if (n < n2) {
            this.sheet = this.wkbook.getSheetAt(n);
            string = this.sheet.getSheetName();
        }
        return string;
    }

    public int getSheetNo(String string) {
        this.sheet = this.wkbook.getSheet(string);
        return this.wkbook.getSheetIndex(string);
    }

    public void removeSheet(int n, int n2) {
        for (int i = n2; i >= n; --i) {
            this.wkbook.removeSheetAt(i);
        }
    }

    public int getFirstRowNum() {
        return this.sheet.getFirstRowNum();
    }

    public int getLastRowNum() {
        return this.sheet.getLastRowNum();
    }

    public void createRow(int n) {
        this.rowObj = this.sheet.getRow(n);
        if (this.rowObj == null) {
            this.rowObj = this.sheet.createRow(n);
        }
    }

    public void removeRow(int n) {
        int n2;
        int n3 = n;
        for (int i = n2 = this.sheet.getLastRowNum(); i >= n3; --i) {
            Row row = this.sheet.getRow(i);
            if (row == null) continue;
            this.sheet.removeRow(row);
        }
    }

    public void removeCell(int n) {
        int n2;
        int n3 = n;
        for (int i = n2 = this.rowObj.getLastCellNum(); i >= n3; --i) {
            Cell cell = this.rowObj.getCell(i);
            if (cell == null) continue;
            this.rowObj.removeCell(cell);
        }
    }

    public void setValues(String[] stringArray, int n) {
        if (this.rowObj == null) {
            this.createRow(n);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.setCellValue(stringArray[i], i);
            }
        }
    }

    public void setValues(String[] stringArray, int n, boolean[] blArray) {
        if (this.rowObj == null) {
            this.createRow(n);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.setCellValue(stringArray[i], i, blArray[i]);
            }
        }
    }

    public void setCellValue(String string, int n) {
        this.setCellValue(string, n, false);
    }

    public void setCellValue(String string, int n, boolean bl) {
        Double d;
        Cell cell = this.rowObj.getCell(n);
        if (cell == null) {
            cell = this.rowObj.createCell(n);
        }
        if (this.style != null) {
            cell.setCellStyle(this.style);
        }
        if (bl && (d = this.parseDouble(string)) != null) {
            cell.setCellValue(d.doubleValue());
            return;
        }
        d = this.createHelper.createRichTextString(string);
        cell.setCellValue((RichTextString)d);
    }

    public void setCellLink(String string, int n) {
        Hyperlink hyperlink;
        if (string == null || string.isEmpty()) {
            return;
        }
        Cell cell = this.rowObj.getCell(n);
        if (cell == null) {
            cell = this.rowObj.createCell(n);
        }
        if (this.hLinkStyle == null) {
            this.hLinkStyle = this.wkbook.createCellStyle();
            if (this.style != null) {
                this.hLinkStyle.cloneStyleFrom(this.style);
            }
            hyperlink = this.wkbook.createFont();
            hyperlink.setColor(IndexedColors.BLUE.getIndex());
            hyperlink.setUnderline((byte)1);
            this.hLinkStyle.setFont((Font)hyperlink);
        }
        cell.setCellStyle(this.hLinkStyle);
        hyperlink = this.createHelper.createHyperlink(2);
        hyperlink.setAddress("'" + string + "'!A1");
        cell.setHyperlink(hyperlink);
    }

    public String[] getValues(int n) {
        this.rowObj = this.sheet.getRow(n);
        if (this.rowObj == null) {
            return null;
        }
        int n2 = this.rowObj.getLastCellNum();
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            Cell cell = this.rowObj.getCell(i);
            stringArray[i] = POIUtil.getValue(cell);
        }
        return stringArray;
    }

    public String getValue(int n, int n2) {
        this.rowObj = this.sheet.getRow(n);
        if (this.rowObj == null) {
            return null;
        }
        Cell cell = this.rowObj.getCell(n2);
        return POIUtil.getValue(cell);
    }

    public void addImageFile(String string, int n, int n2, int n3) {
        this.addImageFile(string, n, n2, n3, n2, n3, 0, 0, 0, 0);
    }

    public void addImageFile(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        String string2 = ImageUtil.getSuffix(string);
        Integer n10 = PICTURE_TYPE.get(string2);
        int n11 = n10 != null ? n10 : 6;
        byte[] byArray = ImageUtil.byteImage(string);
        int n12 = this.wkbook.addPicture(byArray, n11);
        Sheet sheet = this.wkbook.getSheetAt(n);
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor clientAnchor = drawing.createAnchor(n6, n7, n8, n9, n3, n2, n5, n4);
        clientAnchor.setAnchorType(2);
        Picture picture = drawing.createPicture(clientAnchor, n12);
        if (n2 == n4 || n3 == n5) {
            picture.resize();
        }
    }

    public void saveFile(File file) {
        File file2;
        String string = file.getName();
        if (string.toLowerCase(Locale.JAPAN).endsWith(this.sufix)) {
            file2 = file;
        } else {
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            file2 = new File(file.getParent(), string + this.sufix);
        }
        if (this.isAutoCellSize) {
            POIUtil.autoCellSize(this.wkbook, this.maxColCount, this.dataStartRow);
        }
        if (this.addTitleSheet != null) {
            this.makeAddTitleSheet();
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            this.wkbook.write((OutputStream)bufferedOutputStream);
        }
        catch (IOException iOException) {
            try {
                String string2 = "\u30d5\u30a1\u30a4\u30eb\u3078\u66f8\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "  File=" + file2 + HybsConst.CR + iOException.getMessage();
                throw new RuntimeException(string2, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedOutputStream);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedOutputStream);
    }

    private void makeAddTitleSheet() {
        this.sheet = this.wkbook.createSheet();
        String string = this.sheet.getSheetName();
        this.wkbook.setSheetOrder(string, 0);
        this.setSheetName(0, this.addTitleSheet);
        int n = 0;
        this.createRow(n++);
        this.setCellValue("No", 0);
        this.setCellValue(DEF_SHEET_NAME, 1);
        this.sheet.autoSizeColumn(0);
        this.sheet.autoSizeColumn(1);
        int n2 = this.wkbook.getNumberOfSheets();
        int n3 = 1;
        while (n3 < n2) {
            String string2 = this.wkbook.getSheetName(n3);
            this.createRow(n);
            this.setCellValue(String.valueOf(n), 0, true);
            this.setCellValue(string2, 1);
            this.setCellLink(string2, 1);
            ++n3;
            ++n;
        }
    }

    public void activeWorkbook(boolean bl) {
        POIUtil.activeWorkbook(this.wkbook, bl);
    }

    private Double parseDouble(String string) {
        Double d = null;
        try {
            if (string == null || string.isEmpty() || string.equals("_")) {
                d = null;
            } else if (string.indexOf(44) < 0) {
                d = Double.valueOf(string);
            } else {
                char[] cArray = string.toCharArray();
                int n = 0;
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] == ',') continue;
                    cArray[n] = cArray[i];
                    ++n;
                }
                d = Double.valueOf(String.valueOf(cArray, 0, n));
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = "Double\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsConst.CR + numberFormatException.getMessage() + HybsConst.CR + "  value=" + string;
            System.err.println(string2);
            d = null;
        }
        return d;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java org.opengion.fukurou.model.ExcelModel \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d [\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u540d] \u30fb\u30fb\u30fb\n\t-CS      CellStyle\u3092 \u8a2d\u5b9a\u3057\u307e\u3059\u3002        \n\t-AS      useAutoCellSize\u3092 \u8a2d\u5b9a\u3057\u307e\u3059\u3002  \n\t-FN=***  FontName\u3092 \u8a2d\u5b9a\u3057\u307e\u3059\u3002         \n\t-FP=**   FontPoint\u3092 \u8a2d\u5b9a\u3057\u307e\u3059\u3002        \n\t-IMG     \u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u3092\u633f\u5165\u3057\u307e\u3059\u3002      \n\t     (-IMG \u30d5\u30a1\u30a4\u30eb\u540d \u30b7\u30fc\u30c8\u756a\u53f7 \u884c \u5217)  \n");
            return;
        }
        ExcelModel excelModel = new ExcelModel(new File(stringArray[0]), true);
        excelModel.activeWorkbook(true);
        if (stringArray.length > 1) {
            File file = new File(stringArray[1]);
            boolean bl = false;
            boolean bl2 = false;
            String string = null;
            short s = -1;
            for (int i = 2; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2.equalsIgnoreCase("-CS")) {
                    bl = true;
                }
                if (string2.equalsIgnoreCase("-AS")) {
                    bl2 = true;
                }
                if (string2.startsWith("-FN")) {
                    string = string2.substring(3);
                }
                if (string2.startsWith("-FP")) {
                    s = Short.parseShort(string2.substring(3));
                }
                if (!string2.equalsIgnoreCase("-IMG")) continue;
                String string3 = stringArray[++i];
                int n = Integer.parseInt(stringArray[++i]);
                int n2 = Integer.parseInt(stringArray[++i]);
                int n3 = Integer.parseInt(stringArray[++i]);
                excelModel.addImageFile(string3, n, n2, n3);
            }
            if (bl) {
                excelModel.setCellStyle();
            }
            excelModel.useAutoCellSize(bl2);
            excelModel.setFont(string, s);
            excelModel.saveFile(file);
        } else {
            StringBuilder stringBuilder = new StringBuilder(200);
            int n = excelModel.getNumberOfSheets();
            for (int i = 0; i < n; ++i) {
                String string = excelModel.getSheetName(i);
                int n4 = excelModel.getFirstRowNum();
                int n5 = excelModel.getLastRowNum();
                for (int j = n4; j <= n5; ++j) {
                    stringBuilder.setLength(0);
                    stringBuilder.append(string).append('\t').append(j);
                    String[] stringArray2 = excelModel.getValues(j);
                    if (stringArray2 != null) {
                        for (int k = 0; k < stringArray2.length; ++k) {
                            String string4 = stringArray2[k] == null ? "" : stringArray2[k];
                            stringBuilder.append('\t').append(string4);
                        }
                    }
                    System.out.println(stringBuilder);
                }
                System.out.println();
            }
        }
    }

    static {
        PICTURE_TYPE.put("png", 6);
        PICTURE_TYPE.put("jpeg", 5);
        PICTURE_TYPE.put("jpg", 5);
    }
}

