<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0020"
	title    = "データロール"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
>
	5.6.6.0 2013/07/05 ROLE検索方法変更
</og:comment>

<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true">
	<og:value command="SET" key="C_ROLES" value="ROLE" />
</og:equals>
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true" notEquals="true">
	<og:value command="SET" key="C_ROLES" value="ROLES" />
</og:equals>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,GUIKEY,NAME_JA,ROLES"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select case
				when A.GUILVL = '1' then '0'
				when A.GUILVL = '2' then '0'
				else '1' end WRITABLE
				,A.SYSTEM_ID,A.GUIKEY, A.NAME_JA, A.ROLES, A.UNIQ, 'RLS_'{@DBF.CON}B.{@C_ROLES} TMP_ROLE
				,case when '|'{@DBF.CON}A.ROLES{@DBF.CON}'|' like '%|'{@DBF.CON}B.{@C_ROLES}{@DBF.CON}'|%' then '1' else '0' end IS_CHECK
		from	GEA11 A inner join GEA05 B
		on		A.SYSTEM_ID	= B.SYSTEM_ID
		<og:where startKey="and">
			<og:and value = "B.{@C_ROLES}{@DBF.CON}'|'	like '%{@ROLES}'" />
			<og:and value = "B.KBROLE	= '1'" />
			<og:and value = "B.FGJ		= '1'" />
		</og:where>
	<og:where>
		<og:and value = "A.FGJ					=		'1'"			/>
		<!--<og:and value = "SUBSTR(A.RWMODE,1,1)	=		'm'"			/>-->
		<og:and value = "A.RWMODE				like	'{@RWMODE}'"	/>
		<og:and value = "A.SYSTEM_ID			=		'{@SYSTEM_ID}'"	/>
		<og:and value = "A.GUIKEY				like	'{@GUIKEY}'"	/>
		<og:and value = "A.NAME_JA				like	'{@NAME_JA}'"	/>
		<og:and value = "'|'{@DBF.CON}A.ROLES{@DBF.CON}'|'	like	'%{@ROLES}'"	/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SYSTEM_ID,A.SEQNO,B.{@C_ROLES}" />
</og:query>

<og:tableFilter classId="ROTATE" selectedAll="true"
	keys="ROTATE_CLM,KEY_CLM,VALUE_CLM" vals='TMP_ROLE,"WRITABLE,SYSTEM_ID,GUIKEY,NAME_JA,ROLES,UNIQ",IS_CHECK' />

<og:columnEditor columns="ROLES" renderer="SLABEL" param="4" />

<og:columnEditor columns="RLS*" renderer="chbox" editor="chbox" />
<og:columnEditor columns="RLS*" useLabelMap="true">
	select 'RLS_'{@DBF.CON}{@C_ROLES}, NMROLE{@DBF.CON}'&lt;br&gt;('{@DBF.CON}{@C_ROLES}{@DBF.CON}')'
	from GEA05
	where SYSTEM_ID	= '{@SYSTEM_ID}'
	and KBROLE		= '1'
	and FGJ			= '1'
</og:columnEditor>

<table border="1">
	<tr>
		<td><b><og:message lbl="GEM0037" /></b></td>
		<td><og:message lbl="GEM0036" /></td>
	</tr>
	<tr>
		<td><b><og:message lbl="GEM0038" /></b></td>
		<td><og:message lbl="GEM0039" /></td>
	</tr>
</table>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
		keys="noWritable,noDisplay" vals='"GUIKEY,NAME_JA,ROLES","SYSTEM_ID,UNIQ"' />
	<og:submit  value="update"   lbl="DIRECT_MODIFY"    command="MODIFY" accesskey="C"
		keys="columnWritable,noDisplay,direct" vals='"ROLES","SYSTEM_ID,UNIQ",true' />

	<og:link gamenId="GE0017" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,KBROLE,FGJ"
		vals="NEW,{@SYSTEM_ID},1,1">[{@LBL.GE0017}]</og:link>
	<og:link gamenId="GE0019" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,KBROLE"
		vals="NEW,{@SYSTEM_ID},1">[{@LBL.GE0019}]</og:link>
<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "SYSTEM_ID,UNIQ"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
