/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.FileInfo;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.io.TableReader;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class ReadTableTag
extends CommonTagSupport {
    private static final String VERSION = "6.2.1.0 (2015/03/13)";
    private static final long serialVersionUID = 621020150313L;
    private static final int ERROR_ROW_COUNT = 200;
    public static final String CMD_NEW = "NEW";
    public static final String CMD_RENEW = "RENEW";
    private static final String[] COMMAND_LIST = new String[]{"NEW", "RENEW"};
    private static final String[] AUTO_READER_CLASS = new String[]{"Excel", "Calc", "Text", "Text", "Text", "Text"};
    private static final String[] AUTO_READER_ENCODE = new String[]{null, null, "UnicodeLittle", "Windows-31J", "UTF-8", "EUC-JP"};
    private static final String[] AUTO_READER_SUFIX = new String[]{"xls,xlsx", "ods", null, null, null, null};
    private String separator = "\t";
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String filename = HybsSystem.sys("FILE_FILENAME");
    private String encode = HybsSystem.sys("FILE_ENCODE");
    private String readerClass = null;
    private int maxRowCount = -1;
    private String displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
    private String overflowMsg = "MSG0007";
    private String notfoundMsg = "MSG0077";
    private int executeCount = -1;
    private String modifyType;
    private String adjustColumns;
    private String checkColumns;
    private String nullCheck;
    private transient DBTableModel table;
    private String command = "NEW";
    private String tableId = "h_tblmdl";
    private String sheetName;
    private String sheetNos;
    private String sheetConstKeys;
    private String sheetConstAdrs;
    private String nullBreakClm;
    private String columns;
    private String omitNames;
    private boolean useNumber = true;
    private boolean stopZero;
    private boolean isMainTrans = true;
    private int skipRowCount;
    private boolean useRenderer = HybsSystem.sysBool("USE_TABLE_READER_RENDERER");

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        if (this.check(this.command, COMMAND_LIST)) {
            int n;
            String[] stringArray;
            String[] stringArray2;
            String[] stringArray3;
            this.useMainTrans(this.isMainTrans);
            this.startQueryTransaction(this.tableId);
            if ("session".equals(this.getScope())) {
                this.removeSessionAttribute(this.tableId);
                this.removeSessionAttribute("h_vform");
            }
            if (this.maxRowCount < 0) {
                this.maxRowCount = this.sysInt("DB_MAX_ROW_COUNT");
            }
            if (this.readerClass == null) {
                this.readerClass = StringUtil.nval((String)this.sys("TABLE_READER_DEFAULT_CLASS"), (String)"AutoReader");
            }
            if ("AutoReader".equalsIgnoreCase(this.readerClass)) {
                if (this.columns != null && this.columns.length() > 0) {
                    throw new HybsSystemException("columns\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u308b\u5834\u5408\u306f\u3001readerClass=\"AutoReader\"\u306f\u4f7f\u3048\u307e\u305b\u3093");
                }
                stringArray3 = AUTO_READER_CLASS;
                stringArray2 = AUTO_READER_ENCODE;
                stringArray = AUTO_READER_SUFIX;
            } else {
                stringArray3 = new String[]{this.readerClass};
                stringArray2 = new String[]{this.encode};
                stringArray = new String[]{null};
            }
            String string = HybsSystem.url2dir(this.fileURL);
            File file = new File(string, this.filename);
            String string2 = new FileInfo((File)file).SUFIX;
            StringBuilder stringBuilder = new StringBuilder(200);
            for (n = 0; n < stringArray3.length; ++n) {
                if (stringArray[n] != null && stringArray[n].indexOf(string2) < 0) continue;
                this.readerClass = stringArray3[n];
                this.encode = stringArray2[n];
                if (this.isDebug()) {
                    String string3 = "File=[" + file + "] , class=[" + this.readerClass + "] , encode=[" + this.encode + "]" + BR;
                    this.jspPrint(string3);
                    System.out.println(string3);
                }
                try {
                    this.create(file);
                    stringBuilder = null;
                    break;
                }
                catch (Throwable throwable) {
                    stringBuilder.append("File=[").append(file).append("] , Class=[").append(this.readerClass).append("] , Encode=[").append(this.encode).append("] Error!").append(CR).append(throwable.getMessage()).append(CR).append(StringUtil.ogStackTrace((Throwable)throwable)).append(CR);
                }
            }
            if (stringBuilder != null) {
                String string4 = stringBuilder.toString();
                System.err.print(string4);
                throw new HybsSystemException(string4);
            }
            if (this.table != null) {
                ErrorMessage errorMessage;
                this.executeCount = this.table.getRowCount();
                if (this.modifyType != null) {
                    for (n = 0; n < this.executeCount; ++n) {
                        this.table.setModifyType(n, this.modifyType);
                    }
                }
                if ((errorMessage = this.checkTableColumn(this.table)) != null && !errorMessage.isOK()) {
                    this.jspPrint(TaglibUtil.makeHTMLErrorTable(errorMessage, this.getResource()));
                    return 5;
                }
            }
            if (!this.commitTableObject(this.tableId, this.table)) {
                this.jspPrint("ReadTableTag Query\u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
                return 5;
            }
            StringBuilder stringBuilder2 = new StringBuilder(200);
            if (CMD_NEW.equals(this.command)) {
                if (this.executeCount > 0 && this.displayMsg != null && this.displayMsg.length() > 0) {
                    stringBuilder2.append(this.executeCount);
                    stringBuilder2.append(this.getResource().getLabel(this.displayMsg));
                    stringBuilder2.append(BR);
                } else if (this.executeCount == 0 && this.notfoundMsg != null && this.notfoundMsg.length() > 0) {
                    stringBuilder2.append(this.getResource().getLabel(this.notfoundMsg));
                    stringBuilder2.append(BR);
                }
            }
            this.setRequestAttribute("DB.COUNT", String.valueOf(this.executeCount));
            if (this.table != null && this.table.isOverflow() && this.overflowMsg != null && this.overflowMsg.length() > 0) {
                stringBuilder2.append(this.getResource().getLabel(this.overflowMsg));
                stringBuilder2.append(BR);
            }
            this.jspPrint(stringBuilder2.toString());
        }
        int n = this.executeCount == 0 && this.stopZero ? 5 : 6;
        return n;
    }

    @Override
    protected void release2() {
        super.release2();
        this.separator = "\t";
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.filename = HybsSystem.sys("FILE_FILENAME");
        this.encode = HybsSystem.sys("FILE_ENCODE");
        this.readerClass = null;
        this.maxRowCount = -1;
        this.displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
        this.overflowMsg = "MSG0007";
        this.notfoundMsg = "MSG0077";
        this.executeCount = -1;
        this.modifyType = null;
        this.command = CMD_NEW;
        this.table = null;
        this.tableId = "h_tblmdl";
        this.sheetName = null;
        this.sheetNos = null;
        this.sheetConstKeys = null;
        this.sheetConstAdrs = null;
        this.nullBreakClm = null;
        this.columns = null;
        this.omitNames = null;
        this.useNumber = true;
        this.adjustColumns = null;
        this.checkColumns = null;
        this.nullCheck = null;
        this.stopZero = false;
        this.isMainTrans = true;
        this.skipRowCount = 0;
        this.useRenderer = HybsSystem.sysBool("USE_TABLE_READER_RENDERER");
    }

    protected void create(File file) {
        String string = HybsSystem.sys("TableReader_" + this.readerClass);
        if (string == null) {
            String string2 = "TableReader \u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002class=TableReader_" + this.readerClass;
            throw new RuntimeException(string2);
        }
        TableReader tableReader = (TableReader)HybsSystem.newInstance(string);
        this.table = DBTableModelUtil.newDBTable();
        tableReader.setResourceManager(this.getResource());
        tableReader.setSeparator(this.separator);
        tableReader.setColumns(this.columns);
        tableReader.setOmitNames(this.omitNames);
        tableReader.setUseNumber(this.useNumber);
        tableReader.setMaxRowCount(this.maxRowCount);
        tableReader.setSkipRowCount(this.skipRowCount);
        tableReader.setUseRenderer(this.useRenderer);
        tableReader.setDBTableModel(this.table);
        tableReader.setDebug(this.isDebug());
        tableReader.setSheetName(this.sheetName);
        tableReader.setSheetNos(this.sheetNos);
        tableReader.setSheetConstData(this.sheetConstKeys, this.sheetConstAdrs);
        tableReader.setNullBreakClm(this.nullBreakClm);
        tableReader.readDBTable(file, this.encode);
    }

    private int[] makeClmNos(String string, DBTableModel dBTableModel) {
        int[] nArray;
        if (string == null) {
            nArray = new int[]{};
        } else if ("*".equals(string)) {
            int n = dBTableModel.getColumnCount();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
        } else {
            String[] stringArray = StringUtil.csv2Array((String)string);
            int n = stringArray.length;
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = dBTableModel.getColumnNo(stringArray[i]);
            }
        }
        return nArray;
    }

    private ErrorMessage checkTableColumn(DBTableModel dBTableModel) {
        ErrorMessage errorMessage = new ErrorMessage("Check Columns Error!");
        int n = dBTableModel.getRowCount();
        int[] nArray = this.makeClmNos(this.adjustColumns, dBTableModel);
        int[] nArray2 = this.makeClmNos(this.checkColumns, dBTableModel);
        int[] nArray3 = this.makeClmNos(this.nullCheck, dBTableModel);
        boolean bl = nArray.length > 0;
        DBColumn[] dBColumnArray = dBTableModel.getDBColumns();
        for (int i = 0; i < n; ++i) {
            Object object;
            int n2;
            int n3;
            String[] stringArray = (String[])dBTableModel.getValues(i);
            boolean bl2 = false;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                stringArray[n2] = dBColumnArray[n2].valueSet(stringArray[n2]);
            }
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                n2 = nArray2[n3];
                object = dBColumnArray[n2].valueCheck(stringArray[n2]);
                if (object.getKekka() <= 0) continue;
                bl2 = true;
                errorMessage.append(i + 1, dBColumnArray[n2].valueCheck(stringArray[n2]));
            }
            for (n3 = 0; n3 < nArray3.length; ++n3) {
                n2 = nArray3[n3];
                if (stringArray[n2] != null && !stringArray[n2].isEmpty()) continue;
                bl2 = true;
                object = dBColumnArray[n2].getLabel();
                errorMessage.addMessage(i + 1, 2, "ERR0012", new String[]{object});
            }
            if (this.isDebug() && bl2) {
                errorMessage.addMessage(i + 1, 2, "Debug", (String[])dBTableModel.getValues(i));
            }
            if (bl && !bl2) {
                dBTableModel.setValues(stringArray, i);
            }
            if (errorMessage.size() > 200) break;
        }
        return errorMessage;
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setSeparator(String string) {
        this.separator = StringUtil.nval((String)this.getRequestParameter(string), (String)this.separator);
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2, (String[])new String[0]);
        }
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.filename);
    }

    public void setEncode(String string) {
        this.encode = StringUtil.nval((String)this.getRequestParameter(string), (String)this.encode);
    }

    public void setReaderClass(String string) {
        this.readerClass = StringUtil.nval((String)this.getRequestParameter(string), (String)this.readerClass);
        if ("Default".equals(this.readerClass)) {
            this.readerClass = "Text";
        }
    }

    public void setMaxRowCount(String string) {
        this.maxRowCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.maxRowCount);
        if (this.maxRowCount == 0) {
            this.maxRowCount = Integer.MAX_VALUE;
        }
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() > 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setDisplayMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.displayMsg = string2;
        }
    }

    public void setOverflowMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.overflowMsg = string2;
        }
    }

    public void setNotfoundMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.notfoundMsg = string2;
        }
    }

    public void setModifyType(String string) {
        this.modifyType = this.getRequestParameter(string);
    }

    public void setSheetName(String string) {
        this.sheetName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sheetName);
    }

    public void setSheetNos(String string) {
        this.sheetNos = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sheetNos);
        if (this.sheetNos != null && this.sheetNos.length() > 0) {
            boolean bl = false;
            for (int i = 0; i < this.sheetNos.length(); ++i) {
                char c = this.sheetNos.charAt(i);
                if (c == '-' || c == ',' || c == '*' && (i == 0 || i == this.sheetNos.length() - 1) || c >= '0' && c <= '9') continue;
                bl = true;
                break;
            }
            if (bl) {
                String string2 = "sheetNos \u306e\u6307\u5b9a\u3092\u898b\u76f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002sheetNos=[" + this.sheetNos + "]";
                throw new HybsSystemException(string2);
            }
        }
    }

    public void setSheetConstKeys(String string) {
        this.sheetConstKeys = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setSheetConstAdrs(String string) {
        this.sheetConstAdrs = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setNullBreakClm(String string) {
        this.nullBreakClm = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setColumns(String string) {
        this.columns = StringUtil.nval((String)this.getRequestParameter(string), (String)this.columns);
    }

    public void setOmitNames(String string) {
        this.omitNames = StringUtil.nval((String)this.getRequestParameter(string), (String)this.omitNames);
    }

    public void setCheckColumns(String string) {
        this.checkColumns = StringUtil.nval((String)this.getRequestParameter(string), (String)this.checkColumns);
    }

    public void setAdjustColumns(String string) {
        this.adjustColumns = StringUtil.nval((String)this.getRequestParameter(string), (String)this.adjustColumns);
    }

    public void setNullCheck(String string) {
        this.nullCheck = StringUtil.nval((String)this.getRequestParameter(string), (String)this.nullCheck);
    }

    public void setUseNumber(String string) {
        this.useNumber = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useNumber);
    }

    public void setStopZero(String string) {
        this.stopZero = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.stopZero);
    }

    public void setMainTrans(String string) {
        this.isMainTrans = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isMainTrans);
    }

    public void setSkipRowCount(String string) {
        this.skipRowCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.skipRowCount);
    }

    public void setUseRenderer(String string) {
        this.useRenderer = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useRenderer);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("separator", (Object)this.separator).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).println("encode", (Object)this.encode).println("readerClass", (Object)this.readerClass).println("maxRowCount", (Object)this.maxRowCount).println("displayMsg", (Object)this.displayMsg).println("executeCount", (Object)this.executeCount).println("modifyType", (Object)this.modifyType).println("checkColumns", (Object)this.checkColumns).println("adjustColumns", (Object)this.adjustColumns).println("nullCheck", (Object)this.nullCheck).println("command", (Object)this.command).println("tableId", (Object)this.tableId).println("sheetName", (Object)this.sheetName).println("sheetNos", (Object)this.sheetNos).println("columns", (Object)this.columns).println("useNumber", (Object)this.useNumber).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

