<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC15"
	title	= "インクルードファイル検索"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID"
/>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select TAGNAME,SRC_FILE,count(*) as CNT
		from GF75
		where SYSTEM_ID = '{@SYSTEM_ID}'
		and   TBLSYU    = '{@TBLSYU}'
		and   FGJ       in  ('0','1')
	<og:where startKey = "and" >
		<og:and value = "FGOMIT		= '{@FGOMIT}'"			/>
		<og:and value = "ADDRESS	like '{@ADDRESS}'"		/>
		<og:and value = "FILENAME	like '{@FILENAME}'"	/>
		<og:and value = "TAGNAME	like '{@TAGNAME}'"		/>
		<og:and value = "MODIFIED {@CONDITION} '{@MODIFIED}'" />
		<og:and value = "SRC_FILE	like '{@SRC_FILE}'"	/>
	</og:where>
		group by TAGNAME,SRC_FILE
		order by TAGNAME,SRC_FILE
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="SRC_FILE" gamenId="DOC15" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,TBLSYU,FGOMIT,SRC_FILE"
		vals="NEW,{@SYSTEM_ID},{@TBLSYU},{@FGOMIT},[SRC_FILE]" />
</og:viewLink>

<b><og:link href="result.jsp" keys="command,displayMsg" vals="RENEW,　" >{@LBL.UNGRPTAG}</og:link></b>
<br />

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	writable   = "false"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
