/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.File;
import java.io.IOException;
import org.opengion.fukurou.util.ConnectIF;
import org.opengion.fukurou.util.HybsConst;

public abstract class AbstractConnect
implements ConnectIF {
    protected static final String CR = HybsConst.CR;
    protected static final int BUFFER_MIDDLE = 200;
    private final StringBuilder errMsg = new StringBuilder(200);
    public static final boolean FLAG_OK = true;
    public static final boolean FLAG_NG = false;
    public static final int TIMEOUT = 600;
    protected String host;
    protected String user;
    protected String passwd;
    protected String port;
    protected boolean isMkdirs = true;
    protected int timeout = 600;
    protected boolean isDisplay;
    protected boolean isDebug;

    @Override
    public abstract void connect();

    @Override
    public void action(String string, String string2, String string3) {
        block10: {
            String string4 = string3.replace('\\', '/');
            if (this.isDisplay) {
                System.out.println("ACTION: command=" + string + ",localFile=" + string2 + ",remoteFile=" + string4);
            }
            try {
                if ("GET".equals(string)) {
                    this.actionGET(string2, string4);
                    break block10;
                }
                if ("PUT".equals(string)) {
                    this.actionPUT(string2, string4);
                    break block10;
                }
                if ("DEL".equals(string)) {
                    this.actionDEL(string4);
                    break block10;
                }
                if ("GETDIR".equals(string)) {
                    this.actionGETdir(string2, string4);
                    break block10;
                }
                if ("PUTDIR".equals(string)) {
                    this.actionPUTdir(string2, string4);
                    break block10;
                }
                if ("DELDIR".equals(string)) {
                    this.actionDELdir(string4);
                    break block10;
                }
                this.errAppend((Object)"command\u306f\u3001GET/PUT/DEL/GETDIR/PUTDIR/DELDIR \u304b\u3089\u6307\u5b9a\u304f\u3060\u3055\u3044\u3002");
                this.errAppend("   command    = [", string, "]");
                throw new RuntimeException(this.getErrMsg());
            }
            catch (IOException iOException) {
                this.errAppend((Object)"Server action Error.");
                this.errAppend("   command    = [", string, "]");
                this.errAppend("   localFile  = [", string2, "]");
                this.errAppend("   remoteFile = [", string3, "]");
                this.errAppend((Object)iOException.getMessage());
                if (this.isDebug) {
                    iOException.printStackTrace();
                }
                throw new RuntimeException(this.getErrMsg(), iOException);
            }
        }
    }

    @Override
    public abstract void disconnect();

    protected abstract void actionGET(String var1, String var2) throws IOException;

    protected abstract void actionGETdir(String var1, String var2) throws IOException;

    protected abstract void actionPUT(String var1, String var2) throws IOException;

    protected void actionPUTdir(String string, String string2) throws IOException {
        File[] fileArray = new File(string).listFiles();
        if (fileArray == null) {
            this.errAppend((Object)"\u6307\u5b9a\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u3001\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093\u3002");
            this.errAppend("   localDir   = [", string, "]");
            throw new RuntimeException(this.getErrMsg());
        }
        for (int i = 0; i < fileArray.length; ++i) {
            String string3 = fileArray[i].getName();
            if (fileArray[i].isDirectory()) {
                this.actionPUTdir(this.addFile(string, string3), this.addFile(string2, string3));
                continue;
            }
            this.actionPUT(this.addFile(string, string3), this.addFile(string2, string3));
        }
    }

    protected abstract void actionDEL(String var1) throws IOException;

    protected abstract void actionDELdir(String var1) throws IOException;

    protected void makeLocalDir(String string) throws IOException {
        File file = new File(string).getCanonicalFile().getParentFile();
        if (!file.exists() && !file.mkdirs()) {
            this.errAppend((Object)"\u30ed\u30fc\u30ab\u30eb\u30d5\u30a1\u30a4\u30eb\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            this.errAppend("   localFile   = [", string, "]");
            throw new RuntimeException(this.getErrMsg());
        }
    }

    protected String addFile(String string, String string2) {
        char c = string.charAt(string.length() - 1);
        char c2 = string2.charAt(0);
        String string3 = c == '/' || c == '\\' ? (c2 == '/' || c2 == '\\' ? string + string2.substring(1) : string + string2) : (c2 == '/' || c2 == '\\' ? string + string2 : string + "/" + string2);
        return string3;
    }

    @Override
    public void setHostUserPass(String string, String string2, String string3) {
        this.host = string;
        this.user = string2;
        this.passwd = string3;
    }

    @Override
    public void setPort(String string) {
        if (string != null) {
            this.port = string;
        }
    }

    protected String getPort() {
        return this.port;
    }

    protected int getPort(int n) {
        return this.port == null ? n : Integer.parseInt(this.port);
    }

    @Override
    public void setMkdirs(boolean bl) {
        this.isMkdirs = bl;
    }

    @Override
    public void setTimeout(int n) {
        if (2147483 < n) {
            this.errAppend((Object)"\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u306e\u6307\u5b9a\u304c\u5927\u304d\u3059\u304e\u307e\u3059\u3002");
            this.errAppend("   timeout   = [", n, "]");
            throw new RuntimeException(this.getErrMsg());
        }
        this.timeout = n;
    }

    @Override
    public void setDisplay(boolean bl) {
        this.isDisplay = bl;
    }

    @Override
    public void setDebug(boolean bl) {
        this.isDebug = bl;
    }

    protected void errAppend(Object object) {
        this.errMsg.append(String.valueOf(object)).append(CR);
    }

    protected void errAppend(Object ... objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.errMsg.append(String.valueOf(objectArray[i]));
        }
        this.errMsg.append(CR);
    }

    @Override
    public String getErrMsg() {
        return this.errMsg.toString();
    }
}

