<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2130"
	title	= "テーブル一覧表"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,TBLSYU,TABLE_NAME"
/>

<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select TABLE_NAME,NAME_JA,SEQNO,KBCLM,
				CLM_NAME,CLM,'' as DTYPE,
				BIKO,
				CLS_NAME,USE_LENGTH,SYSTEM_ID
		from GF80
		<og:where>
			<og:and value = "FGJ		in  ('0','1')"			/>
			<og:and value = "SYSTEM_ID	= '{@SYSTEM_ID}'"		/>
			<og:and value = "TBLSYU		= '{@TBLSYU}'"			/>
			<og:and value = "TABLE_NAME like '{@TABLE_NAME}'"	/>
			<og:and value = "KBCLM		&lt;= '{@KBCLM}'"		/>
		</og:where>
		<og:appear startKey = "order by" value = "{@ORDER_BY}"
					defaultVal = "SYSTEM_ID,TBLSYU,TABLE_NAME,SEQNO" />
</og:query>

<!-- CLS_NAME,USE_LENGTH,DTYPE カラムが必須。異なる場合は、keys,vals で指定します。 -->
<og:tableFilter classId="DTYPE" />

<og:view
	viewFormType = "HTMLCustomTable"
	command    = "{@command}"
	startNo    = "{@startNo}"
	checked    = "{@checked}"
	pageSize   = "{@pageSize}"
	writable   = "false"
	numberType = "delete"
	useCheckControl = "false"
	useScrollBar    = "false"
	rowspan    = "1"
	headerSkipCount = "0"
>
	<og:thead rowspan="1">
		<tr><td style="background-color: Beige;" colspan="6" /></tr>
	</og:thead>
	<og:tbody keyBreakClm="TABLE_NAME" rowspan="2">
		<tr>
			<td style="background-color: Beige; width:10px;" colspan="6">{@LBL.SPACE}</td>
		</tr>
		<tr class="row_h">
			<td />
			<td>[TABLE_NAME]</td>
			<td colspan="2">[NAME_JA]</td>
			<td style="background-color: Beige;">{@LBL.SPACE}</td>
			<td>{@LBL.BIKO}</td>
		</tr>
	</og:tbody>
	<og:tbody rowspan="1" >
		<tr>
			<td>[KBCLM]</td>
			<td>[CLM_NAME]</td>
			<td>[CLM]</td>
			<td>[DTYPE]</td>
			<td style="background-color: Beige; width:10px;">{@LBL.SPACE}</td>
			<td style="font-size:x-small; white-space:normal;">[BIKO]</td>
		</tr>
	</og:tbody>
</og:view>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
