/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.filter;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opengion.fukurou.security.URLHashMap;
import org.opengion.fukurou.util.FileString;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

public final class URLHashFilter
implements Filter {
    private static final String REQ_KEY = "h_r";
    private static final int ACCS_LVL = HybsSystem.sysInt("URL_ACCESS_SECURITY_LEVEL");
    private String initPage = "/jsp/index.jsp";
    private FileString refuseMsg;
    private boolean isDebug;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        httpServletRequest.setCharacterEncoding("UTF-8");
        if (this.isValidAccess(httpServletRequest)) {
            String string = httpServletRequest.getParameter(REQ_KEY);
            if (string != null && servletResponse instanceof HttpServletResponse) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
                String string2 = URLHashMap.getValue((String)string);
                if (string2 != null) {
                    String string3;
                    String string4 = httpServletRequest.getRequestURI();
                    if (string4.startsWith(string3 = httpServletRequest.getContextPath())) {
                        String string5 = string4.substring(string3.length()) + "?" + string2;
                        RequestDispatcher requestDispatcher = servletRequest.getRequestDispatcher(string5);
                        requestDispatcher.forward(servletRequest, servletResponse);
                    } else {
                        String string6 = httpServletResponse.encodeRedirectURL(string4 + "?" + string2);
                        httpServletResponse.sendRedirect(string6);
                    }
                } else {
                    String string7 = httpServletResponse.encodeRedirectURL(this.initPage);
                    httpServletResponse.sendRedirect(string7);
                }
            } else {
                filterChain.doFilter(servletRequest, servletResponse);
            }
        } else {
            servletResponse.setContentType("text/html; charset=UTF-8");
            PrintWriter printWriter = servletResponse.getWriter();
            printWriter.println(this.refuseMsg.getValue());
            printWriter.flush();
        }
    }

    public void init(FilterConfig filterConfig) {
        this.initPage = StringUtil.nval((String)filterConfig.getInitParameter("initPage"), (String)this.initPage);
        this.isDebug = StringUtil.nval((String)filterConfig.getInitParameter("debug"), (boolean)this.isDebug);
        ServletContext servletContext = filterConfig.getServletContext();
        String string = servletContext.getRealPath("") + File.separator;
        String string2 = string + filterConfig.getInitParameter("filename");
        this.refuseMsg = new FileString();
        this.refuseMsg.setFilename(string2);
        this.refuseMsg.setEncode("UTF-8");
    }

    public void destroy() {
    }

    private boolean isValidAccess(HttpServletRequest httpServletRequest) {
        boolean bl;
        if (ACCS_LVL == 0) {
            return true;
        }
        String string = httpServletRequest.getHeader("Referer");
        String string2 = httpServletRequest.getRequestURI();
        String string3 = httpServletRequest.getQueryString();
        String string4 = httpServletRequest.getParameter(REQ_KEY);
        if (this.isDebug) {
            System.out.println("URLHashFilter#httpReferer = " + string);
            System.out.println("URLHashFilter#requestURI  = " + string2);
        }
        boolean bl2 = bl = string3 == null || string4 != null;
        if (ACCS_LVL == 1 || ACCS_LVL == 2) {
            return bl || string != null;
        }
        if (ACCS_LVL == 3) {
            String string5 = httpServletRequest.getContextPath();
            return bl || string2.equalsIgnoreCase(this.initPage) || string2.startsWith(string5 + "/jsp/menu/") || string2.startsWith(string5 + "/jsp/custom/") || string2.startsWith(string5 + "/jsp/common/");
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append(this.getClass().getCanonicalName()).append(" : ").append("initPage = [").append(this.initPage).append("] , ").append("isDebug  = [").append(this.isDebug).append("]");
        return stringBuilder.toString();
    }
}

