/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.io.File;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.opengion.fukurou.util.FileInfo;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.StringUtil;

public final class JacobUtil {
    private static final String VERSION = "6.2.4.0 (2015/05/15)";

    private JacobUtil() {
    }

    public static void copyExcel(File file, File file2) {
        String string = file.getAbsolutePath();
        String string2 = file2.getAbsolutePath();
        ActiveXComponent activeXComponent = new ActiveXComponent("Excel.Application");
        try {
            activeXComponent.setProperty("DisplayAlerts", Variant.VT_FALSE);
            Dispatch dispatch = activeXComponent.getProperty("Workbooks").toDispatch();
            Dispatch dispatch2 = Dispatch.call((Dispatch)dispatch, (String)"Open", (Object[])new Object[]{string}).toDispatch();
            Dispatch.call((Dispatch)dispatch2, (String)"SaveAs", (Object[])new Object[]{string2});
            Dispatch.call((Dispatch)dispatch2, (String)"Close", (Object[])new Object[]{Variant.VT_FALSE});
        }
        catch (Throwable throwable) {
            String string3 = "ActiveXComponent Copy\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + throwable.getMessage() + HybsConst.CR + " inFile=[" + file + "] , outFile=[" + file2 + "]";
            System.err.println(string3);
            System.err.println(StringUtil.ogStackTrace(throwable));
            throw new RuntimeException(string3, throwable);
        }
        finally {
            activeXComponent.invoke("Quit", new Variant[0]);
            ComThread.Release();
        }
    }

    public static void excel2PDF(File file, File file2) {
        String string = file.getAbsolutePath();
        String string2 = file2.getAbsolutePath();
        ActiveXComponent activeXComponent = new ActiveXComponent("Excel.Application");
        try {
            activeXComponent.setProperty("DisplayAlerts", Variant.VT_FALSE);
            Dispatch dispatch = activeXComponent.getProperty("Workbooks").toDispatch();
            Dispatch dispatch2 = Dispatch.call((Dispatch)dispatch, (String)"Open", (Object[])new Object[]{string}).toDispatch();
            Dispatch.call((Dispatch)dispatch2, (String)"SaveAs", (Object[])new Object[]{string2, new Variant(57)});
            Dispatch.call((Dispatch)dispatch2, (String)"Close", (Object[])new Object[]{Variant.VT_FALSE});
        }
        catch (Throwable throwable) {
            String string3 = "ActiveXComponent PDF\u5909\u63db\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + throwable.getMessage() + HybsConst.CR + " inFile=[" + file + "] , outPdf=[" + file2 + "]";
            System.err.println(string3);
            System.err.println(StringUtil.ogStackTrace(throwable));
            throw new RuntimeException(string3, throwable);
        }
        finally {
            activeXComponent.invoke("Quit", new Variant[0]);
            ComThread.Release();
        }
    }

    public static String[] getPrinters() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        String[] stringArray = new String[printServiceArray.length];
        for (int i = 0; i < printServiceArray.length; ++i) {
            stringArray[i] = printServiceArray[i].getName();
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        File file;
        if (stringArray.length == 0) {
            System.err.println("Usage: java org.opengion.fukurou.model.JacobUtil \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d [\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u540d]");
            return;
        }
        File file2 = new File(stringArray[0]);
        File file3 = file = stringArray.length == 1 ? file2 : new File(stringArray[1]);
        if (FileInfo.isSUFIX(file, "pdf")) {
            JacobUtil.excel2PDF(file2, file);
        } else {
            JacobUtil.copyExcel(file2, file);
        }
    }
}

