/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.opengion.hayabusa.db.DBEditConfig;

public class DBEditConfigManager {
    private final Map<String, Map<String, DBEditConfig>> editConfigMap = new HashMap<String, Map<String, DBEditConfig>>();

    public DBEditConfigManager() {
    }

    public DBEditConfigManager(Map<String, String> map) {
        String[] stringArray = map.keySet().toArray(new String[map.size()]);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int n = "EDIT_NAME_".length();
        for (String string : stringArray) {
            if (string == null || !string.startsWith("EDIT_NAME_")) continue;
            String string2 = map.get(string);
            if (string2 == null || string2.isEmpty()) {
                map.remove(string);
                continue;
            }
            int n2 = string.lastIndexOf(string2) - 1;
            if (n2 < 0) {
                map.remove(string);
                continue;
            }
            String string3 = string.substring(n, n2);
            if (string3 == null || string3.length() <= 0) continue;
            String[] stringArray2 = DBEditConfigManager.getEditKeys(string3, string2);
            String[] stringArray3 = new String[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray3[i] = map.get(stringArray2[i]);
            }
            this.addEditConfig(string3, string2, new DBEditConfig(stringArray3));
        }
    }

    public static String[] getEditKeys(String string, String string2) {
        int n = DBEditConfig.EDIT_KEYS.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "EDIT_" + DBEditConfig.EDIT_KEYS[i] + "_" + string + "_" + string2;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEditConfig(String string, String string2, DBEditConfig dBEditConfig) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (string2 == null || string2.isEmpty()) {
            return;
        }
        if (dBEditConfig == null) {
            return;
        }
        Map<String, Map<String, DBEditConfig>> map = this.editConfigMap;
        synchronized (map) {
            Map<String, DBEditConfig> map2 = this.editConfigMap.get(string);
            if (map2 == null) {
                map2 = new HashMap<String, DBEditConfig>();
            }
            map2.put(string2, dBEditConfig);
            this.editConfigMap.put(string, map2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBEditConfig deleteEditConfig(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        DBEditConfig dBEditConfig = null;
        Map<String, Map<String, DBEditConfig>> map = this.editConfigMap;
        synchronized (map) {
            Map<String, DBEditConfig> map2 = this.editConfigMap.get(string);
            if (map2 == null) {
                return null;
            }
            dBEditConfig = map2.remove(string2);
            this.editConfigMap.put(string, map2);
        }
        return dBEditConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBEditConfig getEditConfig(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        Map<String, Map<String, DBEditConfig>> map = this.editConfigMap;
        synchronized (map) {
            Map<String, DBEditConfig> map2 = this.editConfigMap.get(string);
            if (map2 == null) {
                return null;
            }
            return map2.get(string2);
        }
    }

    public DBEditConfig[] getEditConfigs(String string) {
        if (string == null || string.isEmpty()) {
            return new DBEditConfig[0];
        }
        Map<String, DBEditConfig> map = this.editConfigMap.get(string);
        if (map == null) {
            return new DBEditConfig[0];
        }
        DBEditConfig[] dBEditConfigArray = map.values().toArray(new DBEditConfig[map.size()]);
        Arrays.sort(dBEditConfigArray, new EditConfigComparator());
        return dBEditConfigArray;
    }

    private static final class EditConfigComparator
    implements Comparator<DBEditConfig>,
    Serializable {
        private static final long serialVersionUID = 602520141024L;

        private EditConfigComparator() {
        }

        @Override
        public int compare(DBEditConfig dBEditConfig, DBEditConfig dBEditConfig2) {
            return dBEditConfig == null ? -1 : dBEditConfig.getEditName().compareTo(dBEditConfig2.getEditName());
        }
    }
}

