<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "10_REPORT"
	title    = "帳票結果表示"
	date     = "2014/12/16"
	author   = "K.Hasegawa"
	text     = ""
	version  = "001"
/>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="NEW" debug="{@debug}" maxRowCount="0" scope="request">
		select  a.FGKAN,a.YKNO,a.LISTID,b.LISTNAME,a.JOKEN,
				a.SUDATA,a.SUPAGE,
				a.OUT_DIR , a.OUT_FILE,
				a.DYSET,a.USRSET,a.PGPSET
		from    GE50 a left outer join GE54 b
		on		a.SYSTEM_ID = b.SYSTEM_ID
		and		a.LISTID    = b.LISTID
		where	a.SYSTEM_ID =  '{@SYS.SYSTEM_ID}'
		and		a.FGJ       in ( '0','1' )
		and		a.DYSET     LIKE '{@DATE.YMD}'
		and		a.USRSET    =  '{@USER.ID}'
	<og:where startKey="and">
		<og:and value = "a.JOKEN     =    '{@PRT_JOKEN}'"	/>
		<og:and value = "a.PGPSET    =    '{@PGPSET}'"	/>
	</og:where>
	order by a.SYSTEM_ID,a.YKNO DESC
</og:query>

<og:viewLink command="NEW">
	<og:link column="OUT_FILE" href="../fileDownload" useGamenId="false" target="_blank"
		onLink="[FGKAN]" markList="2"
		keys="file,name" vals="[OUT_DIR]/[OUT_FILE],[OUT_FILE]" />
</og:viewLink>

<og:text>{@DATE.YMDHMSF}</og:text>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable"
	command 	 = "NEW"
	scope        = "request"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}"
	noDisplay	 = "OUT_DIR,DYSET,USRSET,PGPSET"
/>

<!-- 完了状態を確認する。 FGKAN が、1:登録 と 3:実行中 がなくなるまで -->
<og:value command="SQL" >
	select count(*) as CNT from GE50
		where	SYSTEM_ID =  '{@SYS.SYSTEM_ID}'
		and		FGKAN     in ( '1','3' )
		and		FGJ       in ( '0','1' )
		and		DYSET     LIKE '{@DATE.YMD}'
		and		USRSET    =  '{@USER.ID}'
	<og:where startKey="and">
		<og:and value = "JOKEN	= '{@PRT_JOKEN}'"	/>
		<og:and value = "PGPSET	= '{@PGPSET}'"	/>
	</og:where>
</og:value>

<og:equals val1="{@CNT}" val2="0" notEquals="true" >
	<og:responseHeader refresh="2" refreshURL="reportView.jsp?PRT_JOKEN={@PRT_JOKEN}&amp;PGPSET={@PGPSET}" />
</og:equals>

<!-- 登録完了のﾒｯｾｰｼﾞを表示します｡ refresh 引数がない場合は表示しません。 -->
<og:errorMessage command="RENEW" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
