<jsp:directive.page pageEncoding="UTF-8" />
<!-- PostgreSQL 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="POSTGRES">
	<!-- GFE0009 : {0} は、{1} のデータベースに対応していません。 -->
	<og:message lbl="GFE0009" val0="{@LBL.GF2080}" val1="{@DBF.NAME @DBID}" />
</og:equals>

<!-- ORACLE 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
  <!-- FUNCTION,PACKAGE,PACKAGE BODY,PROCEDURE,TYPE,TYPE BODY,TRIGGER が対象 -->
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select TYPE			AS OBJ_TYPE,
				NAME		AS OBJ_NAME,
				NAME		AS NAME_JA,
				LINE		AS NOLINE ,
				'0' 		AS FGNG ,
				TEXT		AS SRC_TEXT ,
				'{@SYSTEM_ID}' AS SYSTEM_ID,
				'{@TBLSYU}'    AS TBLSYU
		from USER_SOURCE
		where	INSTR(NAME,'$') < 1
	<og:where startKey="and">
		<og:and value="TYPE =		'{@OBJ_TYPE2}'"	/>
		<og:and value="NAME like	'{@OBJ_NAME}'"	/>
	</og:where>
		union
		select TYPE			AS OBJ_TYPE,
				NAME		AS OBJ_NAME,
				NAME		AS NAME_JA,
				LINE		AS NOLINE ,
				'1'			AS FGNG,
				TEXT		AS SRC_TEXT ,
				'{@SYSTEM_ID}' AS SYSTEM_ID,
				'{@TBLSYU}'    AS TBLSYU
		from USER_ERRORS
		where	INSTR(NAME,'$') < 1
		and		TEXT not like 'PL/SQL%ignored%'
	<og:where startKey="and">
		<og:and value="TYPE =		'{@OBJ_TYPE2}'"	/>
		<og:and value="NAME like	'{@OBJ_NAME}'"	/>
	</og:where>
		order by 1,2,4,5
  </og:query>
</og:equals>

<!-- FIREBIRD 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="FIREBIRD">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
	select 'TRIGGER'					AS OBJ_TYPE,
			trim(RDB$TRIGGER_NAME)		AS OBJ_NAME,
			trim(RDB$TRIGGER_NAME)		AS NAME_JA,
			0							AS NOLINE ,
			'0'							AS FGNG,
			trim(RDB$TRIGGER_SOURCE)	AS SRC_TEXT ,
			'{@SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}'    AS TBLSYU
	from RDB$TRIGGERS
	where RDB$SYSTEM_FLAG = 0
	<og:where startKey="and">
		<og:and value="'TRIGGER'		=		'{@OBJ_TYPE2}'"	/>
		<og:and value="RDB$TRIGGER_NAME like	'{@OBJ_NAME}'"	/>
	</og:where>
	union
	select 'PROCEDURE'					AS OBJ_TYPE,
			trim(RDB$PROCEDURE_NAME)	AS OBJ_NAME,
			trim(RDB$PROCEDURE_NAME)	AS NAME_JA,
			0							AS NOLINE ,
			'0'							AS FGNG,
			trim(RDB$PROCEDURE_SOURCE)	AS SRC_TEXT ,
			'{@SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}'    AS TBLSYU
	from RDB$PROCEDURES
	where RDB$SYSTEM_FLAG = 0
	<og:where startKey="and">
		<og:and value="'PROCEDURE'		=		'{@OBJ_TYPE2}'"	/>
		<og:and value="RDB$PROCEDURE_NAME like	'{@OBJ_NAME}'"	/>
	</og:where>
	union
	select 'FUNCTION'				AS OBJ_TYPE,
			trim(RDB$FUNCTION_NAME)	AS OBJ_NAME,
			trim(RDB$FUNCTION_NAME)	AS NAME_JA,
			0						AS NOLINE ,
			'0'						AS FGNG,
			trim(RDB$MODULE_NAME)	AS SRC_TEXT ,
			'{@SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}'    AS TBLSYU
	from RDB$FUNCTIONS
	where RDB$SYSTEM_FLAG = 0
	<og:where startKey="and">
		<og:and value="'FUNCTION'		=		'{@OBJ_TYPE2}'"	/>
		<og:and value="RDB$FUNCTION_NAME like	'{@OBJ_NAME}'"	/>
	</og:where>
		order by 1,2,4,5
  </og:query>
</og:equals>

<!-- POSTGRES,ORACLE,FIREBIRD 以外の場合 -->
<og:equals val1="POSTGRES,ORACLE,FIREBIRD" val2="{@DBF.NAME @DBID}" contains="true" notEquals="true">
	<!-- GFE0009 : {0} は、{1} のデータベースに対応していません。 -->
	<og:message lbl="GFE0009" val0="{@LBL.GF2080}" val1="{@DBF.NAME @DBID}" />
</og:equals>

<!-- NAME_JA にリソースを適用します。 -->
<og:tableFilter classId="LABEL" keys="SYSTEM_ID,CLM,LBL" vals="{@SYSTEM_ID},OBJ_NAME,NAME_JA" />
