/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.model.ArrayDataModel;
import org.opengion.fukurou.model.DataModel;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.FileInfo;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.ColumnActionListener;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.io.TableReader;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.ReadTableTag;
import org.opengion.hayabusa.taglib.TaglibUtil;
import org.opengion.hayabusa.taglib.TransactionTag;

public class DirectTableInsertTag
extends ReadTableTag {
    private static final String VERSION = "6.2.5.0 (2015/06/05)";
    private static final long serialVersionUID = 625020150605L;
    private static final String DEFAULT_OMIT = "WRITABLE,ROWID";
    private String dbid;
    private int commitBatch;
    private String sql;
    private String table;
    private long dyStart;

    @Override
    public int doStartTag() {
        this.dyStart = System.currentTimeMillis();
        this.addOmitNames(DEFAULT_OMIT);
        if (this.table == null || this.table.isEmpty()) {
            return 2;
        }
        return 0;
    }

    @Override
    public int doAfterBody() {
        this.sql = this.getBodyString();
        if (this.sql == null || this.sql.isEmpty() || this.sql.trim().isEmpty()) {
            throw new HybsSystemException("table\u5c5e\u6027\u3092\u6307\u5b9a\u3057\u306a\u3044\u5834\u5408\u306f\u3001BODY \u90e8\u306e\u767b\u9332\u7528 Insert/Update\u6587\u306f\u3001\u5fc5\u9808\u3067\u3059\u3002");
        }
        return 0;
    }

    @Override
    protected int afterEnd() {
        ErrorMessage errorMessage = this.clmAct.getErrorMessage();
        if (!errorMessage.isOK()) {
            this.jspPrint(TaglibUtil.makeHTMLErrorTable(errorMessage, this.getResource()));
            return 5;
        }
        if (this.displayMsg != null && this.displayMsg.length() > 0) {
            String string = this.executeCount + this.getResource().getLabel(this.displayMsg);
            this.jspPrint(string + BR);
        }
        this.setRequestAttribute("DB.COUNT", String.valueOf(this.executeCount));
        if (this.executeCount == 0 && this.stopZero) {
            return 5;
        }
        long l = System.currentTimeMillis() - this.dyStart;
        this.jspPrint("<div id=\"queryTime\" value=\"" + l + "\"></div>");
        GUIInfo gUIInfo = (GUIInfo)this.getSessionAttribute("h_gInfo");
        if (gUIInfo != null) {
            gUIInfo.addWriteCount(this.executeCount, l, this.sql);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.dbid = null;
        this.commitBatch = 0;
        this.table = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void create(final File file) {
        void var6_10;
        String string = HybsSystem.sys("TableReader_" + this.readerClass);
        if (string == null) {
            String string2 = "TableReader \u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002class=TableReader_" + this.readerClass;
            throw new RuntimeException(string2);
        }
        TableReader tableReader = (TableReader)HybsSystem.newInstance(string);
        ColumnActionListener columnActionListener = new ColumnActionListener(){
            private DBColumn[] dbClms;
            private String[] clmKeys;
            private int commitCount;
            int[] clmNos;
            int clmNosLen;
            PreparedStatement pstmt;
            Connection conn;

            @Override
            public void init(Object ... objectArray) {
                this.conn = (Connection)objectArray[0];
            }

            @Override
            public void end(boolean bl) {
                Closer.stmtClose((Statement)this.pstmt);
            }

            @Override
            public void columnNames(String[] stringArray) {
                Object object;
                CharSequence[] charSequenceArray = DirectTableInsertTag.this.clmAct.makeNames(stringArray);
                if (DirectTableInsertTag.this.table != null && !DirectTableInsertTag.this.table.isEmpty()) {
                    if ("FILE.NAME".equals(DirectTableInsertTag.this.table)) {
                        DirectTableInsertTag.this.table = FileInfo.getNAME((File)file);
                    }
                    this.clmNosLen = charSequenceArray.length;
                    this.clmNos = new int[this.clmNosLen];
                    this.clmKeys = charSequenceArray;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("INSERT INTO ").append(DirectTableInsertTag.this.table).append(" ( ").append(String.join((CharSequence)",", charSequenceArray)).append(" ) VALUES ( ?");
                    this.clmNos[0] = 0;
                    for (int i = 1; i < this.clmNosLen; ++i) {
                        this.clmNos[i] = i;
                        ((StringBuilder)object).append(",?");
                    }
                    ((StringBuilder)object).append(')');
                    DirectTableInsertTag.this.sql = ((StringBuilder)object).toString();
                } else if (DirectTableInsertTag.this.sql != null && !DirectTableInsertTag.this.sql.isEmpty()) {
                    object = new ArrayDataModel((String[])charSequenceArray);
                    Formatter formatter = new Formatter((DataModel)object);
                    formatter.setFormat(DirectTableInsertTag.this.sql.trim());
                    this.clmNos = formatter.getClmNos();
                    this.clmNosLen = this.clmNos.length;
                    this.clmKeys = formatter.getClmKeys();
                    DirectTableInsertTag.this.sql = formatter.getQueryFormatString();
                }
                try {
                    this.pstmt = this.conn.prepareStatement(DirectTableInsertTag.this.sql);
                }
                catch (SQLException sQLException) {
                    String string = "prepareStatement\u306e\u69cb\u7bc9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + CommonTagSupport.CR + " sql=[" + DirectTableInsertTag.this.sql + "]" + CommonTagSupport.CR + " ErrorCode=[" + sQLException.getErrorCode() + "]" + " State=[" + sQLException.getSQLState() + "]" + CommonTagSupport.CR;
                    DirectTableInsertTag.this.jspPrint(string);
                    throw new HybsSystemException(string, sQLException);
                }
                this.dbClms = new DBColumn[charSequenceArray.length];
                for (int i = 0; i < charSequenceArray.length; ++i) {
                    this.dbClms[i] = DirectTableInsertTag.this.getDBColumn(charSequenceArray[i]);
                }
                ++DirectTableInsertTag.this.executeCount;
            }

            @Override
            public void values(String[] stringArray, int n) {
                if (DirectTableInsertTag.this.maxRowCount == 0 || DirectTableInsertTag.this.executeCount <= DirectTableInsertTag.this.maxRowCount) {
                    try {
                        String[] stringArray2 = DirectTableInsertTag.this.clmAct.clmAction(stringArray, this.dbClms, n);
                        if (!DirectTableInsertTag.this.clmAct.getErrorMessage().isOK()) {
                            return;
                        }
                        for (int i = 0; i < this.clmNosLen; ++i) {
                            this.pstmt.setString(i + 1, stringArray2[this.clmNos[i]]);
                        }
                        this.pstmt.execute();
                        if (DirectTableInsertTag.this.commitBatch > 0 && DirectTableInsertTag.this.executeCount % DirectTableInsertTag.this.commitBatch == 0) {
                            this.conn.commit();
                            this.commitCount = DirectTableInsertTag.this.executeCount;
                        }
                        ++DirectTableInsertTag.this.executeCount;
                    }
                    catch (SQLException sQLException) {
                        String string = CommonTagSupport.CR + "sql=[" + DirectTableInsertTag.this.sql + "]" + CommonTagSupport.CR + " keys =[" + StringUtil.array2csv((String[])this.clmKeys) + "]" + CommonTagSupport.CR + " vals =[" + StringUtil.array2csv((String[])stringArray) + "]" + CommonTagSupport.CR + " \u884c\u756a\u53f7=[" + (n + 1) + "]" + " \u767b\u9332\u4ef6\u6570=[" + this.commitCount + "]" + CommonTagSupport.CR + " ErrorCode=[" + sQLException.getErrorCode() + "]" + " State=[" + sQLException.getSQLState() + "]" + CommonTagSupport.CR;
                        DirectTableInsertTag.this.jspPrint(string);
                        throw new HybsSystemException(string, sQLException);
                    }
                }
            }
        };
        tableReader.setSeparator(this.separator);
        tableReader.setColumns(this.columns);
        tableReader.setUseNumber(this.useNumber);
        tableReader.setSkipRowCount(this.skipRowCount);
        tableReader.setColumnActionListener(columnActionListener);
        tableReader.setDebug(this.isDebug());
        tableReader.setSheetName(this.sheetName);
        tableReader.setSheetNos(this.sheetNos);
        tableReader.setSheetConstData(this.sheetConstKeys, this.sheetConstAdrs);
        tableReader.setNullBreakClm(this.nullBreakClm);
        tableReader.setNullSkipClm(this.nullSkipClm);
        boolean bl = true;
        Object var6_7 = null;
        try {
            TransactionTag transactionTag = (TransactionTag)DirectTableInsertTag.findAncestorWithClass((Tag)this, TransactionTag.class);
            if (transactionTag == null) {
                TransactionReal transactionReal = new TransactionReal(this.getApplicationInfo());
            } else {
                Transaction transaction = transactionTag.getTransaction();
            }
            Connection connection = var6_10.getConnection(this.dbid);
            columnActionListener.init(connection);
            tableReader.readDBTable(file, this.encode);
            var6_10.commit();
            bl = false;
            columnActionListener.end(!bl);
            if (var6_10 == null) return;
        }
        catch (Throwable throwable) {
            columnActionListener.end(!bl);
            if (var6_7 == null) throw throwable;
            var6_7.close(bl);
            throw throwable;
        }
        var6_10.close(bl);
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setCommitBatch(String string) {
        this.commitBatch = StringUtil.nval((String)this.getRequestParameter(string), (int)this.commitBatch);
    }

    public void setTable(String string) {
        this.table = StringUtil.nval((String)this.getRequestParameter(string), (String)this.table);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("dbid", (Object)this.dbid).println("sql", (Object)this.sql).println("commitBatch", (Object)this.commitBatch).println("dyStart", (Object)this.dyStart).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

