/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.html;

/**
 * タイムテーブル作成クラス用のパラメータ定数設定クラスです。
 *
 * パラメータのキーとなる値と、初期値を設定しています。
 * すべて、public static final で定義されている為、設定値はドキュメント等で
 * 確認することが可能です。
 * ただし、キー値などを、直書きすることを前提に公開していませんので、
 * 必要であれば、定数として、このクラス経由で使用してください。
 *
 * @og.rev 5.4.0.0 (2011/10/01) 新規作成
 * @og.group その他
 *
 * @version  5.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK6.0,
 */
public class ViewTimeTableParam {

	/** タイムテーブルの開始時刻(含む)を指定するためのパラメータ定数 {@value}  */
	public static final String MIN_START_TIME	= "h_minStTime" ;
	/** タイムテーブルの終了時刻(含まない)を指定するためのパラメータ定数 {@value} */
	public static final String MAX_END_TIME		= "h_maxEdTime" ;
	/** タイムテーブルのインターバル時間を指定するためのパラメータ定数 {@value} */
	public static final String TIME_INTERVAL	= "h_intval" ;

	/** BODY部分に記述された リンクタグの設定値を取得する際に使用するパラメータ定数 {@value} */
	public static final String BODY_LINK_VALUE		= "h_bodyLinkVal" ;

	/** データが存在しないときにリンクの設定値を取得するカラム名のパラメータ定数 {@value} */
	public static final String NULL_LINK_CLM_ID		= "h_nullLinkClmId" ;

	/** 日付でブレーク処理を行うかどうかを指定するパラメータ定数 {@value} */
	public static final String USE_DY_BREAK			= "h_useDyBreak" ;

	// 5.4.3.7 (2012/01/20) 追加
	/** データを入れるTDタグにclass属性を付与する場合のカラム名のパラメータ定数 {@value} */
	public static final String TD_CLASS_COLUMN_ID		= "h_tdClassColumnId" ;

	// 5.4.4.2 (2012/02/03) 追加
	/** 同一日付でブッキング時にマージ処理を行うかどうかのパラメータ定数 {@value} */
	public static final String USE_BOOKING_MERGE		= "h_useBookingMerge" ;
}
