<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="query" />
<jsp:directive.include file="/jsp/custom/none_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX013"
	title	= "DB登録"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- localResource を使用する。 -->
<og:localResource systemId="{@SYSTEM_ID}" />

<jsp:directive.include file="sqlValues.jsp" />

<!-- 検索条件に使用する項目一覧を表示する為のQuery -->
<og:query command="NEW" dbid="{@FROM_DBID}" scope="request" notfoundMsg="" quotCheck="false" maxRowCount="10">
	{@IND_COLUMNS}
</og:query>

<!-- 項目が一つの DBMENU では、ラベルリソースが使用されます。 -->
<og:columnEditor column="CLM" editor="DBMENU" dbid="{@FROM_DBID}" scope="request" >
	{@TAB_COLUMNS}
</og:columnEditor>

<!-- 検索条件の値フィールドは、動的カラムを使用してフィールドを作成します。 -->
<og:columnEditor column="VAL" editor="COLUMN" scope="request" />

<form method="POST" action="forward.jsp" target="RESULT" onClick="timeSet();">
  <!-- 検索条件の指定 -->
  <og:fieldset lbl="{@TABLE_NAME}:{@LBL.@TABLE_NAME}" defaultNone="false">
	<table>
	  <tr>
		<td style="vertical-align:top;">
			<og:view
				command			= "{@command}"
				scope			= "request"
				writable		= "true"
				selectedType	= "hidden"
				columnWritable	= "CLM,CONDITION,VAL"
				noDisplay		= "SEQ"
				noMessage		= "true"
				useScrollBar	= "false"
				useAfterHtmlTag = "false"
				columnBulkSet	= "-"
			/>
	  </td>
	  <td style="vertical-align:top;">
		<!-- 検索結果に表示するカラム列を指定します。 -->
		<og:select name="SEL_CLMS" multiple="multiple" size="10" td="false">
			<og:option value="*" lbl="*" selected="selected" />
			<!-- 項目が一つの queryOption では、ラベルリソースが使用されます。 -->
			<og:queryOption dbid="{@FROM_DBID}" quotCheck="false">
				{@TAB_COLUMNS}
			</og:queryOption>
		</og:select>
		<br />
		<og:input type="checkbox" name="GRP_BY" lbl="count(*)" value="1" td="no" onClick="ORDER_BY.value=''" />
	  </td>
	  <td style="vertical-align:top;">
		<table>
		  <tr><og:column name="TABLE_NAME" value="{@TABLE_NAME}" readonly="readonly" clazz="readonly" /></tr>
		  <tr>
			<og:column name="SYSTEM_ID"	value="{@SYSTEM_ID}" defaultVal="{@LAST.SYSTEM_ID}" >
					<og:select name="resource" td="false" addNoValue="true" >
						<og:option lbl="localResource"	value="localResource"  selected="selected" />
						<og:option lbl="noResource"		value="noResource" />
					</og:select>
			  </og:column>
		  </tr>
		  <tr><og:column name="C_KEYS"		lbl="Columns"		size="30" /></tr>
		  <tr><og:column name="AND"			lbl="and"			size="30" /></tr>
		  <tr><og:column name="GROUP_BY"	lbl="group by"		size="30" /></tr>
		  <tr><og:column name="HAVING"		lbl="having"		size="30" /></tr>
		  <tr><og:column name="ORDER_BY"	value="{@NVL.LUQ @INDX_SA @UNIQS}"	size="30" /></tr>
		</table>
	  </td>
	  </tr>
	</table>
  </og:fieldset>

	<og:hidden name="FROM_DBID" value="{@FROM_DBID}" />
	<og:hidden name="UNIQ_KEYS" value="{@UNIQS}" />
	<og:queryButton />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
