<jsp:directive.page pageEncoding="UTF-8" />
<!-- PostgreSQL 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="POSTGRES">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
	select case c.relkind when 't' then 'TRIGGER'
						  when 'S' then 'SEQUENCE'
						  when 'r' then 'TABLE'
						  when 'i' then 'INDEX'
						  when 'v' then 'VIEW'
						  else 'NV' end AS OBJ_TYPE ,
			c.relname AS OBJ_NAME ,
			c.relname AS NAME_JA ,
			'VALID' AS STTS ,
			'{@SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}'    AS TBLSYU
	FROM pg_class c LEFT join pg_user u 
	ON c.relowner = u.usesysid
	where u.usename != 'postgres'
	and   c.relkind  not in ( 'r','i','S' )		-- TABLE,INDEX,SEQUENCE を除く
	<og:where startKey="and">
		<og:and value="( 'VIEW' = '{@OBJ_TYPE2}' and c.relkind = 'v' ) or ( 'TRIGGER' = '{@OBJ_TYPE2}' and c.relkind = 't' )"	/>
		<og:and value="c.relname like	'{@OBJ_NAME}'"	/>
	</og:where>
		order by OBJECT_TYPE,OBJECT_NAME
  </og:query>
</og:equals>

<!-- ORACLE 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
	select OBJECT_TYPE  AS OBJ_TYPE,
			OBJECT_NAME AS OBJ_NAME,
			OBJECT_NAME AS NAME_JA,
			STATUS AS STTS ,
			'' AS REF_TABLES ,
			'{@SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}'    AS TBLSYU
	from USER_OBJECTS
	where INSTR(OBJECT_NAME,'$') < 1
	and   OBJECT_TYPE  not in ( 'TABLE','INDEX','SEQUENCE' )
	<og:where startKey="and">
		<og:and value="OBJECT_TYPE =	'{@OBJ_TYPE2}'"	/>
		<og:and value="OBJECT_NAME like	'{@OBJ_NAME}'"	/>
	</og:where>
		order by OBJECT_TYPE,OBJECT_NAME
  </og:query>

	<!-- ｵﾌﾞｼﾞｪｸﾄが参照しているﾃｰﾌﾞﾙ名を取り出して、セットします -->
	<og:tableFilter
		classId	= "DBSELECT"
		dbid	= "{@DBID}"
		keys	= "APPEND"
		vals	= "true"
		selectedAll	= "true"
	>
		select REFERENCED_NAME AS REF_TABLES
		from user_dependencies
		where TYPE = [OBJ_TYPE]
		and   NAME = [OBJ_NAME]
		and   REFERENCED_TYPE='TABLE'
		and   INSTR(REFERENCED_NAME,'$') < 1
		order by REFERENCED_NAME
	</og:tableFilter>
</og:equals>

<!-- FIREBIRD 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="FIREBIRD">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
	select 'VIEW'					AS OBJ_TYPE,
			trim(RDB$RELATION_NAME)	AS OBJ_NAME,
			trim(RDB$RELATION_NAME)	AS NAME_JA,
			'VALID'					AS STTS,
			'{@SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}'    AS TBLSYU
	from RDB$RELATIONS
	where RDB$SYSTEM_FLAG = 0
	and   RDB$VIEW_BLR is not null
	<og:where startKey="and">
		<og:and value="'VIEW'			=		'{@OBJ_TYPE2}'"	/>
		<og:and value="RDB$RELATION_NAME like	'{@OBJ_NAME}'"	/>
	</og:where>
	union
	select 'TRIGGER'				AS OBJ_TYPE,
			trim(RDB$TRIGGER_NAME)	AS OBJ_NAME,
			trim(RDB$TRIGGER_NAME)	AS NAME_JA,
			case when RDB$TRIGGER_INACTIVE = 0 then 'VALID' else 'INVALID' end AS STTS,
			'{@SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}'    AS TBLSYU
	from RDB$TRIGGERS
	where RDB$SYSTEM_FLAG = 0
	<og:where startKey="and">
		<og:and value="'TRIGGER'		=		'{@OBJ_TYPE2}'"	/>
		<og:and value="RDB$TRIGGER_NAME like	'{@OBJ_NAME}'"	/>
	</og:where>
	union
	select 'PROCEDURE'					AS OBJ_TYPE,
			trim(RDB$PROCEDURE_NAME)	AS OBJ_NAME,
			trim(RDB$PROCEDURE_NAME)	AS NAME_JA,
			'VALID'						AS STTS,
			'{@SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}'    AS TBLSYU
	from RDB$PROCEDURES
	where RDB$SYSTEM_FLAG = 0
	<og:where startKey="and">
		<og:and value="'PROCEDURE'		=		'{@OBJ_TYPE2}'"	/>
		<og:and value="RDB$PROCEDURE_NAME like	'{@OBJ_NAME}'"	/>
	</og:where>
	union
	select 'FUNCTION'					AS OBJ_TYPE,
			trim(RDB$FUNCTION_NAME)		AS OBJ_NAME,
			trim(RDB$FUNCTION_NAME)		AS NAME_JA,
			'VALID'						AS STTS,
			'{@SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}'    AS TBLSYU
	from RDB$FUNCTIONS
	where RDB$SYSTEM_FLAG = 0
	<og:where startKey="and">
		<og:and value="'FUNCTION'		=		'{@OBJ_TYPE2}'"	/>
		<og:and value="RDB$FUNCTION_NAME like	'{@OBJ_NAME}'"	/>
	</og:where>
  </og:query>
</og:equals>

<!-- POSTGRES,ORACLE,FIREBIRD 以外の場合 -->
<og:equals val1="POSTGRES,ORACLE,FIREBIRD" val2="{@DBF.NAME @DBID}" contains="true" notEquals="true">
	<!-- GFE0009 : {0} は、{1} のデータベースに対応していません。 -->
	<og:message lbl="GFE0009" val0="{@LBL.GF2080}" val1="{@DBF.NAME @DBID}" />
</og:equals>

<!-- NAME_JA にリソースを適用します。 -->
<og:tableFilter classId="LABEL" keys="SYSTEM_ID,CLM,LBL" vals="{@SYSTEM_ID},OBJ_NAME,NAME_JA" />
