/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.model;

/**
 * POI による、Excel(xls)の読み取り処理の インターフェースです。
 *
 * xls形式のEXCELを、イベント方式でテキストデータを読み取ります。
 * このインターフェースでは、EXCEL形式を、TableModelHelper を介したイベントで読み取ります。
 * TableModelHelperイベントは、openGion形式のファイル読み取りに準拠した方法をサポートします。
 * ※ openGion形式のEXCELファイルとは、#NAME 列に、カラム名があり、#で始まる
 *    レコードは、コメントとして判断し、読み飛ばす処理の事です。
 *
 * @og.rev 6.2.4.2 (2015/05/29) 新規作成
 * @og.group ファイル入力
 *
 * @version  6.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK7.0,
 */
public interface TextConverter {

	/**
	 * 入力文字列を、変換します。
	 *
	 * 変換されなかった場合は、null を返します。
	 * 例えば、何らかの変換処理を行う場合、データを読み取って、変換して、書き込みます。
	 * 変換が無かった場合、書き込む必要もない為、null を返すことで、変換が無かったことを
	 * 知らせます。
	 * よって、ある文字列を変換した結果を、null に設定することはできません。
	 *
	 * @og.rev 6.2.4.2 (2015/05/29) テキスト変換処理
	 *
	 * @param	val 入力文字列
	 * @return	変換文字列(変換されない場合は、null)
	 */
	String change( final String val );
}
