/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.table;

import org.opengion.hayabusa.db.AbstractTableFilter;
import org.opengion.hayabusa.db.DBTableModel;

/**
 * TableFilter_REPORTLAYOUT は、TableFilter インターフェースを継承した、DBTableModel 処理用の
 * 実装クラスです。
 *
 * ここでは、GE52(帳票レイアウトテーブル)の変更時に、
 *  GE52のSEQ,開始位置
 *  (GE54のSQLの再定義) 廃止
 * を行うための情報を生成しています。
 *
 * この処理を実行するには、DBTableModelのカラムとして、
 *  SYSTEM_ID,LISTID,KBTEXT,CLM,SEQ,USE_LENGTH,START_POS
 * が必要です。
 *
 * パラメータは、tableFilterタグの keys, vals にそれぞれ記述するか、BODY 部にCSS形式で記述します。
 * 【パラメータ】
 *  {
 *       なし
 *  }
 *
 * @og.formSample
 * ●形式：
 *      select SYSTEM_ID,LISTID,KBTEXT,CLM,SEQ,USE_LENGTH,START_POS from GE52
 * 
 *      ① &lt;og:tableFilter classId="REPORTLAYOUT " /&gt;
 *
 * @og.rev 4.3.7.0 (2009/06/01) 新規作成
 *
 * @version  0.9.0  2000/10/17
 * @author   Hiroki Nakamura
 * @since    JDK1.1,
 */
public class TableFilter_REPORTLAYOUT extends AbstractTableFilter {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.5.2.6 (2012/05/25)" ;

	/**
	 * DBTableModel処理を実行します。
	 *
	 * @og.rev 4.3.7.0 (2009/06/01) 新規追加
	 * @og.rev 5.1.0.0 (2009/11/04) TEXT ⇒ TEXT_DATA , COLUMN_NAME ⇒ CLM
	 * @og.rev 5.1.2.0 (2010/01/01) データ分割のためのSQL文の生成を廃止します。(帳票クラス内で直接分割)
	 * @og.rev 5.5.2.6 (2012/05/25) protected変数を、private化したため、getterメソッドで取得するように変更
	 *
	 * @return 処理結果のDBTableModel
	 */
	public DBTableModel execute() {
		final DBTableModel table = getDBTableModel();		// 5.5.2.6 (2012/05/25) インターフェースにgetterメソッド追加

		final int systemIdNo	= table.getColumnNo( "SYSTEM_ID" );
		final int listIdNo	= table.getColumnNo( "LISTID" );
		final int kbtextNo	= table.getColumnNo( "KBTEXT" );
		final int clmNo		= table.getColumnNo( "CLM" );		// 5.1.0.0 (2009/11/04) COLUMN_NAME ⇒ CLM
		final int seqNo		= table.getColumnNo( "SEQ" );
		final int lengthNo	= table.getColumnNo( "USE_LENGTH" );
		final int strposNo	= table.getColumnNo( "START_POS" );
 //		int sqlTypeNo	= table.getColumnNo( "SQL_TYPE" );
 //		int sqlBodyNo	= table.getColumnNo( "SQL_BODY" );
 //		String substrb	= getValue( "SUBSTRB" );

		if( systemIdNo < 0 || listIdNo < 0 || kbtextNo < 0 || clmNo < 0
				|| seqNo < 0 || lengthNo < 0 || strposNo < 0 ) {
			return table;
		}

		int seq = 0;
		int strpos = 1;
		String[] data = null;

		String resetKey = null;
		String preKey = null;
		final int[] rowNo = getParameterRows();					// 5.5.2.6 (2012/05/25) インターフェースにgetterメソッド追加
		for( int row = 0; row < rowNo.length; row ++ ) {
			data = table.getValues( rowNo[row] );
			resetKey = data[systemIdNo] + "__" + data[listIdNo] + "__" + data[kbtextNo];

			if( preKey != null && !(preKey.equals( resetKey ) ) ) {
				seq = 0;
				strpos = 1;
			}

			seq += 10;
			data[seqNo] = String.valueOf( seq );
			data[strposNo] = String.valueOf( strpos );

			// 5.1.0.0 (2009/11/04) TEXT ⇒ TEXT_DATA
//			strpos += Integer.valueOf( data[lengthNo] );
			strpos += Integer.parseInt( data[lengthNo] );		// 6.0.2.4 (2014/10/17) メソッド間違い

			preKey = resetKey;
		}

		return table;
	}
}
