/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* GFP19300A ( PACKAGE BODY )                                               */
/* Created : 2014/12/16 09:05:44                                            */
/****************************************************************************/
CREATE     
PACKAGE BODY GFP19300A AS
/*******************************************************************************
*	ｼｽﾃﾑ			:	フレームワーク雛形
*	ﾌﾟﾛｸﾞﾗﾑID		:	GFP19300A
*	処理名			:	エントリー
*	作成日			:	2007/08/11
*	作成者			:	XXXXXXXXX
*	更新日/更新者	:
*	更新内容		:
*******************************************************************************/
PROCEDURE GF19300A (
	 PO_KEKKA		OUT		NUMBER												-- 処理結果(0:正常 1:警告 2:異常)
	,PO_ERRMSGS		OUT		ERR_MSG_ARRAY										-- ｴﾗｰﾒｯｾｰｼﾞ配列
	,PO_RC1			OUT		CUST_CURSOR											-- 結果ｶｰｿﾙ
	,PI_ARGS		IN		ARG_ARRAY											-- 条件配列
)
IS
/*******************************************************************************
*	変数宣言
*******************************************************************************/
	-- 定数定義
	CON_PGID		CONSTANT	VARCHAR2(10)	:= 'GFP19300A';					-- ﾌﾟﾛｸﾞﾗﾑID
	CON_PGPID		CONSTANT	VARCHAR2(10)	:= 'GF9300';					-- 画面ID
	CON_SYSDATE		CONSTANT	VARCHAR2(14)	:= TO_CHAR(SYSDATE,'YYYYMMDDHH24MISS');	-- ｼｽﾃﾑ日付
	CON_USER		CONSTANT	VARCHAR2(10)	:= PI_ARGS(9);					-- ﾛｸﾞｲﾝﾕｰｻﾞｰ

	-- 変数定義
	G_I				NUMBER;
	G_ERRSTP		VARCHAR2(1000)	:= NULL;
	G_DISP_KEY		VARCHAR2(1000)	:= NULL;
	G_CDKH			VARCHAR2(1)		:= NULL;
	G_RTN			BOOLEAN;

	-- 条件配列
	G_SYSTEM_ID		GF41.SYSTEM_ID%TYPE		:= PI_ARGS(1);						-- ｼｽﾃﾑID
	G_LANG			GF41.LANG%TYPE			:= PI_ARGS(2);						-- 言語
	G_CLM			GF41.CLM%TYPE			:= PI_ARGS(3);						-- 項目
	G_NAME_JA		GF41.NAME_JA%TYPE		:= PI_ARGS(4);						-- 名称（漢字）
	G_LABEL_NAME	GF41.LABEL_NAME%TYPE	:= PI_ARGS(5);						-- 表示名称
	G_KBSAKU		GF41.KBSAKU%TYPE		:= PI_ARGS(6);						-- 作成区分
	G_CDTAN			GF41.CDTAN%TYPE			:= PI_ARGS(7);						-- 担当者
	G_UNIQ			GF41.UNIQ%TYPE			:= PI_ARGS(8);						-- ﾕﾆｰｸ
	G_USRSET		GF41.USRSET%TYPE		:= PI_ARGS(9);						-- 登録者

	-- ｻﾌﾞﾌﾟﾛｸﾞﾗﾑ
	FUNCTION	INIT_PROCESS_RTN RETURN BOOLEAN;
	FUNCTION	INSERT_RTN RETURN BOOLEAN;
	FUNCTION	UPDATE_RTN RETURN BOOLEAN;
/*******************************************************************************
*	INIT_PROCESS_RTN 初期処理
*******************************************************************************/
FUNCTION INIT_PROCESS_RTN
RETURN BOOLEAN
IS
	L_CNT	NUMBER	:= 0;
BEGIN
	G_ERRSTP:='INIT_PROCESS_RTN';

	G_ERRSTP:='INIT_PROCESS_RTN_GF41_CNT';
	-- 存在ﾁｪｯｸ
	SELECT COUNT(*)
	INTO	L_CNT
	FROM	GF41
	WHERE	SYSTEM_ID		=	G_SYSTEM_ID										-- ｼｽﾃﾑID ＝ 画面》ｼｽﾃﾑID
	AND		LANG			=	G_LANG											-- 言語   ＝ 画面》言語
	AND		CLM				=	G_CLM											-- 項目   ＝ 画面》項目
	AND		FGJ				IN	('0','1');										-- 状態F  IN ('0','1')

	IF	NVL(L_CNT,0) <= 0 THEN
		-- 追加／複写処理
		G_CDKH := 'A';
	ELSE
		-- 変更処理
		G_CDKH := 'C';
	END IF;
	RETURN TRUE;
END INIT_PROCESS_RTN;
/*******************************************************************************
*	INSERT_RTN 追加
*******************************************************************************/
FUNCTION INSERT_RTN
RETURN BOOLEAN
IS
	L_STATUS	NUMBER(1);		-- ｽﾃｰﾀｽ(0:正常 1:異常 9:ｵﾗｸﾙｴﾗｰ)
BEGIN
	G_ERRSTP:='INSERT_RTN';

/*
	G_ERRSTP		:= 'GF41_INSERT_RTN_INS';
	INSERT INTO GF41 (
		 SYSTEM_ID																-- ｼｽﾃﾑID
		,LANG																	-- 言語
		,CLM																	-- 項目
		,NAME_JA																-- 名称（漢字）
		,LABEL_NAME																-- 表示名称
		,KBSAKU																	-- 作成区分
		,CDTAN																	-- 担当者
		,FGJ																	-- 状態F
		,DYSET																	-- 作成日時
		,PGSET																	-- 作成PG
		,PGPSET																	-- 作成呼出PG
		,USRSET																	-- 作成ﾕｰｻﾞｰ
		,DYUPD																	-- 更新日時
		,PGUPD																	-- 更新PG
		,PGPUPD																	-- 更新呼出PG
		,USRUPD																	-- 更新ﾕｰｻﾞｰ
	)
	VALUES (
		 G_SYSTEM_ID															-- ｼｽﾃﾑID
		,G_LANG																	-- 言語
		,G_CLM																	-- 項目
		,G_NAME_JA																-- 名称（漢字）
		,G_LABEL_NAME															-- 表示名称
		,G_KBSAKU																-- 作成区分
		,G_CDTAN																-- 担当者
		,'1'																	-- 状態F
		,CON_SYSDATE															-- 作成日時
		,CON_PGID																-- 作成PG
		,CON_PGPID																-- 作成呼出PG
		,CON_USER																-- 作成ﾕｰｻﾞｰ
		,CON_SYSDATE															-- 更新日時
		,CON_PGID																-- 更新PG
		,CON_PGPID																-- 更新呼出PG
		,CON_USER																-- 更新ﾕｰｻﾞｰ
	);
*/
	G_ERRSTP		:= 'GF41_INSERT_RTN_GFP00001';
	-- 共通SPｻﾝﾌﾟﾙ(GFP00001)
	GFP00001.GF00001(
					 L_STATUS													-- ｽﾃｰﾀｽ
					,PO_ERRMSGS													-- ｴﾗｰﾒｯｾｰｼﾞ配列
					,CON_PGPID													-- 画面ID
					,1															-- 行番号
					,G_SYSTEM_ID												-- ｼｽﾃﾑID
					,G_LANG														-- 言語
					,G_CLM														-- 項目
					,G_NAME_JA													-- 名称（漢字）
					,G_LABEL_NAME												-- 表示名称
					,G_KBSAKU													-- 作成区分
					,G_CDTAN													-- 担当者
					,CON_USER													-- ﾛｸﾞｲﾝﾕｰｻﾞｰ
					);

	-- ｽﾃｰﾀｽが9（ｵﾗｸﾙｴﾗｰ発生）が返ってきた場合は必ずHYBS.COMMONSP_ERRORをRAISEします。
	IF	L_STATUS = 9 THEN
		RAISE HYBS.COMMONSP_ERROR;
	-- ｽﾃｰﾀｽが1（異常）の場合の処理は任意です
	ELSIF	L_STATUS = 1 THEN
	-- 行いたい処理（例えばRETURN FALSE）に書き換えて下さい。
		NULL;
	END IF;

	RETURN TRUE;
END INSERT_RTN;
/*******************************************************************************
*	UPDATE_RTN 更新
*******************************************************************************/
FUNCTION UPDATE_RTN
RETURN BOOLEAN
IS
BEGIN
	G_ERRSTP:='UPDATE_RTN';

	UPDATE	GF41	SET
			 NAME_JA		=	G_NAME_JA										-- 名称（漢字）
			,LABEL_NAME		=	G_LABEL_NAME									-- 表示名称
			,KBSAKU			=	G_KBSAKU										-- 作成区分
			,CDTAN			=	G_CDTAN											-- 担当者
			,DYUPD			=	CON_SYSDATE										-- 更新日時
			,PGUPD			=	CON_PGID										-- 更新PG
			,PGPUPD			=	CON_PGPID										-- 更新呼出PG
			,USRUPD			=	CON_USER										-- 更新ﾕｰｻﾞｰ
	WHERE	UNIQ			=	G_UNIQ;											-- ﾕﾆｰｸ ＝ 画面》ﾕﾆｰｸ
	RETURN TRUE;
END UPDATE_RTN;
/*******************************************************************************
*	ﾒｲﾝ処理
*******************************************************************************/
BEGIN
	G_ERRSTP:='MAIN_S';
	-- 処理結果(2:異常)
	PO_KEKKA := 2;

	G_DISP_KEY := ' SYSTEM_ID='|| G_SYSTEM_ID||
				  ' LANG='|| G_LANG||
				  ' CLM='|| G_CLM||
				  ' UNIQ='|| G_UNIQ;

	-- 初期処理
	G_RTN := INIT_PROCESS_RTN;

	-- 登録処理
	IF G_CDKH = 'A' THEN
		-- 追加／複写処理
		G_RTN := INSERT_RTN;
	ELSE
		-- 変更処理
		G_RTN := UPDATE_RTN;
	END IF;

	-- 処理結果(ｴﾗｰﾒｯｾｰｼﾞ配列のｴﾗｰ結果の最大)
	PO_KEKKA	:= HYBS.GET_MAX_KEKKA(PO_ERRMSGS);

	-- 結果ｶｰｿﾙ
	OPEN PO_RC1 FOR
		SELECT SYSDATE FROM DUAL;

/*******************************************************************************
*	例外処理
*******************************************************************************/
EXCEPTION
	-- 共通SPｴﾗｰ
	WHEN HYBS.COMMONSP_ERROR THEN
		HYBS.SET_ERRMSGS2(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
						,1														-- 行番号
						,2														-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
						,CON_PGID												-- ﾌﾟﾛｸﾞﾗﾑID
						,G_ERRSTP												-- ｴﾗｰ発生箇所(ｽﾃｯﾌﾟ)
						,'GFE0005'												-- 共通SPｴﾗｰ発生
						,G_DISP_KEY												-- ｷｰ項目
						);
		-- 処理結果(2:異常)
		PO_KEKKA := 2;
		-- 結果ｶｰｿﾙ
		OPEN PO_RC1 FOR
			SELECT SYSDATE FROM DUAL;

	WHEN OTHERS THEN
		-- ｵﾗｸﾙｴﾗｰ
		HYBS.SET_ERRMSGS2(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
						,1														-- 行番号
						,2														-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
						,CON_PGID												-- ﾌﾟﾛｸﾞﾗﾑID
						,G_ERRSTP												-- ｴﾗｰ発生箇所(ｽﾃｯﾌﾟ)
						,TO_CHAR(SQLCODE)										-- ｵﾗｸﾙｴﾗｰｺｰﾄﾞ
						,SUBSTRB(SQLERRM,1,1000)								-- ｵﾗｸﾙｴﾗｰﾒｯｾｰｼﾞ
						,G_DISP_KEY												-- ｷｰ項目
						);
		-- 処理結果(2:異常)
		PO_KEKKA := 2;
		-- 結果ｶｰｿﾙ
		OPEN PO_RC1 FOR
			SELECT SYSDATE FROM DUAL;

END GF19300A;

END GFP19300A;
/
