<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<!-- POPUPでは、自分自身にsubmiするため、headType="popup" の記述が必要です。 -->
<og:head headType="popup" />

<jsp:directive.include file="/jsp/custom/popup_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9110"
	title	= "ポップアップ"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- 入力チェック -->
<og:columnCheck command = "{@command}" />

<form method="GET" action="popup.jsp" >
	<!-- 変更はここから -->
	<table summary="layout" >
		<tr>
			<og:column name="SYSTEM_ID" defaultVal="{@LAST.SYSTEM_ID}" must="true" />
			<og:column name="LANG"		defaultVal="{@USER.LANG}" />
			<og:column name="KBSAKU" />
		</tr>
		<tr>
			<og:column name="CLM" />
			<!-- colspan属性で、テキストフィールド部のtdの個数を設定できます。-->
			<og:column name="NAME_JA" />
			<og:column name="LABEL_NAME" />
		</tr>
	</table>

	<!-- POPUPでは、scope="request" で検索するので、PrevNextは表示しません。 -->
	<og:queryButton usePrevNext="false" useEditMenu="false">
		<og:select name="ORDER_BY" lbl="ORDER_BY" td="no">
			<og:option value="SYSTEM_ID,CLM,LANG"        lbl ="CLM"     selected="selected" />
			<og:option value="SYSTEM_ID,LANG,NAME_JA"    lbls="LANG,NAME_JA"    />
			<og:option value="SYSTEM_ID,LANG,LABEL_NAME" lbls="LANG,LABEL_NAME" />
		</og:select>
	</og:queryButton>

	<!-- 拡張検索条件 -->
	<og:hideMenu>
	  <table summary="layout">
		<tr>
			<og:column name="FGJ" defaultVal="1"  />
			<og:column name="USRSET"	clazz="aimai"  size="6" />
			<og:column name="DYSET"		clazz="aimai"  size="8" />

		</tr>
		<tr>
			<og:column name="USRUPD"	clazz="aimai"  size="6" />
			<og:column name="DYUPDFROM" lbl="DYUPD" size="8" dbType="YMD" >
				<og:message lbl="KARA"  />
				<og:column name="DYUPDTO" td="false" size="8" dbType="YMD" />
			</og:column>
		</tr>
	  </table>
	</og:hideMenu>
</form>

<hr />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->

<!-- POPUPでは、scope="request" で検索します。 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" scope="request">
		select CLM,NAME_JA,LABEL_NAME,KBSAKU,SYSTEM_ID,LANG,FGJ
		from GF41
	<og:where>
		<og:and value = "FGJ         in  ('0','1')"         />
		<og:and value = "SYSTEM_ID   =  '{@SYSTEM_ID}'"     />
		<og:and value = "LANG        =  '{@LANG}'"          />
		<og:and value = "CLM         like '{@CLM}%'"        />
		<og:and value = "NAME_JA     like '{@NAME_JA}%'"    />
		<og:and value = "LABEL_NAME  like '{@LABEL_NAME}%'" />
		<og:and value = "KBSAKU      =    '{@KBSAKU}'"      />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="{@command}">
	<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" markList="1" >
		<span style="background-color:#ccff00">[NAME_JA]</span>
	</og:columnMarker>
	<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" markList="2" >
		<span style="background-color:#cc00ff">[NAME_JA]</span>
	</og:columnMarker>
	<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" markList="3" >
		<span style="background-color:#00ccff">[NAME_JA]</span>
	</og:columnMarker>
</og:viewMarker>

<!-- viewタグでpopupReturnKeysを設定するとポップアップ時に値を返します -->
<!-- POPUPでは、scope="request" 、selectedType = "radio" で、１件選択するようにします。 -->
<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	scope      = "request"
	selectedType = "radio"
	popupReturnKeys = "SYSTEM_ID,CLM,NAME_JA,LANG,KBSAKU"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
