/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opengion.fukurou.util.HybsConst;

public final class FixLengthData {
    public static final int X = 0;
    public static final int S = 1;
    public static final int K = 2;
    public static final int S0 = 3;
    public static final int T = -1;
    public static final int T2 = -2;
    public static final int T3 = -3;
    public static final int T4 = -4;
    public static final String ENCODE = "Windows-31J";
    private final int[] addLen;
    private final int[] type;
    private final int size;
    private int[] maxLen;
    private String[] fill_X;
    private String[] fill_S;
    private String[] addSpc;
    private final List<String[]> list = new ArrayList<String[]>();

    public FixLengthData(int n) {
        this.size = n;
        this.addLen = new int[this.size];
        this.type = new int[this.size];
        this.maxLen = new int[this.size];
    }

    public FixLengthData(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            throw new IllegalArgumentException("\u9805\u76ee\u9593\u7a7a\u767d\u914d\u5217 \u307e\u305f\u306f\u3001\u9805\u76ee\u306e\u30bf\u30a4\u30d7\u914d\u5217\u306b\u3001null \u306f\u3001\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        this.size = nArray.length;
        this.addLen = new int[this.size];
        this.type = new int[this.size];
        this.maxLen = new int[this.size];
        this.setAddLength(nArray);
        this.setType(nArray2);
    }

    public void setAddLength(int ... nArray) {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (n != this.size) {
            String string = "\u5f15\u6570\u306e\u30c7\u30fc\u30bf\u4ef6\u6570\u304c\u3001\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u3067\u6307\u5b9a\u3057\u305f\u6570\u3068\u7570\u306a\u308a\u307e\u3059\u3002SIZE=[" + this.size + "] , \u5f15\u6570\u9577=[" + n + "]";
            throw new IllegalArgumentException(string);
        }
        System.arraycopy(nArray, 0, this.addLen, 0, this.size);
    }

    public void setType(int ... nArray) {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (n != this.size) {
            String string = "\u5f15\u6570\u306e\u30c7\u30fc\u30bf\u4ef6\u6570\u304c\u3001\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u3067\u6307\u5b9a\u3057\u305f\u6570\u3068\u7570\u306a\u308a\u307e\u3059\u3002SIZE=[" + this.size + "] , \u5f15\u6570\u9577=[" + n + "]";
            throw new IllegalArgumentException(string);
        }
        System.arraycopy(nArray, 0, this.type, 0, this.size);
    }

    public void addListData(String ... stringArray) {
        int n;
        int n2 = n = stringArray == null ? 0 : stringArray.length;
        if (n != this.size) {
            String string = "\u5f15\u6570\u306e\u30c7\u30fc\u30bf\u4ef6\u6570\u304c\u3001\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u3067\u6307\u5b9a\u3057\u305f\u6570\u3068\u7570\u306a\u308a\u307e\u3059\u3002SIZE=[" + this.size + "] , \u5f15\u6570\u9577=[" + n + "]";
            throw new IllegalArgumentException(string);
        }
        try {
            for (int i = 0; i < this.size; ++i) {
                if (stringArray[i] == null || this.maxLen[i] >= (n = this.type[i] == 2 ? stringArray[i].getBytes(ENCODE).length : stringArray[i].length())) continue;
                this.maxLen[i] = n;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("\u30c7\u30fc\u30bf\u306e\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[Windows-31J]", unsupportedEncodingException);
        }
        this.list.add(stringArray);
    }

    public String getFixData(int n) {
        if (this.fill_X == null) {
            this.makeSpace();
        }
        String[] stringArray = this.list.get(n);
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.size; ++i) {
            String string = stringArray[i] == null ? "" : stringArray[i];
            switch (this.type[i]) {
                case 0: {
                    stringBuilder.append(string);
                    stringBuilder.append(this.fill_X[i].substring(string.length()));
                    break;
                }
                case 1: {
                    stringBuilder.append(this.fill_X[i].substring(string.length()));
                    stringBuilder.append(string);
                    break;
                }
                case 3: {
                    stringBuilder.append(this.fill_S[i].substring(string.length()));
                    stringBuilder.append(string);
                    break;
                }
                case 2: {
                    try {
                        int n2 = string.getBytes(ENCODE).length;
                        stringBuilder.append(string);
                        stringBuilder.append(this.fill_X[i].substring(n2));
                        break;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new RuntimeException("\u30c7\u30fc\u30bf\u306e\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[Windows-31J]", unsupportedEncodingException);
                    }
                }
                default: {
                    String string2 = "\u4e0d\u6b63\u306a\u7a2e\u5225\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f[" + this.type[i] + "]";
                    throw new RuntimeException(string2);
                }
            }
            stringBuilder.append(this.addSpc[i]);
        }
        return stringBuilder.toString();
    }

    public void addAllListData(String[][] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addListData(stringArray[i]);
        }
    }

    public String getAllFixData() {
        return this.getAllFixData(new StringBuilder(1000)).toString();
    }

    public StringBuilder getAllFixData(StringBuilder stringBuilder) {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.getFixData(i)).append(HybsConst.CR);
        }
        return stringBuilder;
    }

    private void makeSpace() {
        this.fill_X = new String[this.size];
        this.fill_S = new String[this.size];
        this.addSpc = new String[this.size];
        int n = 0;
        block4: for (int i = 0; i < this.size; ++i) {
            n += this.maxLen[i];
            int n2 = this.addLen[i];
            if (n2 < 0) {
                n2 = -4 * n2 - n % 4;
            }
            char[] cArray = new char[n2];
            Arrays.fill(cArray, ' ');
            this.addSpc[i] = String.valueOf(cArray);
            n += n2;
            cArray = new char[this.maxLen[i]];
            switch (this.type[i]) {
                case 3: {
                    Arrays.fill(cArray, '0');
                    this.fill_S[i] = String.valueOf(cArray);
                    continue block4;
                }
                case 0: 
                case 1: 
                case 2: {
                    Arrays.fill(cArray, ' ');
                    this.fill_X[i] = String.valueOf(cArray);
                    continue block4;
                }
                default: {
                    String string = "\u4e0d\u6b63\u306a\u7a2e\u5225\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f[" + this.type[i] + "]";
                    throw new RuntimeException(string);
                }
            }
        }
    }

    public void clear() {
        this.list.clear();
        this.maxLen = new int[this.size];
        this.fill_X = null;
        this.fill_S = null;
        this.addSpc = null;
    }
}

