/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.xml.XMLFileLoader;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TransactionTag;

public class DirectXMLSaveTag
extends CommonTagSupport {
    private static final String VERSION = "6.0.2.0 (2014/09/19)";
    private static final long serialVersionUID = 602020140919L;
    private String dbid;
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String filename;
    private String displayMsg = "MSG0003";
    private String[] keys;
    private String[] vals;
    private long dyStart;
    private boolean useTimeStamp;

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            this.dyStart = System.currentTimeMillis();
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        int n;
        Object object;
        Object object2;
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        StringWriter stringWriter = new StringWriter();
        String string = HybsSystem.url2dir(this.fileURL);
        File file = this.filename != null ? new File(string, this.filename) : new File(string);
        boolean bl = true;
        Object object3 = null;
        try {
            object2 = (TransactionTag)DirectXMLSaveTag.findAncestorWithClass((Tag)this, TransactionTag.class);
            object3 = object2 == null ? new TransactionReal(this.getApplicationInfo()) : ((TransactionTag)((Object)object2)).getTransaction();
            Connection connection = object3.getConnection(this.dbid);
            object = new XMLFileLoader(connection, this.useTimeStamp);
            if (this.keys != null) {
                object.setAfterMap(this.getAfterMap());
            }
            object.setLogWriter((Writer)stringWriter);
            object.loadXMLFiles(file);
            int[] nArray = object.getCRUDCount();
            n = nArray[0];
            object3.commit();
            bl = false;
        }
        catch (Throwable throwable) {
            if (object3 != null) {
                object3.rollback();
            }
            throw new HybsSystemException(throwable);
        }
        finally {
            if (object3 != null) {
                object3.close(bl);
            }
        }
        if (this.displayMsg != null && this.displayMsg.length() > 0) {
            object2 = new StringBuilder(200).append("<pre>").append(stringWriter.toString()).append(CR).append(HybsSystem.getDate()).append("  ").append(this.getResource().getLabel(this.displayMsg)).append(CR).append("</pre>");
            this.jspPrint(((StringBuilder)object2).toString());
        }
        long l = System.currentTimeMillis() - this.dyStart;
        this.jspPrint("<div id=\"queryTime\" value=\"" + l + "\"></div>");
        object = (GUIInfo)this.getSessionAttribute("h_gInfo");
        if (object != null) {
            ((GUIInfo)object).addWriteCount(n, l, file.getPath());
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.dbid = null;
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.filename = null;
        this.displayMsg = "MSG0003";
        this.keys = null;
        this.vals = null;
        this.useTimeStamp = false;
    }

    private Map<String, String> getAfterMap() {
        if (this.keys == null || this.vals == null) {
            return null;
        }
        if (this.keys.length != this.vals.length) {
            String string = "keys \u3068 vals \u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002 keys=" + Arrays.toString(this.keys) + " vals=" + Arrays.toString(this.vals);
            throw new HybsSystemException(string);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null || this.keys[i].length() <= 0) continue;
            hashMap.put(this.keys[i], this.vals[i]);
        }
        return hashMap;
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2, (String[])new String[0]);
        }
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.filename);
    }

    public void setDisplayMsg(String string) {
        if (string != null) {
            this.displayMsg = string;
        }
    }

    public void setKeys(String string) {
        this.keys = this.getCSVParameter(string);
    }

    public void setVals(String string) {
        this.vals = this.getCSVParameter(string);
    }

    public void setUseTimeStamp(String string) {
        this.useTimeStamp = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useTimeStamp);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("dbid", (Object)this.dbid).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).println("displayMsg", (Object)this.displayMsg).println("dyStart", (Object)this.dyStart).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

