/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.io.BufferedReader;
import java.util.Map;
import org.opengion.fukurou.util.CSVTokenizer;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.io.TableReader;
import org.opengion.hayabusa.resource.CodeData;
import org.opengion.hayabusa.resource.ResourceManager;

public abstract class AbstractTableReader
implements TableReader {
    private static final String VERSION = "6.1.0.0 (2014/12/26)";
    protected static final String CR = HybsConst.CR;
    protected static final int BUFFER_MIDDLE = 200;
    private String separator = "\t";
    private ResourceManager resource;
    private int maxRowCount = HybsSystem.sysInt("DB_MAX_ROW_COUNT");
    protected DBTableModel table;
    protected DBColumn[] dbColumn;
    private int[] clmNo;
    protected String columns;
    private String omitNames;
    private String encode;
    private boolean useNumber = true;
    private int skipRowCount;
    private boolean useRenderer;
    private Map<?, ?>[] maps;
    private boolean useDebug;

    @Override
    public abstract void readDBTable();

    @Override
    public abstract void readDBTable(BufferedReader var1);

    @Override
    public void setResourceManager(ResourceManager resourceManager) {
        this.resource = resourceManager;
    }

    protected int setTableDBColumn(String[] stringArray) {
        int n;
        String[] stringArray2;
        this.clmNo = new int[stringArray.length];
        int n2 = 0;
        if (this.omitNames != null) {
            stringArray2 = "," + this.omitNames + ",";
            for (n = 0; n < stringArray.length; ++n) {
                this.clmNo[n] = stringArray2.indexOf("," + stringArray[n] + ",") < 0 ? n2++ : -1;
            }
        } else {
            n2 = stringArray.length;
            for (int i = 0; i < stringArray.length; ++i) {
                this.clmNo[i] = i;
            }
        }
        stringArray2 = new String[n2];
        this.table.init(n2);
        this.dbColumn = new DBColumn[n2];
        if (this.useRenderer) {
            this.maps = new Map[stringArray.length];
        }
        n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.clmNo[i] < 0) continue;
            DBColumn dBColumn = this.resource.makeDBColumn(stringArray[i]);
            this.table.setDBColumn(n, dBColumn);
            this.dbColumn[n++] = dBColumn;
            if (!this.useRenderer) continue;
            CodeData codeData = dBColumn.getCodeData();
            this.maps[i] = codeData != null ? codeData.makeLabelMap() : null;
        }
        return n2;
    }

    protected void setTableColumnValues(String[] stringArray) {
        if (this.useRenderer) {
            String[] stringArray2 = new String[this.table.getColumnCount()];
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.clmNo[i] < 0) continue;
                String string = stringArray[i];
                if (this.maps[i] != null) {
                    if (string == null) {
                        string = "";
                    } else {
                        String string2 = (String)this.maps[i].get(string);
                        if (string2 != null) {
                            string = string2;
                        } else {
                            int n2 = string.indexOf(58);
                            if (n2 >= 0) {
                                string = string.substring(0, n2);
                            }
                        }
                    }
                }
                stringArray2[n++] = string;
            }
            this.table.addColumnValues(stringArray2);
        } else if (this.omitNames != null) {
            String[] stringArray3 = new String[this.table.getColumnCount()];
            int n = 0;
            for (int i = 0; i < this.clmNo.length; ++i) {
                if (this.clmNo[i] < 0) continue;
                stringArray3[n++] = stringArray[i];
            }
            this.table.addColumnValues(stringArray3);
        } else {
            this.table.addColumnValues(stringArray);
        }
    }

    protected String[] readData(String string, int n) {
        String[] stringArray = new String[n];
        CSVTokenizer cSVTokenizer = new CSVTokenizer(string, this.separator.charAt(0));
        if (this.useNumber) {
            cSVTokenizer.nextToken();
        }
        int n2 = 0;
        while (cSVTokenizer.hasMoreTokens()) {
            String string2 = StringUtil.csvOutQuote((String)cSVTokenizer.nextToken());
            stringArray[n2++] = string2 != null && string2.startsWith("'0") ? StringUtil.rTrim((String)string2.substring(1)) : StringUtil.rTrim((String)string2);
            if (n2 < n) continue;
            break;
        }
        for (int i = n2; i < n; ++i) {
            stringArray[i] = "";
        }
        return stringArray;
    }

    @Override
    public DBTableModel getDBTableModel() {
        return this.table;
    }

    @Override
    public void setSeparator(String string) {
        if (string != null) {
            this.separator = string;
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    @Override
    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    @Override
    public void setMaxRowCount(int n) {
        this.maxRowCount = n > 0 ? n : Integer.MAX_VALUE;
    }

    @Override
    public void setSheetName(String string) {
        throw new UnsupportedOperationException("\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
    }

    @Override
    public void setSheetNos(String string) {
        throw new UnsupportedOperationException("\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
    }

    @Override
    public void setSheetConstData(String string, String string2) {
        throw new UnsupportedOperationException("\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
    }

    @Override
    public void setNullBreakClm(String string) {
        throw new UnsupportedOperationException("\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
    }

    @Override
    public boolean isExcel() {
        return false;
    }

    @Override
    public void setFilename(String string) {
        throw new UnsupportedOperationException("\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
    }

    @Override
    public void setColumns(String string) {
        this.columns = string;
    }

    @Override
    public void setOmitNames(String string) {
        this.omitNames = string;
    }

    @Override
    public void setEncode(String string) {
        this.encode = string;
    }

    protected String getEncode() {
        return this.encode;
    }

    @Override
    public void setUseNumber(boolean bl) {
        this.useNumber = bl;
    }

    public int getSkipRowCount() {
        return this.skipRowCount;
    }

    @Override
    public void setSkipRowCount(int n) {
        this.skipRowCount = n;
    }

    @Override
    public void setUseRenderer(boolean bl) {
        this.useRenderer = bl;
    }

    protected boolean isUseNumber() {
        return this.useNumber;
    }

    @Override
    public void setDebug(boolean bl) {
        this.useDebug = bl;
    }

    protected boolean isDebug() {
        return this.useDebug;
    }
}

