/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import com.sun.star.bridge.UnoUrlResolver;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatchHelper;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.File;
import java.io.IOException;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;

public class SOfficeProcess {
    public static final String OFFICE_HOME = new File(System.getenv("OFFICE_HOME")).getAbsolutePath() + File.separator;
    public static final String ENV_DIR = HybsSystem.url2dir(StringUtil.nval((String)HybsSystem.sys("REPORT_FILE_URL"), (String)(HybsSystem.sys("FILE_URL") + "REPORT" + File.separator)) + "oooenv") + File.separator;
    private static final String DEFAULT_ENV_PATH = OFFICE_HOME + "env" + File.separator + "_default";
    private static final String SOFFICE_BIN = OFFICE_HOME + File.separator + "program" + File.separator + "soffice.bin";
    private static XComponentContext xLocalContext = null;
    private final String envPath;
    private final String envId;
    private XDesktop desktop;
    private XComponentContext remoteContext;
    private Process process;

    protected SOfficeProcess(String string) {
        this.envId = string;
        this.envPath = ENV_DIR + this.envId;
    }

    protected void bootstrap() {
        System.out.println("[INFO]OOo:Starting soffice process,ENV-ID=" + this.envId);
        this.checkEnv(this.envPath);
        String string = "uno_" + HybsSystem.sys("HOST_URL").replace(':', '_').replace('/', '_') + "_" + this.envId;
        this.process = this.execOffice(this.envPath, string);
        System.out.println("[INFO]OOo:Invoke soffice.bin,ENV-ID=" + this.envId);
        XUnoUrlResolver xUnoUrlResolver = UnoUrlResolver.create((XComponentContext)xLocalContext);
        String string2 = this.getConnParam(string);
        try {
            int n = 0;
            while (true) {
                try {
                    Object object = xUnoUrlResolver.resolve(string2);
                    this.remoteContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)object);
                    if (this.remoteContext == null) {
                        throw new BootstrapException("no component context!");
                    }
                }
                catch (NoConnectException noConnectException) {
                    System.out.println("[INFO]OOo:Waiting for Connect soffice process,ENV-ID=" + this.envId);
                    if (n == 60) {
                        throw new BootstrapException((Exception)((Object)noConnectException));
                    }
                    Thread.sleep(1000L);
                    ++n;
                    continue;
                }
                break;
            }
            XMultiComponentFactory xMultiComponentFactory = this.remoteContext.getServiceManager();
            this.desktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)xMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.Desktop", this.remoteContext));
        }
        catch (Exception exception) {
            throw new HybsSystemException("[ERROR] Can't create Desktop Instance", exception);
        }
        System.out.println("[INFO]OOo:Connected successful,ENV-ID=" + this.envId);
    }

    protected String getConnParam(String string) {
        return "uno:pipe,name=" + string + ";urp;StarOffice.ComponentContext";
    }

    public XDesktop getDesktop() {
        return this.desktop;
    }

    public void close() {
        this.process.destroy();
        FileUtil.deleteFiles((File)new File(this.envPath));
        System.out.println("[INFO]OOo:Destroy process,ENV-ID=" + this.envId);
    }

    private Process execOffice(String string, String string2) {
        Process process;
        String[] stringArray = new String[]{SOFFICE_BIN, "-nologo", "-nodefault", "-norestore", "-nocrashreport", "-nolockcheck", "-minimized", "-invisible", "-headless", "-env:UserInstallation=file:///" + string.replace('\\', '/'), this.getProcParam(string2)};
        try {
            process = Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            throw new HybsSystemException("[ERROR] Cant't exec soffice.bin", iOException);
        }
        return process;
    }

    protected String getProcParam(String string) {
        return "-accept=pipe,name=" + string + ";urp;";
    }

    private void checkEnv(String string) {
        if (OFFICE_HOME == null || OFFICE_HOME.isEmpty()) {
            throw new HybsSystemException("OFFICE_HOME\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001OpenOffice\u3092\u8d77\u52d5\u3067\u304d\u307e\u305b\u3093");
        }
        FileUtil.copyDirectry((String)DEFAULT_ENV_PATH, (String)string);
        if (!new File(this.getTempPath()).mkdirs()) {
            System.err.println("\u30d5\u30a1\u30a4\u30eb\u30de\u30fc\u30b8\u6642\u306e\u30c6\u30f3\u30dd\u30e9\u30ea\u30d5\u30a9\u30eb\u30c0\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + this.getTempPath() + "]");
        }
    }

    public XDispatchHelper getDispatcher() {
        XMultiComponentFactory xMultiComponentFactory = this.remoteContext.getServiceManager();
        XDispatchHelper xDispatchHelper = null;
        try {
            xDispatchHelper = (XDispatchHelper)UnoRuntime.queryInterface(XDispatchHelper.class, (Object)xMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.DispatchHelper", this.remoteContext));
        }
        catch (com.sun.star.uno.Exception exception) {
            throw new HybsSystemException("\u30c7\u30a3\u30b9\u30d1\u30c3\u30c1\u30e3\u30fc\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", exception);
        }
        return xDispatchHelper;
    }

    public String getTempPath() {
        return this.envPath + File.separator + "temp" + File.separator;
    }

    static {
        try {
            xLocalContext = Bootstrap.createInitialComponentContext(null);
        }
        catch (Throwable throwable) {
            System.out.println("[ERROR]OOo:Can't start LocalContext,Check OFFICE_HOME!");
            throwable.printStackTrace();
        }
    }
}

