/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.html;


/**
 * URLにトークンを付加するためのインタフェイスです
 * 各種のトークンをサポートするには、CreateToken インターフェースを implements した
 * クラスを作成してください。
 * CreateToken 自体はlinkTagクラスよりアクセスされます。
 *
 *
 * @og.group 画面表示
 * @og.rev 5.8.2.1 (2014/12/13) 新規作成
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public interface CreateToken {

	/**
	 * トークン付のURLを返します。
	 *
	 * @param	inURL	トークンを付加するURL
	 * @param   time	有効期限(millis）
	 * @param	user	ユーザ
	 * 
	 * @return	トークン付URL
	 */
	String generateURL( final String inURL, final long time, final String user ) ;

	/**
	 * トークン付のURLを返します。
	 *
	 * @param	inURL	トークンを付加するURL
	 * @param   time	有効期限(millis）
	 * @param	user	ユーザ
	 * @param	param	パラメータ配列
	 * 
	 * @return	トークン付URL
	 */
	String generateURL( final String inURL, final long time, final String user, final String[] param ) ;

	/**
	 * Aタグの文字列を解析して、トークンを付加します。
	 *
	 * @param   tag		Aタグ文字列
	 * @param   time	有効期限(millis）
	 * @param	user	ユーザ
	 *
	 * @return  トークンが付加されたAタグ文字列
	 */
	String embedToken( final String tag, final long time, final String user  );

	/**
	 * Aタグの文字列を解析して、トークンを付加します。
	 *
	 * @param   tag		Aタグ文字列
	 * @param   time	有効期限(millis）
	 * @param	user	ユーザ
	 * @param	param	パラメータ配列
	 *
	 * @return  トークンが付加されたAタグ文字列
	 */
	String embedToken( final String tag, final long time, final String user, final String[] param  );
}
