/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.table;

/**
 * TableFilter_SEQUENCE_SQLSERVER は、TableUpda インターフェースを継承した、DBTableModel 処理用の
 * 実装クラスです。
 *
 * ここでは、シーケンス一覧の検索結果より、GF09 のシーケンス定義テーブルから
 * 必要な情報を取得し、シーケンス作成スクリプトを作成します。
 *
 * この処理を実行するには、DBTableModelのカラムとして、
 *  SEQNAME,INCREBY,STARTVAL,MINVAL,MAXVAL,FGCYCLE,SUCACHE
 * が必要です。
 *
 * ※SQLServerに対して生成されるスクリプトでは、INCREBY,MINVAL,MAXVAL,FGCYCLE,SUCACHEは無視されます。
 *   なお、SQLServerではシーケンスはサポートされていないため、シーケンス名と同じ名前のシーケンス採番テーブルを生成し、
 *   これを1ずつ加算してアップデートすることで、シーケンスをエミュレートします。(この実装は未テストです)
 *
 * @og.rev 5.1.9.0 (2010/08/01) DB定義DB・シーケンス定義追加
 * @version  0.9.0  2010/08/01
 * @author   Hiroki Nakamura
 * @since    JDK1.1,
 */
public class TableFilter_SEQUENCE_SQLSERVER extends TableFilter_SEQUENCE {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.0.2.3 (2014/10/10)" ;

	/**
	 * シーケンス作成の処理を実行します。
	 *
	 * @og.rev 6.0.2.3 (2014/10/10) isXml で、CR + EXEC_END_TAG のキャッシュ(execEndTag)を利用します。
	 *
	 * @param	clmNo	カラム番号配列
	 * @param	data	１行分のデータ配列
	 *
	 * @return	シーケンス作成
	 */
	@Override
	protected String makeLineList( final int[] clmNo,final String[] data ) {
		final StringBuilder buf = new StringBuilder( BUFFER_MIDDLE );

		if( isXml ) { buf.append( EXEC_START_TAG ).append( CR ); }
		buf.append( "CREATE TABLE " ).append( data[clmNo[SEQNAME]] ).append( CR )
			.append( "  (SEQID INT NOT NULL)" )
			// 6.0.2.3 (2014/10/10) EXEC_END_TAG の置き換え＋"/" の判定が必要。
			.append( execEndTag )
//		if( isXml )	{ buf.append( CR ).append( EXEC_END_TAG ); }
//		else		{ buf.append( " ;" ); }
			.append( CR ).append( CR );

		if( isXml ) { buf.append( EXEC_START_TAG ).append( CR ); }
//		int startVal = Integer.valueOf( data[clmNo[STARTVAL]] );
		int startVal = Integer.parseInt( data[clmNo[STARTVAL]] );		// 6.0.2.4 (2014/10/17) メソッド間違い
		if( startVal < 0 ) { startVal = 0; }
		buf.append( "INSERT INTO " ).append( data[clmNo[SEQNAME]] )
			.append( " VALUES (" ).append( startVal ).append( ')' )		// 6.0.2.5 (2014/10/31) char を append する。
			// 6.0.2.3 (2014/10/10) EXEC_END_TAG の置き換え＋"/" の判定が必要。
			.append( execEndTag );
//		if( isXml )	{ buf.append( CR ).append( EXEC_END_TAG ); }
//		else		{ buf.append( " ;" ); }

		return buf.toString();
	}
}
