/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.io.BufferedReader;
import org.opengion.fukurou.util.ExcelReaderEvent;
import org.opengion.fukurou.util.POIUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.plugin.io.TableReader_Default;

public class TableReader_Excel
extends TableReader_Default {
    private static final String VERSION = "6.1.0.0 (2014/12/26)";
    private String filename;
    private String sheetName;
    private String sheetNos;
    private String constKeys;
    private String constAdrs;
    private String nullBreakClm;

    @Override
    public void readDBTable() {
        final boolean bl = this.isDebug();
        if (bl) {
            System.out.println(" Filename=" + this.filename);
        }
        this.table = DBTableModelUtil.newDBTable();
        ExcelReaderEvent excelReaderEvent = new ExcelReaderEvent(){
            private boolean[] useShtNo;
            private int nullBreakClmAdrs = -1;

            public void sheetSize(int n) {
                if (bl) {
                    System.out.println(" sheetSize=" + n);
                }
                this.useShtNo = new boolean[n];
                if (TableReader_Excel.this.sheetNos != null && TableReader_Excel.this.sheetNos.length() > 0) {
                    String[] stringArray = StringUtil.csv2ArrayExt((String)TableReader_Excel.this.sheetNos, (int)(n - 1));
                    for (int i = 0; i < stringArray.length; ++i) {
                        int n2 = Integer.parseInt(stringArray[i]);
                        this.useShtNo[n2] = true;
                    }
                } else {
                    this.useShtNo[0] = true;
                }
            }

            public boolean startSheet(String string, int n) {
                if (bl) {
                    System.out.println(" Sheet[" + n + "]=" + string);
                }
                super.startSheet(string, n);
                return this.useShtNo != null && this.useShtNo[n] || TableReader_Excel.this.sheetName != null && TableReader_Excel.this.sheetName.equalsIgnoreCase(string);
            }

            public void columnNames(String ... stringArray) {
                TableReader_Excel.this.setTableDBColumn(stringArray);
                if (TableReader_Excel.this.nullBreakClm != null) {
                    this.nullBreakClmAdrs = TableReader_Excel.this.table.getColumnNo(TableReader_Excel.this.nullBreakClm, false);
                }
            }

            public void values(String[] stringArray, int n) {
                if (this.nullBreakClmAdrs >= 0 && (stringArray[this.nullBreakClmAdrs] == null || stringArray[this.nullBreakClmAdrs].isEmpty())) {
                    this.setSheetBreak(true);
                    return;
                }
                if (bl && n % 100 == 0) {
                    System.out.println("   rowNo=" + n);
                }
                TableReader_Excel.this.setTableColumnValues(stringArray);
            }
        };
        excelReaderEvent.setSheetConstData(this.constKeys, this.constAdrs);
        excelReaderEvent.setNames(this.columns, this.isUseNumber());
        excelReaderEvent.setSkipRowCount(this.getSkipRowCount());
        POIUtil.excelReader((String)this.filename, (ExcelReaderEvent)excelReaderEvent);
        if (!excelReaderEvent.isNameSet()) {
            String string = "\u6700\u5f8c\u307e\u3067\u3001#NAME \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + "\u30d5\u30a1\u30a4\u30eb\u304c\u7a7a\u304b\u3001\u3082\u3057\u304f\u306f\u640d\u50b7\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" + CR;
            throw new HybsSystemException(string);
        }
        if (bl) {
            System.out.println("  TableReader End.");
        }
    }

    @Override
    public void readDBTable(BufferedReader bufferedReader) {
        throw new UnsupportedOperationException("\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
    }

    public void setSheetName(String string) {
        this.sheetName = string;
    }

    public void setSheetNos(String string) {
        this.sheetNos = string;
    }

    public void setSheetConstData(String string, String string2) {
        this.constKeys = string;
        this.constAdrs = string2;
    }

    public void setNullBreakClm(String string) {
        this.nullBreakClm = string;
    }

    public boolean isExcel() {
        return true;
    }

    public void setFilename(String string) {
        this.filename = string;
        if (string == null) {
            throw new HybsSystemException("\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
    }
}

