/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.Options;
import org.opengion.fukurou.util.StringUtil;

public final class XHTMLTag {
    private static final HybsCryptography HYBS_CRYPTOGRAPHY = new HybsCryptography();
    private static final String[] BUTTON_KEY = new String[]{"type", "name", "value", "onClick", "id", "class", "lang", "dir", "title", "style", "xml:lang", "disabled", "tabindex", "accesskey", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "autofocus"};
    private static final String[] INPUT_KEY = new String[]{"type", "size", "maxlength", "checked", "src", "alt", "accept", "usemap", "ismap", "id", "class", "lang", "dir", "title", "style", "xml:lang", "readonly", "disabled", "tabindex", "accesskey", "onClick", "onChange", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "onSelect", "onKeydown", "onKeypress", "onKeyup", "autocomplete", "autofocus", "pattern", "placeholder", "list", "min", "max", "step", "required"};
    private static final String[] TEXTAREA_KEY = new String[]{"name", "rows", "cols", "id", "class", "lang", "dir", "title", "style", "xml:lang", "readonly", "disabled", "tabindex", "accesskey", "onClick", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "onSelect", "onKeydown", "onKeypress", "onKeyup", "autofocus", "placeholder"};
    private static final String[] LINK_KEY = new String[]{"type", "name", "hreflang", "rel", "rev", "charset", "target", "shape", "coords", "onClick", "id", "class", "lang", "dir", "title", "style", "xml:lang", "tabindex", "accesskey", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver"};
    private static final String[] SELECT_KEY = new String[]{"size", "multiple", "id", "class", "lang", "dir", "title", "style", "xml:lang", "disabled", "tabindex", "onClick", "onChange", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "onSelect", "onKeydown", "onKeypress", "onKeyup", "autofocus"};
    private static final String[] OPTION_KEY = new String[]{"value", "label", "selected", "id", "class", "lang", "dir", "title", "style", "xml:lang", "disabled"};
    private static final String[] FRAME_KEY = new String[]{"name", "longdesc", "marginwidth", "marginheight", "noresize", "scrolling", "frameborder", "id", "class", "title", "style"};
    private static final String[] IMAGE_KEY = new String[]{"src", "alt", "longdesc", "width", "height", "usemap", "ismap", "name", "onClick", "align", "border", "hspace", "vspace", "id", "class", "title", "style", "lang", "dir", "xml:lang", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver"};
    private static final String[] FORM_KEY = new String[]{"action", "method", "enctype", "accept-charset", "accept", "name", "target", "id", "class", "title", "style", "lang", "dir", "xml:lang"};
    private static final String[] SPAN_KEY = new String[]{"id", "class", "title", "style", "lang", "dir", "xml:lang"};
    private static final String[] PRE_KEY = new String[]{"id", "class", "title", "style", "lang", "dir", "xml:lang"};

    private XHTMLTag() {
    }

    public static String button(Attributes attributes) {
        String string = attributes.get("type");
        if ("|submit|reset|button|".indexOf("|" + string + "|") < 0) {
            String string2 = "button \u30bf\u30a4\u30d7\u8a2d\u5b9a\u30a8\u30e9\u30fc [" + string + "]";
            throw new RuntimeException(string2);
        }
        String string3 = attributes.getAttribute(BUTTON_KEY);
        String string4 = attributes.get("body");
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder = new StringBuilder(200).append("<button ").append(string3).append('>').append(string4).append("</button>");
        return stringBuilder.toString();
    }

    public static String input(Attributes attributes) {
        String string = attributes.get("name");
        String string2 = attributes.get("value");
        String string3 = attributes.get("optionAttributes");
        return XHTMLTag.input(attributes, string, string2, string3);
    }

    public static String input(Attributes attributes, String string, String string2, String string3) {
        String string4 = attributes.getAttribute(INPUT_KEY);
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<input ");
        if (string != null) {
            stringBuilder.append("name=\"").append(string).append("\" ");
        }
        if (string2 != null) {
            stringBuilder.append("value=\"").append(string2).append("\" ");
        }
        stringBuilder.append(string4);
        if (string3 != null) {
            stringBuilder.append(' ');
            stringBuilder.append(string3);
        }
        stringBuilder.append(" />");
        return stringBuilder.toString();
    }

    public static String inputAttri(Attributes attributes) {
        return attributes.getAttribute(INPUT_KEY);
    }

    public static String textareaAttri(Attributes attributes) {
        return attributes.getAttribute(TEXTAREA_KEY);
    }

    public static String selectAttri(Attributes attributes) {
        return attributes.getAttribute(SELECT_KEY);
    }

    public static String hidden(String string, String string2) {
        return XHTMLTag.hidden(string, string2, string);
    }

    public static String hidden(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(200).append("<input type=\"hidden\" ").append("name=\"").append(string).append("\" value=\"").append(string2).append("\" id=\"").append(string3).append("\" />");
        return stringBuilder.toString();
    }

    public static String textarea(Attributes attributes) {
        String string = attributes.getAttribute(TEXTAREA_KEY);
        String string2 = attributes.get("body");
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder = new StringBuilder(200).append("<textarea ").append(string).append('>').append(string2).append("</textarea>");
        return stringBuilder.toString();
    }

    public static String link(Attributes attributes) {
        return XHTMLTag.link(attributes, "");
    }

    public static String link(Attributes attributes, String string) {
        String string2 = XHTMLTag.addUrlEncode(attributes.get("href"), string);
        String string3 = attributes.getAttribute(LINK_KEY);
        String string4 = attributes.get("body");
        if (string4 == null) {
            string4 = attributes.get("href");
        }
        StringBuilder stringBuilder = new StringBuilder(200).append("<a href=\"").append(string2).append("\" ").append(string3).append('>').append(string4).append("</a>");
        return stringBuilder.toString();
    }

    public static String xlink(Attributes attributes, String string) {
        String string2 = XHTMLTag.addUrlEncode(attributes.get("href"), string, "&amp;");
        String string3 = attributes.getAttribute(LINK_KEY);
        String string4 = attributes.get("body");
        if (string4 == null) {
            string4 = attributes.get("href");
        }
        StringBuilder stringBuilder = new StringBuilder(200).append("<a xlink:href=\"").append(string2).append("\" ").append(string3).append('>').append(string4).append("</a>");
        return stringBuilder.toString();
    }

    public static String select(Attributes attributes, Options options) {
        String string = attributes.get("name");
        String string2 = attributes.get("optionAttributes");
        return XHTMLTag.select(attributes, options, string, string2);
    }

    public static String select(Attributes attributes, Options options, String string, String string2) {
        String string3 = attributes.getAttribute(SELECT_KEY);
        String string4 = options.getOption();
        StringBuilder stringBuilder = new StringBuilder(200).append("<select ");
        if (string != null) {
            stringBuilder.append("name=\"").append(string).append("\" ");
        }
        stringBuilder.append(string3);
        if (string2 != null) {
            stringBuilder.append(' ').append(string2);
        }
        stringBuilder.append('>').append(string4).append("</select>");
        return stringBuilder.toString();
    }

    public static String option(Attributes attributes) {
        String string = attributes.getAttribute(OPTION_KEY);
        String string2 = attributes.get("body");
        if (string2 == null) {
            string2 = "No Label";
        }
        StringBuilder stringBuilder = new StringBuilder(200).append("<option ").append(string).append(" >").append(string2).append("</option>");
        return stringBuilder.toString();
    }

    public static String option(Attributes attributes, String string) {
        if (string != null) {
            String string2 = attributes.get("value");
            String string3 = attributes.get("label");
            String string4 = "label";
            if (string3 == null) {
                string3 = attributes.get("body");
                string4 = "body";
            }
            if (string2 != null && string3 != null) {
                boolean bl = "true".equalsIgnoreCase(string);
                boolean bl2 = string3.startsWith(string2 + ':');
                if (bl && !bl2) {
                    attributes.set(string4, string2 + ':' + string3);
                } else if (!bl && bl2) {
                    attributes.set(string4, string3.substring((string2 + ':').length()));
                }
            }
        }
        return XHTMLTag.option(attributes);
    }

    public static String frame(Attributes attributes) {
        return XHTMLTag.frame(attributes, "");
    }

    public static String frame(Attributes attributes, String string) {
        StringBuilder stringBuilder = new StringBuilder(200).append("<frame src=\"").append(XHTMLTag.addUrlEncode(attributes.get("src"), string)).append("\" ").append(attributes.getAttribute(FRAME_KEY)).append(" />");
        return stringBuilder.toString();
    }

    public static String urlEncode(String string, String string2) {
        return XHTMLTag.urlEncode(string, string2, "&");
    }

    public static String urlEncode(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return "";
        }
        String[] stringArray = StringUtil.csv2Array(string);
        String[] stringArray2 = StringUtil.csv2Array(string2);
        return XHTMLTag.urlEncode(stringArray, stringArray2, string3);
    }

    public static String urlEncode(String[] stringArray, String[] stringArray2) {
        return XHTMLTag.urlEncode(stringArray, stringArray2, "&");
    }

    public static String urlEncode(String[] stringArray, String[] stringArray2, String string) {
        if (stringArray == null || stringArray.length == 0 || stringArray2 == null || stringArray2.length == 0) {
            return "";
        }
        if (stringArray.length != stringArray2.length) {
            String string2 = "urlEncode \u306e\u30ad\u30fc\u3068\u30d0\u30ea\u30e5\u30fc\u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002" + HybsConst.CR + "key.length=[" + stringArray.length + "]  val.length=[" + stringArray2.length + "]";
            throw new RuntimeException(string2);
        }
        String[] stringArray3 = new String[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray[i] == null || stringArray[i].isEmpty()) {
                return "";
            }
            stringArray3[i] = stringArray2[i] == null || stringArray2[i].isEmpty() ? "" : (stringArray2[i].charAt(0) == '[' ? stringArray2[i] : StringUtil.urlEncode(stringArray2[i]));
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(stringArray[0]).append('=').append(stringArray3[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(stringArray[i]).append('=').append(stringArray3[i]);
        }
        return stringBuilder.toString();
    }

    public static String addUrlEncode(String string, String string2) {
        return XHTMLTag.addUrlEncode(string, string2, "&");
    }

    public static String addUrlEncode(String string, String string2, String string3) {
        String string4;
        String string5 = string4 = string == null ? "" : string;
        if (string2 == null || string2.isEmpty()) {
            return string4;
        }
        String string6 = string4.indexOf(63) < 0 ? (string2.startsWith(string3) ? string4 + "?" + string2.substring(string3.length()) : string4 + "?" + string2) : (string2.startsWith(string3) ? string4 + string2 : string4 + string3 + string2);
        return string6;
    }

    public static String img(Attributes attributes) {
        String string = attributes.getAttribute(IMAGE_KEY);
        StringBuilder stringBuilder = new StringBuilder(200).append("<img ").append(string).append(" />");
        return stringBuilder.toString();
    }

    public static String form(Attributes attributes) {
        String string = attributes.getAttribute(FORM_KEY);
        String string2 = attributes.get("body");
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder = new StringBuilder(200).append("<form ").append(string).append('>').append(HybsConst.CR).append(string2).append(HybsConst.CR).append("</form>");
        return stringBuilder.toString();
    }

    public static String span(Attributes attributes) {
        String string = attributes.getAttribute(SPAN_KEY);
        String string2 = attributes.get("optionAttributes");
        String string3 = attributes.get("body");
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder = new StringBuilder(200).append("<span ").append(string);
        if (string2 != null) {
            stringBuilder.append(' ').append(string2);
        }
        stringBuilder.append('>').append(string3).append("</span>");
        return stringBuilder.toString();
    }

    public static String pre(Attributes attributes) {
        String string = attributes.getAttribute(PRE_KEY);
        String string2 = attributes.get("optionAttributes");
        String string3 = attributes.get("body");
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder = new StringBuilder(200).append("<pre ").append(string);
        if (string2 != null) {
            stringBuilder.append(' ').append(string2);
        }
        stringBuilder.append('>').append(string3).append("</pre>");
        return stringBuilder.toString();
    }

    public static String addURLCheckKey(String string, String string2, String string3, long l) {
        String string4 = string2 + "=" + HYBS_CRYPTOGRAPHY.encrypt(string.replace("../", "") + ",time=" + l + ",userid=" + string3);
        return XHTMLTag.addUrlEncode(string, string4);
    }

    public static String embedURLCheckKey(String string, String string2, String string3, long l) {
        int n;
        String string4 = string;
        int n2 = string4.indexOf("href=\"");
        if (n2 >= 0 && (n = string4.indexOf(34, n2 + 6)) >= 0) {
            String string5 = string4.substring(n2 + 6, n);
            string5 = XHTMLTag.addURLCheckKey(string5, string2, string3, l);
            string4 = string4.substring(0, n2) + "href=\"" + string5 + string4.substring(n);
        }
        return string4;
    }
}

