<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<og:value command="SET" key="fileUD_filename" value="{@GUI.LABEL}_{@TABLE_NAME}.xls" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX013"
	title	= "DB登録"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>
<!-- localResource を使用する。 -->
<og:equals val1="{@resource}" val2="localResource">
	<og:localResource systemId="{@SYSTEM_ID}" />
</og:equals>

<og:value command="SET" key="C_KEYS" value="{@SEL_CLMS}" action="APPEND" caseNull="{@C_KEYS}" />

<og:equals val1="{@GRP_BY}" val2="1">
	<og:value command="SET" key="GROUP_BY" value="{@C_KEYS}" />
	<og:value command="SET" key="ORDER_BY" value="{@C_KEYS}" />
	<og:value command="SET" key="C_KEYS"   value="{@C_KEYS},count(*)" />
</og:equals>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" dbid="{@FROM_DBID}" debug="{@debug}" maxRowCount="{@maxRowCount}" quotCheck="false">
		select {@C_KEYS}
		from {@TABLE_NAME}
	<og:where>
		<og:and value = "{@CLM__0} {@CONDITION__0} '{@VAL__0}'"	 xssCheck="false" quotCheck="false"	/>
		<og:and value = "{@CLM__1} {@CONDITION__1} '{@VAL__1}'"	 xssCheck="false" quotCheck="false"	/>
		<og:and value = "{@CLM__2} {@CONDITION__2} '{@VAL__2}'"	 xssCheck="false" quotCheck="false"	/>
		<og:and value = "{@CLM__3} {@CONDITION__3} '{@VAL__3}'"	 xssCheck="false" quotCheck="false"	/>
		<og:and value = "{@CLM__4} {@CONDITION__4} '{@VAL__4}'"	 xssCheck="false" quotCheck="false"	/>
		<og:and value = "{@CLM__5} {@CONDITION__5} '{@VAL__5}'"	 xssCheck="false" quotCheck="false"	/>
		<og:and value = "{@CLM__6} {@CONDITION__6} '{@VAL__6}'"	 xssCheck="false" quotCheck="false"	/>
		<og:and value = "{@CLM__7} {@CONDITION__7} '{@VAL__7}'"	 xssCheck="false" quotCheck="false"	/>
		<og:and value = "{@CLM__8} {@CONDITION__8} '{@VAL__8}'"	 xssCheck="false" quotCheck="false"	/>
		<og:and value = "{@CLM__9} {@CONDITION__9} '{@VAL__9}'"	 xssCheck="false" quotCheck="false"	/>
		<og:and value = "{@CLM}    {@CONDITION}    '{@VAL}'"	 xssCheck="false" quotCheck="false"	/>
		<og:and value = "{@AND}"								 xssCheck="false" quotCheck="false"	/>
	</og:where>
	<og:appear startKey=" group by"	value = "{@GROUP_BY}"	/>
	<og:appear startKey=" having"	value = "{@HAVING}"	  xssCheck="false"	/>
	<og:appear startKey=" order by"	value = "{@ORDER_BY}"	/>
</og:query>

<!-- localResource を使用する。 -->
<og:equals val1="{@resource}" val2="localResource">
	<!-- ローカルリソースを使用する場合、DBMENU を 指定の dbid から求めます。 -->
	<og:columnEditor columns="*" dbid="{@FROM_DBID}" />
</og:equals>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
	<og:value command="SET" key="writable" value="false" />	<!-- view の書込み禁止判定 -->
	<og:writeCheck caseNN="{@UNIQ_KEYS}" caseNull="{@GRP_BY}">
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="null"  />
		<og:submit  action="MODIFY"  noWritable="{@UNIQ_KEYS}" />
		<og:submit  action="DELETE" lbl="DELETE_PH" columnWritable="null" />
		<br />
		<og:value command="SET" key="writable" value="true" /><!-- view の書込み禁止判定 -->
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<og:view
		viewFormType = "HTMLTable" 
		command    = "{@command}" 
		checked    = "{@checked}"
		startNo    = "{@startNo}" 
		pageSize   = "{@pageSize}"
		writable   = "{@writable}"
	/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
