/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;

/**
 * 文字列の 「キー:ラベル キー:ラベル」の情報から、プルダウンメニューを作成して
 * 編集する場合に使用するエディタークラスです。
 *
 * HTMLのメニューやリストを作成するためのオプションタグを作成したり、
 * 与えられたキーをもとに、チェック済みのオプションタグを作成したりします。
 * ラベル にスペースを含ませる場合は、ダブルクォーテーションで囲ってください。
 *
 * カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.rev 6.0.4.0 (2014/11/28) 新規作成
 * @og.group データ編集
 *
 * @version  6.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK7.0,
 */
public class Editor_KVMENU extends Editor_MENU {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.0.4.0 (2014/11/28)" ;

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 */

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @og.rev 6.0.4.0 (2014/11/28) サブクラスで タイプを指定するための対応
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 * @og.rtnNotNull
	 */
	@Override
	public CellEditor newInstance( final DBColumn clm ) {
		return new Editor_MENU( clm,"KEYVAL" );
	}
}
