/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatchHelper;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.view.PrintJobEvent;
import com.sun.star.view.PrintableState;
import com.sun.star.view.XPrintJobBroadcaster;
import com.sun.star.view.XPrintJobListener;
import com.sun.star.view.XPrintable;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.report2.ProcessFactory;
import org.opengion.hayabusa.report2.SOfficeProcess;

public class DocConverter_OOO {
    private final boolean isOnline;
    private final String[] mergeFile;
    private String inputName;
    private String origName;
    private XComponent xComp;
    private SOfficeProcess soffice;
    private static final Map<String, String> filterMap = new HashMap<String, String>();

    public DocConverter_OOO(String string) {
        this(StringUtil.csv2Array((String)string), true);
    }

    public DocConverter_OOO(String[] stringArray) {
        this(stringArray, true);
    }

    public DocConverter_OOO(String[] stringArray, boolean bl) {
        if (stringArray == null || stringArray.length == 0 || stringArray[0].isEmpty()) {
            throw new HybsSystemException("\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        File file = new File(stringArray[0]);
        if (!file.exists()) {
            throw new HybsSystemException("\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002[file=" + stringArray[0] + "]");
        }
        this.isOnline = bl;
        this.inputName = stringArray[0];
        this.origName = stringArray[0];
        if (stringArray.length == 1) {
            this.mergeFile = null;
        } else {
            if (!"xls".equals(DocConverter_OOO.getSuffix(stringArray[0])) && !"ods".equals(DocConverter_OOO.getSuffix(stringArray[0]))) {
                throw new HybsSystemException("\u30d5\u30a1\u30a4\u30eb\u306e\u30de\u30fc\u30b8\u3092\u884c\u3046\u5834\u5408\u3001\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306f\u3001Excel\u307e\u305f\u306fCacl\u5f62\u5f0f\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
            }
            this.mergeFile = new String[stringArray.length - 1];
            for (int i = 0; i < this.mergeFile.length; ++i) {
                if (stringArray[i + 1].isEmpty() || !new File(stringArray[i + 1]).exists()) {
                    throw new HybsSystemException("\u30de\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u304b\u3001\u307e\u305f\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002[file=" + stringArray[i + 1] + "]");
                }
                if (this.inputName.equals(stringArray[i] + 1)) {
                    throw new HybsSystemException("\u30de\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306b\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u3068\u540c\u3058\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u307e\u3059\u3002[file=" + stringArray[i + 1] + "]");
                }
                if (!"xls".equals(DocConverter_OOO.getSuffix(stringArray[i + 1])) && !"ods".equals(DocConverter_OOO.getSuffix(stringArray[i + 1]))) {
                    throw new HybsSystemException("\u30d5\u30a1\u30a4\u30eb\u306e\u30de\u30fc\u30b8\u3092\u884c\u3046\u5834\u5408\u3001\u30de\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306f\u3001Excel\u307e\u305f\u306fCacl\u5f62\u5f0f\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
                }
                this.mergeFile[i] = stringArray[i + 1];
            }
        }
    }

    public void open() throws Throwable {
        if (this.soffice == null) {
            if (this.isOnline) {
                this.soffice = ProcessFactory.newInstance();
            } else {
                this.soffice = new SOfficeProcess("docconverter.class");
                this.soffice.bootstrap();
            }
            if (this.mergeFile != null) {
                File file = new File(this.origName);
                this.inputName = this.soffice.getTempPath() + System.currentTimeMillis() + "_" + file.getName();
                FileUtil.copy((File)file, (File)new File(this.inputName));
            }
        }
        this.xComp = this.getComponent(this.inputName, this.mergeFile == null, false);
        if (this.mergeFile != null) {
            for (int i = 0; i < this.mergeFile.length; ++i) {
                this.merge(this.mergeFile[i]);
            }
        }
    }

    private XComponent getComponent(String string, boolean bl, boolean bl2) {
        XComponent xComponent;
        PropertyValue[] propertyValueArray = new PropertyValue[2];
        propertyValueArray[0] = new PropertyValue();
        propertyValueArray[0].Name = "Hidden";
        propertyValueArray[0].Value = bl;
        propertyValueArray[1] = new PropertyValue();
        propertyValueArray[1].Name = "AsTemplate";
        propertyValueArray[1].Value = bl2;
        String string2 = "file:///" + string.replace('\\', '/');
        XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)this.soffice.getDesktop());
        try {
            xComponent = xComponentLoader.loadComponentFromURL(string2, "_blank", 0, propertyValueArray);
        }
        catch (IOException iOException) {
            throw new HybsSystemException("OpenOffice\u306e\u7acb\u3061\u4e0a\u3052\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f(\u5165\u51fa\u529b\u30a8\u30e9\u30fc)\u3002", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HybsSystemException("OpenOffice\u306e\u7acb\u3061\u4e0a\u3052\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f(\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u4e0d\u6b63)\u3002", illegalArgumentException);
        }
        return xComponent;
    }

    private void merge(String string) {
        XComponent xComponent = this.getComponent(string, false, true);
        XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)((XController)UnoRuntime.queryInterface(XController.class, (Object)((XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent)).getCurrentController())).getFrame());
        XDispatchHelper xDispatchHelper = this.soffice.getDispatcher();
        xDispatchHelper.executeDispatch(xDispatchProvider, ".uno:TableSelectAll", "", 0, new PropertyValue[0]);
        String string2 = new File(this.inputName).getName();
        string2 = string2.substring(0, string2.indexOf(46));
        PropertyValue[] propertyValueArray = new PropertyValue[3];
        propertyValueArray[0] = new PropertyValue();
        propertyValueArray[0].Name = "DocName";
        propertyValueArray[0].Value = string2;
        propertyValueArray[1] = new PropertyValue();
        propertyValueArray[1].Name = "Index";
        propertyValueArray[1].Value = Short.MAX_VALUE;
        propertyValueArray[2] = new PropertyValue();
        propertyValueArray[2].Name = "Copy";
        propertyValueArray[2].Value = true;
        xDispatchHelper.executeDispatch(xDispatchProvider, ".uno:Move", "", 0, propertyValueArray);
        this.closeComponent(xComponent);
    }

    public void close() throws Throwable {
        this.close(false);
    }

    public void close(boolean bl) {
        if (this.xComp != null) {
            this.closeComponent(this.xComp);
        }
        if (this.soffice != null) {
            if (this.isOnline) {
                if (bl) {
                    ProcessFactory.remove(this.soffice);
                } else {
                    ProcessFactory.release(this.soffice);
                }
            } else {
                this.soffice.close();
            }
        }
        if (this.mergeFile != null && !new File(this.inputName).delete()) {
            System.err.println("\u30c6\u30f3\u30dd\u30e9\u30ea\u306b\u30b3\u30d4\u30fc\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + this.inputName + "]");
        }
    }

    private void closeComponent(XComponent xComponent) {
        XCloseable xCloseable = null;
        int n = 0;
        while (true) {
            try {
                xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xComponent);
                xCloseable.close(true);
            }
            catch (CloseVetoException closeVetoException) {
                if (n == 600) {
                    throw new HybsSystemException("soffice\u30d7\u30ed\u30bb\u30b9\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3002", closeVetoException);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n;
                continue;
            }
            break;
        }
    }

    public void print(String string) throws Throwable {
        if (this.xComp == null) {
            throw new HybsSystemException("\u521d\u3081\u306b\u3001#open()\u3092\u5b9f\u884c\u3057\u3066\u4e0b\u3055\u3044");
        }
        if (string == null || string.isEmpty()) {
            throw new HybsSystemException("\u30d7\u30ea\u30f3\u30bf\u30fc\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        XPrintable xPrintable = (XPrintable)UnoRuntime.queryInterface(XPrintable.class, (Object)this.xComp);
        XPrintJobBroadcaster xPrintJobBroadcaster = (XPrintJobBroadcaster)UnoRuntime.queryInterface(XPrintJobBroadcaster.class, (Object)xPrintable);
        MyPrintJobListener myPrintJobListener = new MyPrintJobListener();
        xPrintJobBroadcaster.addPrintJobListener((XPrintJobListener)myPrintJobListener);
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
        propertyValueArray[0].Name = "Name";
        propertyValueArray[0].Value = "LINUX".indexOf(HybsSystem.sys("OS_INFO").toUpperCase(Locale.JAPAN)) >= 0 ? "<" + string + ">" : string;
        try {
            xPrintable.setPrinter(propertyValueArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HybsSystemException("\u5370\u5237\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", illegalArgumentException);
        }
        String string2 = null;
        PropertyValue[] propertyValueArray2 = xPrintable.getPrinter();
        for (int i = 0; i < propertyValueArray2.length; ++i) {
            if (!"Name".equals(propertyValueArray2[i].Name)) continue;
            string2 = (String)propertyValueArray2[i].Value;
            break;
        }
        if (!string.equalsIgnoreCase(string2)) {
            String string3 = "\u30d7\u30ea\u30f3\u30bf\u30fc[" + string + "]\u3092\u767a\u884c\u5148\u306b\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsConst.CR + "\u5b58\u5728\u3057\u306a\u3044\u30d7\u30ea\u30f3\u30bf\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002";
            throw new HybsSystemException(string3);
        }
        PropertyValue[] propertyValueArray3 = new PropertyValue[]{new PropertyValue()};
        propertyValueArray3[0].Name = "Wait";
        propertyValueArray3[0].Value = true;
        try {
            xPrintable.print(propertyValueArray3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HybsSystemException("\u5370\u5237\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", illegalArgumentException);
        }
        if (myPrintJobListener.getStatus() == null || myPrintJobListener.getStatus() != PrintableState.JOB_COMPLETED && myPrintJobListener.getStatus() != PrintableState.JOB_SPOOLED) {
            throw new HybsSystemException("Error Occured while spooling print job. Check Spooler-Service!!!");
        }
    }

    public void pdf(String string, String string2) throws Throwable {
        this.savePdf(string, DocConverter_OOO.getFilterName(DocConverter_OOO.getSuffix(this.inputName), "pdf"), string2);
    }

    public void ods(String string) throws Throwable {
        this.saveDoc(string, DocConverter_OOO.getFilterName(DocConverter_OOO.getSuffix(this.inputName), "ods"));
    }

    public void xls(String string) throws Throwable {
        this.saveDoc(string, DocConverter_OOO.getFilterName(DocConverter_OOO.getSuffix(this.inputName), "xls"));
    }

    public void odt(String string) throws Throwable {
        this.saveDoc(string, DocConverter_OOO.getFilterName(DocConverter_OOO.getSuffix(this.inputName), "odt"));
    }

    public void doc(String string) throws Throwable {
        this.saveDoc(string, DocConverter_OOO.getFilterName(DocConverter_OOO.getSuffix(this.inputName), "doc"));
    }

    public void odp(String string) throws Throwable {
        this.saveDoc(string, DocConverter_OOO.getFilterName(DocConverter_OOO.getSuffix(this.inputName), "odp"));
    }

    public void ppt(String string) throws Throwable {
        this.saveDoc(string, DocConverter_OOO.getFilterName(DocConverter_OOO.getSuffix(this.inputName), "ppt"));
    }

    public void auto(String string) throws Throwable {
        String string2 = DocConverter_OOO.getSuffix(string);
        if ("pdf".equalsIgnoreCase(string2)) {
            this.savePdf(string, DocConverter_OOO.getFilterName(DocConverter_OOO.getSuffix(this.inputName), string2), null);
        } else {
            this.saveDoc(string, DocConverter_OOO.getFilterName(DocConverter_OOO.getSuffix(this.inputName), string2));
        }
    }

    private void saveDoc(String string, String string2) {
        if (this.xComp == null) {
            throw new HybsSystemException("\u521d\u3081\u306b\u3001#open()\u3092\u5b9f\u884c\u3057\u3066\u4e0b\u3055\u3044");
        }
        if (!this.checkOutput(string)) {
            return;
        }
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
        propertyValueArray[0].Name = "FilterName";
        propertyValueArray[0].Value = string2;
        String string3 = "file:///" + string.replace('\\', '/');
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.xComp);
        try {
            xStorable.storeAsURL(string3, propertyValueArray);
        }
        catch (Throwable throwable) {
            throw new HybsSystemException("\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u5909\u63db\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[filter=" + string2 + "]", throwable);
        }
    }

    private void savePdf(String string, String string2, String string3) {
        Object object;
        PropertyValue[] propertyValueArray;
        if (this.xComp == null) {
            throw new HybsSystemException("\u521d\u3081\u306b\u3001#open()\u3092\u5b9f\u884c\u3057\u3066\u4e0b\u3055\u3044");
        }
        if (!this.checkOutput(string)) {
            return;
        }
        if (string3 == null || string3.isEmpty()) {
            propertyValueArray = new PropertyValue[]{new PropertyValue()};
            propertyValueArray[0].Name = "FilterName";
            propertyValueArray[0].Value = string2;
        } else {
            object = new PropertyValue[2];
            object[0] = new PropertyValue();
            object[0].Name = "EncryptFile";
            object[0].Value = true;
            object[1] = new PropertyValue();
            object[1].Name = "DocumentOpenPassword";
            object[1].Value = string3;
            propertyValueArray = new PropertyValue[2];
            propertyValueArray[0] = new PropertyValue();
            propertyValueArray[0].Name = "FilterName";
            propertyValueArray[0].Value = "calc_pdf_Export";
            propertyValueArray[1] = new PropertyValue();
            propertyValueArray[1].Name = "FilterData";
            propertyValueArray[1].Value = object;
        }
        object = "file:///" + string.replace('\\', '/');
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.xComp);
        try {
            xStorable.storeToURL((String)object, propertyValueArray);
        }
        catch (Throwable throwable) {
            throw new HybsSystemException("PDF\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u5909\u63db\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[filter=" + string2 + "]", throwable);
        }
    }

    private boolean checkOutput(String string) {
        if (string == null || string.isEmpty()) {
            throw new HybsSystemException("\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        File file = new File(this.inputName);
        File file2 = new File(string);
        if (file2.exists()) {
            if (file.getAbsoluteFile().equals(file2.getAbsoluteFile())) {
                return false;
            }
            if (!file2.delete()) {
                throw new HybsSystemException("\u51fa\u529b\u5148\u306e\u65e2\u5b58\u30d5\u30a1\u30a4\u30eb\u304c\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002[file=" + string + "]");
            }
        }
        return true;
    }

    private static String getFilterName(String string, String string2) {
        String string3 = filterMap.get(string + "_" + string2);
        if (string3 == null) {
            String string4 = "\u5165\u529b\u5f62\u5f0f\u3001\u51fa\u529b\u5f62\u5f0f\u306f\u3001\u4ee5\u4e0b\u306e\u5bfe\u5fdc\u8868\u306b\u57fa\u3065\u304d\u3001\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002" + HybsConst.CR + "\u5165\u529b[Calc(ods)   ,Excel(xls)     ] \u21d2 \u51fa\u529b[Calc(ods)   ,Excel(xls)     ,PDF]" + HybsConst.CR + "\u5165\u529b[Writer(odt) ,Word(doc)      ] \u21d2 \u51fa\u529b[Writer(odt) ,Word(doc)      ,PDF]" + HybsConst.CR + "\u5165\u529b[Impress(odp),PowerPoint(ppt)] \u21d2 \u51fa\u529b[Impress(odp),PowerPoint(ppt),PDF]" + HybsConst.CR;
            throw new HybsSystemException(string4);
        }
        return string3;
    }

    private static String getSuffix(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = string.lastIndexOf(46)) >= 0) {
            string2 = string.substring(n + 1).toLowerCase(Locale.JAPAN);
        }
        return string2;
    }

    public static final void convert(String string, String string2) {
        DocConverter_OOO.convert(StringUtil.csv2Array((String)string), string2);
    }

    public static final void convert(String[] stringArray, String string) {
        DocConverter_OOO.convert(stringArray, string, true);
    }

    public static final void convert(String[] stringArray, String string, boolean bl) {
        DocConverter_OOO docConverter_OOO = new DocConverter_OOO(stringArray, bl);
        try {
            docConverter_OOO.open();
            docConverter_OOO.auto(string);
            docConverter_OOO.close();
        }
        catch (Throwable throwable) {
            docConverter_OOO.close(true);
            throw new HybsSystemException(throwable);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("usage : OdsConverter [inputFile or inputDir] [outputDir]");
            return;
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        if (file2.mkdirs()) {
            System.err.println(stringArray[1] + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getAbsolutePath();
                String string2 = file2.getAbsolutePath() + File.separator + fileArray[i].getName().replace(".xls", ".ods");
                DocConverter_OOO.convert(StringUtil.csv2Array((String)string), string2, false);
            }
        } else {
            String string = file.getAbsolutePath();
            String string3 = file2.getAbsolutePath() + File.separator + file.getName().replace(".xls", ".ods");
            DocConverter_OOO.convert(StringUtil.csv2Array((String)string), string3, false);
        }
    }

    static {
        filterMap.put("ods_ods", "calc8");
        filterMap.put("xls_ods", "calc8");
        filterMap.put("ods_xls", "MS Excel 97");
        filterMap.put("xls_xls", "MS Excel 97");
        filterMap.put("ods_pdf", "calc_pdf_Export");
        filterMap.put("xls_pdf", "calc_pdf_Export");
        filterMap.put("odt_odt", "writer8");
        filterMap.put("doc_odt", "writer8");
        filterMap.put("odt_doc", "MS Word 97");
        filterMap.put("doc_doc", "MS Word 97");
        filterMap.put("odt_pdf", "writer_pdf_Export");
        filterMap.put("doc_pdf", "writer_pdf_Export");
        filterMap.put("odp_odp", "impress8");
        filterMap.put("ppt_odp", "impress8");
        filterMap.put("odp_ppt", "MS PowerPoint 97");
        filterMap.put("ppt_ppt", "MS PowerPoint 97");
        filterMap.put("odp_pdf", "impress_pdf_Export");
        filterMap.put("ppt_pdf", "impress_pdf_Export");
    }

    private static class MyPrintJobListener
    implements XPrintJobListener {
        private PrintableState status;

        private MyPrintJobListener() {
        }

        public void printJobEvent(PrintJobEvent printJobEvent) {
            this.status = printJobEvent.State;
        }

        public void disposing(EventObject eventObject) {
        }

        public PrintableState getStatus() {
            return this.status;
        }
    }
}

