/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBConstValue;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TableUpdateTag;

public class TableUpdateParamTag
extends CommonTagSupport {
    private static final String VERSION = "6.2.3.0 (2015/05/01)";
    private static final long serialVersionUID = 623020150501L;
    public static final String SQL_TYPE = "|INSERT|COPY|UPDATE|MODIFY|DELETE|";
    private static final String SYSTEM_ID = HybsSystem.sys("SYSTEM_ID");
    private static final String DEFAULT_CONST_OBJ = HybsSystem.sys("DEFAULT_CONST_CLASS");
    private String sqlType;
    private String table;
    private String[] names;
    private String omitNames = ",ROWID,ROWNUM,WRITABLE,";
    private String where;
    private String whereNames;
    private String[] constKeys;
    private String[] constVals;
    private String[] funcKeys;
    private String[] funcVals;
    private String[] asNames;
    private String[] orgNames;
    private String constObjKey = SYSTEM_ID;
    private boolean quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
    private boolean logicalDelete;

    @Override
    public int doStartTag() {
        if (this.constKeys != null && (this.constVals == null || this.constKeys.length != this.constVals.length)) {
            String string = "<b>constKeys \u3068\u3001constVals \u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002</b><br /> constKeys=[" + StringUtil.array2csv((String[])this.constKeys) + "]" + " constVals=[" + StringUtil.array2csv((String[])this.constVals) + "]";
            throw new HybsSystemException(string);
        }
        if (this.funcKeys != null && (this.funcVals == null || this.funcKeys.length != this.funcVals.length)) {
            String string = "<b>funcKeys \u3068\u3001funcVals \u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002</b><br /> funcKeys=[" + StringUtil.array2csv((String[])this.funcKeys) + "]" + " funcVals=[" + StringUtil.array2csv((String[])this.funcVals) + "]";
            throw new HybsSystemException(string);
        }
        if (this.orgNames != null && (this.asNames == null || this.orgNames.length != this.asNames.length)) {
            String string = "<b>orgNames \u3068\u3001asNames \u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002</b><br /> orgNames=[" + StringUtil.array2csv((String[])this.orgNames) + "]" + " asNames=[" + StringUtil.array2csv((String[])this.asNames) + "]";
            throw new HybsSystemException(string);
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        TableUpdateTag tableUpdateTag = (TableUpdateTag)TableUpdateParamTag.findAncestorWithClass((Tag)this, TableUpdateTag.class);
        if (tableUpdateTag == null) {
            String string = "<b>" + this.getTagName() + "\u30bf\u30b0\u306f\u3001TableUpdateTag\u306e\u5185\u5074(\u8981\u7d20)\u306b\u8a18\u8ff0\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
            throw new HybsSystemException(string);
        }
        String string = tableUpdateTag.getSqlType();
        if (string == null || string.equals(this.sqlType)) {
            if (this.names == null) {
                this.names = tableUpdateTag.getNames();
            }
            NamesData namesData = this.makeNamesData(this.names);
            String string2 = null;
            if ("INSERT".equalsIgnoreCase(this.sqlType) || "COPY".equalsIgnoreCase(this.sqlType)) {
                string2 = this.getInsertSQL(namesData);
            } else if ("UPDATE".equalsIgnoreCase(this.sqlType) || "MODIFY".equalsIgnoreCase(this.sqlType) || "DELETE".equalsIgnoreCase(this.sqlType) && this.logicalDelete) {
                string2 = this.getUpdateSQL(namesData);
            } else if ("DELETE".equalsIgnoreCase(this.sqlType)) {
                string2 = this.getDeleteSQL();
            }
            this.jspPrint(string2);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.sqlType = null;
        this.table = null;
        this.names = null;
        this.omitNames = ",ROWID,ROWNUM,WRITABLE,";
        this.where = null;
        this.whereNames = null;
        this.constKeys = null;
        this.constVals = null;
        this.quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
        this.constObjKey = SYSTEM_ID;
        this.logicalDelete = false;
        this.funcKeys = null;
        this.funcVals = null;
        this.asNames = null;
        this.orgNames = null;
    }

    public void setSqlType(String string) {
        this.sqlType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sqlType);
        if (this.sqlType != null && SQL_TYPE.indexOf("|" + this.sqlType + "|") < 0) {
            this.sqlType = null;
        }
    }

    public void setTable(String string) {
        this.table = StringUtil.nval((String)this.getRequestParameter(string), (String)this.table);
    }

    public void setNames(String string) {
        this.names = StringUtil.csv2Array((String)this.getRequestParameter(string));
        if (this.names.length == 0) {
            this.names = null;
        }
    }

    public void setOmitNames(String string) {
        this.omitNames = this.omitNames + StringUtil.nval((String)this.getRequestParameter(string), (String)"") + ",";
    }

    public void setWhere(String string) {
        this.where = StringUtil.nval((String)this.getRequestParameter(string), (String)this.where);
    }

    public void setWhereNames(String string) {
        this.whereNames = StringUtil.nval((String)this.getRequestParameter(string), (String)this.whereNames);
    }

    public void setConstKeys(String string) {
        this.constKeys = this.getCSVParameter(string);
    }

    public void setConstVals(String string) {
        this.constVals = this.getCSVParameter(string);
    }

    public void setFuncKeys(String string) {
        this.funcKeys = this.getCSVParameter(string);
    }

    public void setFuncVals(String string) {
        this.funcVals = this.getCSVParameter(string);
    }

    public void setAsNames(String string) {
        this.asNames = this.getCSVParameter(string);
    }

    public void setOrgNames(String string) {
        this.orgNames = this.getCSVParameter(string);
    }

    public void setQuotCheck(String string) {
        this.quotCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.quotCheck);
    }

    public void setConstObjKey(String string) {
        this.constObjKey = StringUtil.nval((String)this.getRequestParameter(string), (String)this.constObjKey);
    }

    public void setLogicalDelete(String string) {
        this.logicalDelete = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.logicalDelete);
    }

    private String getInsertSQL(NamesData namesData) {
        String[] stringArray;
        CharSequence[] charSequenceArray;
        Object object;
        String string = HybsSystem.sys("DBConstValue_" + this.constObjKey);
        if (string == null) {
            string = DEFAULT_CONST_OBJ;
        }
        if (string != null && !string.isEmpty()) {
            object = (DBConstValue)HybsSystem.newInstance(string);
            object.init(this.table, this.getUser().getUserID(), this.getGUIInfoAttri("KEY"));
            charSequenceArray = object.getInsertKeys();
            stringArray = object.getInsertVals();
            namesData.add((String[])charSequenceArray, stringArray);
        }
        object = namesData.getNames();
        charSequenceArray = namesData.getVals();
        stringArray = new StringBuilder(200).append("INSERT INTO ").append(this.table).append(" ( ").append(String.join((CharSequence)",", (CharSequence[])object));
        stringArray.append(" ) VALUES ( ").append(String.join((CharSequence)",", charSequenceArray));
        stringArray.append(" )");
        return stringArray.toString();
    }

    private String getUpdateSQL(NamesData namesData) {
        String[] stringArray;
        String[] stringArray2;
        Object object;
        String string = HybsSystem.sys("DBConstValue_" + this.constObjKey);
        if (string == null) {
            string = DEFAULT_CONST_OBJ;
        }
        if (string != null && !string.isEmpty()) {
            object = (DBConstValue)HybsSystem.newInstance(string);
            object.init(this.table, this.getUser().getUserID(), this.getGUIInfoAttri("KEY"));
            stringArray2 = null;
            stringArray = null;
            if ("DELETE".equalsIgnoreCase(this.sqlType)) {
                stringArray2 = object.getLogicalDeleteKeys();
                stringArray = object.getLogicalDeleteVals();
            } else {
                stringArray2 = object.getUpdateKeys();
                stringArray = object.getUpdateVals();
            }
            namesData.add(stringArray2, stringArray);
        }
        object = namesData.getNames();
        stringArray2 = namesData.getVals();
        stringArray = new StringBuilder(200).append("UPDATE ").append(this.table).append(" SET ").append((String)object[0]).append('=').append(stringArray2[0]);
        for (int i = 1; i < ((Object)object).length; ++i) {
            stringArray.append(',').append((String)object[i]).append('=').append(stringArray2[i]);
        }
        String string2 = " WHERE ";
        if (this.whereNames != null && this.whereNames.length() > 0) {
            String[] stringArray3 = this.whereNames.split(",");
            stringArray.append(string2).append(stringArray3[0]).append("=[").append(stringArray3[0]).append(']');
            for (int i = 1; i < stringArray3.length; ++i) {
                stringArray.append(" AND ").append(stringArray3[i]).append("=[").append(stringArray3[i]).append(']');
            }
            string2 = " AND ";
        }
        if (this.where != null && this.where.length() > 0) {
            stringArray.append(string2).append(this.where);
        }
        return stringArray.toString();
    }

    private String getDeleteSQL() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("DELETE FROM ").append(this.table);
        String string = " WHERE ";
        if (this.whereNames != null && this.whereNames.length() > 0) {
            String[] stringArray = this.whereNames.split(",");
            stringBuilder.append(string).append(stringArray[0]).append("=[").append(stringArray[0]).append(']');
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(" AND ").append(stringArray[i]).append("=[").append(stringArray[i]).append(']');
            }
            string = " AND ";
        }
        if (this.where != null && this.where.length() > 0) {
            stringBuilder.append(string).append(this.where);
        }
        return stringBuilder.toString();
    }

    private NamesData makeNamesData(String ... stringArray) {
        String string;
        int n;
        NamesData namesData = new NamesData();
        if (this.asNames != null) {
            for (n = 0; n < this.asNames.length; ++n) {
                if (this.asNames[n] == null || this.asNames[n].length() <= 0) continue;
                this.omitNames = this.omitNames + this.asNames[n] + ",";
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if (string == null || string.length() <= 0 || this.omitNames.indexOf("," + string + ",") >= 0) continue;
            namesData.add(string, "[" + string + "]");
        }
        if (this.constKeys != null && this.constKeys.length > 0) {
            for (n = 0; n < this.constKeys.length; ++n) {
                string = this.constKeys[n];
                if (string == null || string.length() <= 0) continue;
                namesData.add(string, "'" + this.constVals[n] + "'");
            }
        }
        if (this.funcKeys != null && this.funcKeys.length > 0) {
            for (n = 0; n < this.funcKeys.length; ++n) {
                string = this.funcKeys[n];
                if (string == null || string.length() <= 0) continue;
                namesData.add(string, this.funcVals[n]);
            }
        }
        if (this.orgNames != null && this.orgNames.length > 0) {
            for (n = 0; n < this.orgNames.length; ++n) {
                string = this.orgNames[n];
                if (string == null || string.length() <= 0) continue;
                namesData.add(string, "[" + this.asNames[n] + "]");
            }
        }
        return namesData;
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("sqlType", (Object)this.sqlType).println("table", (Object)this.table).println("names", (Object[])this.names).println("omitNames", (Object)this.omitNames).println("where", (Object)this.where).println("whereNames", (Object)this.whereNames).println("constKeys", (Object[])this.constKeys).println("constVals", (Object[])this.constVals).println("logicalDelete", (Object)this.logicalDelete).fixForm().toString();
    }

    private static class NamesData {
        final Map<String, String> data = new LinkedHashMap<String, String>();

        private NamesData() {
        }

        public void add(String string, String string2) {
            this.data.put(string, string2);
        }

        public void add(String[] stringArray, String[] stringArray2) {
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.data.put(stringArray[i], stringArray2[i]);
                }
            }
        }

        public String[] getNames() {
            return this.data.keySet().toArray(new String[this.data.size()]);
        }

        public String[] getVals() {
            return this.data.values().toArray(new String[this.data.size()]);
        }
    }
}

