/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.filter;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

public final class URLCheckFilter
implements Filter {
    private static final HybsCryptography HYBS_CRYPTOGRAPHY = new HybsCryptography(HybsSystem.sys("URL_CHECK_CRYPT"));
    private String filename;
    private boolean isDebug;
    private boolean isDecode = true;
    private String ignoreURL;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.isValidAccess(servletRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            String string;
            servletResponse.setContentType("text/html; charset=UTF-8");
            PrintWriter printWriter = servletResponse.getWriter();
            bufferedReader = FileUtil.getBufferedReader((File)new File(this.filename), (String)"UTF-8");
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.println(string);
            }
            printWriter.flush();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                throw new RuntimeException("\u6307\u5b9a\u3055\u308c\u305f\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002[UTF-8]", unsupportedEncodingException);
                catch (CharacterCodingException characterCodingException) {
                    String string = "\u6587\u5b57\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u30fb\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "  \u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u6307\u5b9a\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u3068\u7570\u306a\u308a\u307e\u3059\u3002" + HybsConst.CR + " [" + this.filename + "] , Encode=[UTF-8]";
                    throw new RuntimeException(string, characterCodingException);
                }
                catch (IOException iOException) {
                    String string = "\u30b9\u30c8\u30ea\u30fc\u30e0\u304c\u30aa\u30fc\u30d7\u30f3\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + this.filename + "]";
                    throw new RuntimeException(string, iOException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedReader);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)bufferedReader);
    }

    public void init(FilterConfig filterConfig) {
        this.filename = HybsSystem.getRealPath() + filterConfig.getInitParameter("filename");
        this.isDebug = StringUtil.nval((String)filterConfig.getInitParameter("debug"), (boolean)false);
        this.isDecode = StringUtil.nval((String)filterConfig.getInitParameter("decode"), (boolean)true);
        this.ignoreURL = filterConfig.getInitParameter("ignoreURL");
    }

    public void destroy() {
    }

    private boolean isValidAccess(ServletRequest servletRequest) {
        boolean bl;
        block13: {
            String string = servletRequest.getParameter("h_urlCheck");
            if (string == null || string.isEmpty()) {
                if (this.isDebug) {
                    System.out.println("  check NG [ No Check Key ]");
                }
                return false;
            }
            bl = false;
            try {
                string = HYBS_CRYPTOGRAPHY.decrypt(string).replace("&amp;", "&");
                if (this.isDebug) {
                    System.out.println("checkKey=" + string);
                }
                int n = string.lastIndexOf(",time=");
                int n2 = string.lastIndexOf(",userid=");
                String string2 = string.substring(0, n);
                long l = Long.parseLong(string.substring(n + 6, n2));
                String string3 = string.substring(n2 + 8);
                String[] stringArray = StringUtil.csv2Array((String)string3);
                if (this.ignoreURL != null && this.ignoreURL.length() > 0 && string2.indexOf(this.ignoreURL) == 0) {
                    string2 = string2.substring(this.ignoreURL.length());
                }
                if (this.isDebug) {
                    System.out.println(" [ignoreURL]=" + this.ignoreURL);
                    System.out.println(" [url]    =" + string2);
                    System.out.println(" [vtime]  =" + l);
                    System.out.println(" [userid] =" + string3);
                }
                String string4 = ((HttpServletRequest)servletRequest).getRequestURL().toString() + "?" + ((HttpServletRequest)servletRequest).getQueryString();
                if (this.isDecode) {
                    if (this.isDebug) {
                        System.out.println("[BeforeURIDecode]=" + string4);
                    }
                    string4 = StringUtil.urlDecode((String)string4);
                }
                string4 = string4.substring(0, string4.lastIndexOf("h_urlCheck") - 1);
                String string5 = ((HttpServletRequest)servletRequest).getRemoteUser();
                if (this.isDebug) {
                    System.out.println(" [reqURL] =" + string4);
                    System.out.println(" [ctime]  =" + System.currentTimeMillis());
                    System.out.println(" [reqUser]=" + string5);
                }
                if (!string4.endsWith(string2) || System.currentTimeMillis() - l >= 0L || stringArray == null || stringArray.length <= 0) break block13;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!"*".equals(stringArray[i]) && !string5.equals(stringArray[i])) continue;
                    bl = true;
                    if (this.isDebug) {
                        System.out.println("  check OK");
                    }
                    break;
                }
            }
            catch (RuntimeException runtimeException) {
                if (this.isDebug) {
                    String string6 = "\u30c1\u30a7\u30c3\u30af\u30a8\u30e9\u30fc\u3002  checkKey=" + string + " " + runtimeException.getMessage();
                    System.out.println(string6);
                    runtimeException.printStackTrace();
                }
                bl = false;
            }
        }
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append("UrlCheckFilter").append("filename=[").append(this.filename).append("],").append("isDecode=[").append(this.isDecode).append(']');
        return stringBuilder.toString();
    }
}

