<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:tld="http://java.sun.com/xml/ns/j2ee" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
  <xsl:template match="/">
    <xsl:apply-templates select="tld:taglib" />
  </xsl:template>

  <xsl:template match="tld:taglib">
    <xsl:variable name="version" select="tld:tlib-version" />
    <xsl:variable name="prefix"  select="tld:short-name" />
    <ROWSET tableName="GF22">
      <EXEC_SQL>delete from GF22 where VERNO = '<xsl:value-of select="$version" />'</EXEC_SQL>
      <xsl:for-each select="tld:tag/tld:attribute">
        <xsl:element name="ROW">
          <xsl:attribute name="num">
            <xsl:number level="any" format="1" count="tld:attribute" />
          </xsl:attribute>
          <VERNO><xsl:value-of select="$version" /></VERNO>
          <PRE_FIX><xsl:value-of select="$prefix" /></PRE_FIX>
          <TAGNAME><xsl:value-of select="../tld:name" /></TAGNAME>
          <VALUENAME><xsl:value-of select="tld:name" /></VALUENAME>
          <SEQ><xsl:number level="single" format="1" count="tld:tag/tld:attribute" /></SEQ>
          <TAGCLASS><xsl:value-of select="../tld:tag-class" /></TAGCLASS>
          <REQUIRED>
            <xsl:variable name="req" select="tld:required"/>
            <xsl:if test="$req='true'"  >1</xsl:if>
            <xsl:if test="$req='false'" >2</xsl:if>
            <xsl:if test="$req='yes'"   >3</xsl:if>
            <xsl:if test="$req='no'"    >4</xsl:if>
          </REQUIRED>
          <RTEXPRVALUE>
            <xsl:variable name="rtex" select="tld:rtexprvalue"/>
            <xsl:if test="$rtex='true'"  >1</xsl:if>
            <xsl:if test="$rtex='false'" >2</xsl:if>
            <xsl:if test="$rtex='yes'"   >3</xsl:if>
            <xsl:if test="$rtex='no'"    >4</xsl:if>
          </RTEXPRVALUE>
          <VAL_TYPE><xsl:value-of select="tld:type" /></VAL_TYPE>
        </xsl:element>
      </xsl:for-each>
    </ROWSET>
  </xsl:template>

</xsl:stylesheet>
