/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.mail.MailManager_DIRECT;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class MailSenderTag2
extends CommonTagSupport {
    private static final String VERSION = "6.3.4.0 (2015/08/01)";
    private static final long serialVersionUID = 634020150801L;
    private static final String ACT_CHECK = "CHECK";
    private static final String ACT_SEND = "SEND";
    private static final String ACT_NOCHECK = "NOCHECK";
    private static final String[] ACTION_LIST = new String[]{"CHECK", "SEND", "NOCHECK"};
    private static final Set<String> ACTION_SET = new HashSet<String>(Arrays.asList(ACTION_LIST));
    private static final int MAX_FILE_COUNT = 5;
    private String ptnId;
    private String action;
    private String from;
    private String to;
    private String cc;
    private String bcc;
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String[] filename;
    private String tableId = "h_tblmdl";
    private boolean addrCheck;
    private boolean useStop = true;

    @Override
    public int doEndTag() {
        this.debugPrint();
        int n = 6;
        int n2 = 0;
        if (this.check(this.action, ACTION_SET)) {
            try {
                Map<String, String> map;
                this.tableId = this.tableId == null ? "h_tblmdl" : this.tableId;
                MailManager_DIRECT mailManager_DIRECT = new MailManager_DIRECT();
                mailManager_DIRECT.setResourceManager(this.getResource());
                DBTableModel dBTableModel = null;
                if (ACT_NOCHECK.equals(this.action) || ACT_CHECK.equals(this.action)) {
                    map = this.makeParamMap();
                    mailManager_DIRECT.create(map);
                }
                if (ACT_NOCHECK.equals(this.action)) {
                    mailManager_DIRECT.setDebug(this.isDebug());
                    mailManager_DIRECT.send();
                } else if (ACT_CHECK.equals(this.action)) {
                    this.setSessionAttribute("MAIL.FROM_ADDR", mailManager_DIRECT.getFromAddr());
                    this.setSessionAttribute("MAIL.PTN_ID", this.ptnId);
                    this.setSessionAttribute("MAIL.TITLE", mailManager_DIRECT.getTitle());
                    this.setSessionAttribute("MAIL.CONTENT", mailManager_DIRECT.getContent());
                } else if (ACT_SEND.equals(this.action)) {
                    this.ptnId = (String)this.getSessionAttribute("MAIL.PTN_ID");
                    map = this.makeParamMap();
                    mailManager_DIRECT.setFromAddr((String)this.getSessionAttribute("MAIL.FROM_ADDR"));
                    mailManager_DIRECT.setTitle((String)this.getSessionAttribute("MAIL.TITLE"));
                    mailManager_DIRECT.setContent((String)this.getSessionAttribute("MAIL.CONTENT"));
                    dBTableModel = (DBTableModel)this.getObject(this.tableId);
                    mailManager_DIRECT.create(map, dBTableModel);
                    mailManager_DIRECT.setDebug(this.isDebug());
                    mailManager_DIRECT.send();
                }
                this.startQueryTransaction(this.tableId);
                dBTableModel = mailManager_DIRECT.makeDstTable();
                if (!this.commitTableObject(this.tableId, dBTableModel)) {
                    this.jspPrint("DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
                }
            }
            catch (RuntimeException runtimeException) {
                if (this.useStop) {
                    ErrorMessage errorMessage = new ErrorMessage();
                    errorMessage.addMessage(0, 2, "ERR0040", new String[]{runtimeException.getMessage()});
                    this.jspPrint(TaglibUtil.makeHTMLErrorTable(errorMessage, this.getResource()));
                    n = 5;
                }
                runtimeException.printStackTrace();
                n2 = 1;
            }
        } else {
            String string = "\u8a2d\u5b9a\u306e\u30a2\u30af\u30b7\u30e7\u30f3\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff1a" + this.action;
            throw new HybsSystemException(string);
        }
        this.setSessionAttribute("MAIL.ERR_CODE", String.valueOf(n2));
        return n;
    }

    public void setAction(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() > 0) {
            this.action = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setPtnId(String string) {
        this.ptnId = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setFrom(String string) {
        this.from = StringUtil.nval((String)this.getRequestParameter(string), (String)this.from);
        this.setRequestAttribute("FROM", this.from);
    }

    public void setTo(String string) {
        this.to = this.getRequestParameter(string);
    }

    public void setCc(String string) {
        this.cc = this.getRequestParameter(string);
    }

    public void setBcc(String string) {
        this.bcc = this.getRequestParameter(string);
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2, (String[])new String[0]);
        }
    }

    public void setFilename(String string) {
        this.filename = StringUtil.csv2ArrayOnly((String)this.getRequestParameter(string));
    }

    public void setAddrCheck(String string) {
        this.addrCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.addrCheck);
    }

    public void setUseStop(String string) {
        this.useStop = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useStop);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    @Override
    protected void release2() {
        super.release2();
        this.from = null;
        this.to = null;
        this.cc = null;
        this.bcc = null;
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.filename = null;
        this.ptnId = null;
        this.action = null;
        this.tableId = "h_tblmdl";
        this.addrCheck = false;
        this.useStop = true;
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("ptnId", (Object)this.ptnId).println("action", (Object)this.action).println("tableId", (Object)this.tableId).println("addrCheck", (Object)this.addrCheck).println("useStop", (Object)this.useStop).println("from", (Object)this.from).println("to", (Object)this.to).println("cc", (Object)this.cc).println("bcc", (Object)this.bcc).println("filename", (Object[])this.filename).println("fileURL", (Object)this.fileURL).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }

    private Map<String, String> makeParamMap() {
        Object object;
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.action.endsWith(ACT_NOCHECK) || this.action.equals(ACT_CHECK)) {
            Object object2;
            Object object3;
            stringArray = this.getRequest();
            object = stringArray.getAttributeNames();
            while (object.hasMoreElements()) {
                object3 = (String)object.nextElement();
                object2 = stringArray.getAttribute((String)object3);
                if (!(object2 instanceof String)) continue;
                hashMap.put((String)object3, (String)stringArray.getAttribute((String)object3));
            }
            object3 = stringArray.getParameterNames();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                hashMap.put((String)object2, stringArray.getParameter((String)object2));
            }
            hashMap.put("FROM", this.from);
            hashMap.put("TO", this.to);
            hashMap.put("CC", this.cc);
            hashMap.put("BCC", this.bcc);
        }
        hashMap.put("PTN_ID", this.ptnId);
        hashMap.put("SYSTEM_ID", HybsSystem.sys("SYSTEM_ID"));
        hashMap.put("ADDR_CHECK", String.valueOf(this.addrCheck));
        hashMap.put("LOGIN_USERID", this.getRequestValue("USER.ID"));
        hashMap.put("LOGIN_USERNAME", this.getRequestValue("USER.JNAME"));
        hashMap.put("PGID", this.getRequestValue("GUI.KEY"));
        hashMap.put("DATE", HybsSystem.getDate("yyyy/MM/dd"));
        hashMap.put("TIME", HybsSystem.getDate("HH:mm:ss"));
        stringArray = new String[]{"", "", "", "", ""};
        if (this.filename != null && this.filename.length > 0) {
            object = HybsSystem.url2dir(this.fileURL);
            int n = this.filename.length > 5 ? 5 : this.filename.length;
            for (int i = 0; i < n; ++i) {
                stringArray[i] = StringUtil.urlAppend((String)object, (String)this.filename[i], (String[])new String[0]);
            }
        }
        hashMap.put("ATTACH1", stringArray[0]);
        hashMap.put("ATTACH2", stringArray[1]);
        hashMap.put("ATTACH3", stringArray[2]);
        hashMap.put("ATTACH4", stringArray[3]);
        hashMap.put("ATTACH5", stringArray[4]);
        return hashMap;
    }
}

