/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.RichTextString;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.report.AbstractDBTableReport;

public class DBTableReport_Excel
extends AbstractDBTableReport {
    private static final String EXCEL_FILE_EXT = ".xls";
    private static final Pattern PATTERN_KEY = Pattern.compile("\\{@((\\w+?)(?:_(\\d+?))?)\\}", 8);
    private static final Pattern PATTERN_EXIN = Pattern.compile("ATTR\\(semiVolatile\\)", 8);
    private HSSFWorkbook wb;

    @Override
    public void writeReport() {
        this.setHeaderFooter();
        this.initReader();
        this.initWriter();
        this.changeSheet();
        this.close();
    }

    @Override
    protected void initReader() {
        if (null != this.wb) {
            this.wb = null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.templateFile);
            POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem((InputStream)fileInputStream);
            this.wb = new HSSFWorkbook(pOIFSFileSystem);
        }
        catch (IOException iOException) {
            try {
                String string = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30aa\u30fc\u30d7\u30f3\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsConst.CR + "  File:" + this.templateFile;
                throw new HybsSystemException(string, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(fileInputStream);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)fileInputStream);
    }

    @Override
    protected void initWriter() {
    }

    protected void close() {
        String string = this.htmlDir + HybsConst.FS + this.htmlFileKey + EXCEL_FILE_EXT;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            this.wb.write((OutputStream)fileOutputStream);
        }
        catch (IOException iOException) {
            try {
                this.wb = null;
                String string2 = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30aa\u30fc\u30d7\u30f3\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsConst.CR + "  File:" + string;
                throw new HybsSystemException(string2, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(fileOutputStream);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)fileOutputStream);
    }

    protected void changeSheet() {
        HSSFSheet hSSFSheet = this.wb.getSheetAt(0);
        while (!this.rowOver) {
            HSSFSheet hSSFSheet2 = this.wb.cloneSheet(0);
            int n = hSSFSheet2.getFirstRowNum();
            int n2 = hSSFSheet2.getLastRowNum();
            for (int i = n; i <= n2; ++i) {
                HSSFRow hSSFRow = hSSFSheet.getRow(i);
                if (null == hSSFRow) continue;
                int n3 = hSSFRow.getFirstCellNum();
                short s = hSSFRow.getLastCellNum();
                for (int j = n3; j <= s; ++j) {
                    HSSFCell hSSFCell = hSSFRow.getCell(j);
                    if (null == hSSFCell) continue;
                    this.changeCell(hSSFCell);
                }
            }
        }
    }

    protected void changeCell(HSSFCell hSSFCell) {
        int n = hSSFCell.getCellType();
        switch (n) {
            case 2: {
                String string = this.changeData(this.changeFormulaAttr(hSSFCell.getCellFormula()));
                if (null == string) break;
                hSSFCell.setCellFormula(string);
                break;
            }
            case 1: {
                HSSFRichTextString hSSFRichTextString = hSSFCell.getRichStringCellValue();
                String string = this.changeData(hSSFRichTextString.getString());
                if (null == string) break;
                hSSFCell.setCellValue((RichTextString)new HSSFRichTextString(string));
                break;
            }
        }
    }

    protected String changeFormulaAttr(String string) {
        Matcher matcher = PATTERN_EXIN.matcher(string);
        return matcher.find() ? matcher.replaceAll("") : string;
    }

    @Override
    protected String changeData(String string) {
        boolean bl = false;
        Matcher matcher = PATTERN_KEY.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, this.getValue(matcher.group(1)));
            bl = true;
        }
        if (bl) {
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return null;
    }

    @Override
    protected String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void println(String string) {
        throw new UnsupportedOperationException();
    }
}

