/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.SystemManager;
import org.opengion.hayabusa.resource.ResourceManager;

public final class ResourceFactory {
    private static final String SYSTEM_ID = HybsSystem.sys("SYSTEM_ID");
    private static final ResourceManager ja_Manager = new ResourceManager(SYSTEM_ID, "ja", true);
    private static final Map<String, ResourceManager> pool = Collections.synchronizedMap(new HashMap());

    private ResourceFactory() {
    }

    public static ResourceManager newInstance(String string) {
        if (string == null || "ja".equalsIgnoreCase(string)) {
            return ja_Manager;
        }
        return ResourceFactory.newInstance(SYSTEM_ID, string, true);
    }

    public static ResourceManager newInstance(String string, String string2, boolean bl) {
        String string3;
        String string4 = string != null ? string : SYSTEM_ID;
        String string5 = string3 = string2 != null ? string2 : "ja";
        if (SYSTEM_ID.equalsIgnoreCase(string4) && "ja".equalsIgnoreCase(string3)) {
            return ja_Manager;
        }
        String string6 = string4 + string3;
        ResourceManager resourceManager = pool.get(string6);
        if (resourceManager == null) {
            resourceManager = new ResourceManager(string4, string3, bl);
            pool.put(string6, resourceManager);
        }
        return resourceManager;
    }

    public static void clear() {
        ja_Manager.clear();
        Set<String> set = pool.keySet();
        String[] stringArray = set.toArray(new String[set.size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            ResourceManager resourceManager = pool.remove(stringArray[i]);
            resourceManager.clear();
        }
        pool.clear();
    }

    public static void guiClear() {
        ja_Manager.guiClear();
        Set<String> set = pool.keySet();
        String[] stringArray = set.toArray(new String[set.size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            ResourceManager resourceManager = pool.get(stringArray[i]);
            resourceManager.guiClear();
        }
    }

    static {
        Cleanable cleanable = new Cleanable(){

            public void clear() {
                ResourceFactory.clear();
            }
        };
        SystemManager.addCleanable(cleanable);
    }
}

