<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="result" >
	<!--<script type="text/javascript" src="asperaweb-2.js" ></script> -->
	<link rel="stylesheet" type="text/css" href="application.css" />
</og:head>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6450"
	title	= "tokenテスト"
	date	= "2015/01/30"
	author	= "Takahashi Masakazu"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select CASE KBSAKU WHEN '3' THEN '0' ELSE KBSAKU END AS WRITABLE,
				CLM,NAME_JA,LABEL_NAME,KBSAKU,SYSTEM_ID,LANG,FGJ
		from GF41
	<og:where>
		<og:and value = "FGJ         in  ('0','1')"         />
		<og:and value = "SYSTEM_ID   =  '{@SYSTEM_ID}'"     />
		<og:and value = "LANG        =  '{@LANG}'"          />
		<og:and value = "CLM         like '{@CLM}%'"        />
		<og:and value = "NAME_JA     like '{@NAME_JA}%'"    />
		<og:and value = "LABEL_NAME  like '{@LABEL_NAME}%'" />
		<og:and value = "KBSAKU      =    '{@KBSAKU}'"      />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>


<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="LABEL_NAME" href="/mtc-nas19/ASPERATEST/systest/[CLM].xlsx" useGamenId="false" extToken="Aspera" />
</og:viewLink>

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="{@command}">
	<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" markList="1" >
		<span style="background-color:#ccff00">[NAME_JA]</span>
	</og:columnMarker>
	<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" markList="2" >
		<span style="background-color:#cc00ff">[NAME_JA]</span>
	</og:columnMarker>
	<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" markList="3" >
		<span style="background-color:#00ccff">[NAME_JA]</span>
	</og:columnMarker>
	<og:columnMarker column="LABEL_NAME" onMark="[KBSAKU]" markList="0,3" >
		<div style="background-color:#00ccff">[LABEL_NAME]</div>
	</og:columnMarker>
</og:viewMarker>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT" >

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = ""
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
/>

</form>

<script type="text/javascript" src="asperaplugininstaller.js" ><!-- --></script>
<script type="text/javascript" src="asperaDownload.js" ><!-- --></script>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
