/****************************************************************************/
/* GF66 ( ﾀｽｸﾘｿｰｽ定義 )                                                     */
/*                                                                          */
/* Created : 2015/10/28 15:14:27                                            */
/****************************************************************************/
CREATE TABLE GF66 (
   PRJCODE      VARCHAR2 ( 30 )                                     /*  10 PRJｺｰﾄﾞ  */
 , TASK_ID      NUMBER   (  5 )                                     /*  20 ﾀｽｸID    */
 , RESOURCE_ID  NUMBER   (  9 )                                     /*  30 ﾘｿｰｽID   */
 , SEQ          NUMBER   (  7 )     DEFAULT 0   NOT NULL            /*  40 順       */
 , SU_LOAD      NUMBER   (  5 )                                     /*  50 負荷     */
 , UNIQ         NUMBER   (  9 )     DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ   */
 , FGJ          VARCHAR2 (  1 )     DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ */
 , DYSET        VARCHAR2 ( 14 )                                     /* 820 登録日時 */
 , PGSET        VARCHAR2 ( 10 )                                     /* 830 作成PG   */
 , PGPSET       VARCHAR2 ( 10 )                                     /* 840 作成親PG */
 , USRSET       VARCHAR2 ( 10 )                                     /* 850 作成社員 */
 , DYUPD        VARCHAR2 ( 14 )                                     /* 860 更新日時 */
 , PGUPD        VARCHAR2 ( 10 )                                     /* 870 更新PG   */
 , PGPUPD       VARCHAR2 ( 10 )                                     /* 880 更新親PG */
 , USRUPD       VARCHAR2 ( 10 )                                     /* 890 更新者   */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K );

CREATE SEQUENCE GF66S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF66T00 
  BEFORE INSERT ON GF66
  FOR EACH ROW 
  BEGIN 
    SELECT GF66S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
