/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.develop;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JspEnumeration {

    public static enum WHERE_OPERATORS {
        eq{

            @Override
            public String apply(String string, String string2, boolean bl) {
                if (bl) {
                    return WHERE_OPERATORS.leftVal(string) + "=\t " + string2;
                }
                return WHERE_OPERATORS.leftVal(string) + "=\t '" + string2 + "'";
            }

            @Override
            public String[] symbol() {
                return new String[]{"="};
            }
        }
        ,
        lk1{

            @Override
            public String apply(String string, String string2, boolean bl) {
                return WHERE_OPERATORS.leftVal(string) + "like '" + string2 + "%'";
            }

            @Override
            public String[] symbol() {
                return new String[]{"like", "", "%"};
            }
        }
        ,
        lk2{

            @Override
            public String apply(String string, String string2, boolean bl) {
                return WHERE_OPERATORS.leftVal(string) + "like '%" + string2 + "'";
            }

            @Override
            public String[] symbol() {
                return new String[]{"like", "%", ""};
            }
        }
        ,
        lk3{

            @Override
            public String apply(String string, String string2, boolean bl) {
                return WHERE_OPERATORS.leftVal(string) + "like '%" + string2 + "%'";
            }

            @Override
            public String[] symbol() {
                return new String[]{"like", "%", "%"};
            }
        }
        ,
        gt{

            @Override
            public String apply(String string, String string2, boolean bl) {
                if (bl) {
                    return WHERE_OPERATORS.leftVal(string) + ">\t " + string2;
                }
                return WHERE_OPERATORS.leftVal(string) + ">\t '" + string2 + "'";
            }

            @Override
            public String[] symbol() {
                return new String[]{">"};
            }
        }
        ,
        ge{

            @Override
            public String apply(String string, String string2, boolean bl) {
                if (bl) {
                    return WHERE_OPERATORS.leftVal(string) + ">=\t " + string2;
                }
                return WHERE_OPERATORS.leftVal(string) + ">=\t '" + string2 + "'";
            }

            @Override
            public String[] symbol() {
                return new String[]{">="};
            }
        }
        ,
        lt{

            @Override
            public String apply(String string, String string2, boolean bl) {
                if (bl) {
                    return WHERE_OPERATORS.leftVal(string) + "<\t " + string2;
                }
                return WHERE_OPERATORS.leftVal(string) + "<\t '" + string2 + "'";
            }

            @Override
            public String[] symbol() {
                return new String[]{"<"};
            }
        }
        ,
        le{

            @Override
            public String apply(String string, String string2, boolean bl) {
                if (bl) {
                    return WHERE_OPERATORS.leftVal(string) + "<=\t " + string2;
                }
                return WHERE_OPERATORS.leftVal(string) + "<=\t '" + string2 + "'";
            }

            @Override
            public String[] symbol() {
                return new String[]{"<="};
            }
        }
        ,
        not{

            @Override
            public String apply(String string, String string2, boolean bl) {
                if (bl) {
                    return WHERE_OPERATORS.leftVal(string) + "!=\t " + string2;
                }
                return WHERE_OPERATORS.leftVal(string) + "!=\t '" + string2 + "'";
            }

            @Override
            public String[] symbol() {
                return new String[]{"!="};
            }
        }
        ,
        bw{

            @Override
            public String apply(String string, String string2, boolean bl) {
                if (bl) {
                    return WHERE_OPERATORS.leftVal(string) + "between " + WHERE_OPERATORS.betweenFormat(string2, "_FROM") + " and " + WHERE_OPERATORS.betweenFormat(string2, "_TO");
                }
                return WHERE_OPERATORS.leftVal(string) + "between '" + WHERE_OPERATORS.betweenFormat(string2, "_FROM") + "' and '" + WHERE_OPERATORS.betweenFormat(string2, "_TO") + "'";
            }

            @Override
            public String[] symbol() {
                return new String[]{"between"};
            }
        }
        ,
        in{

            @Override
            public String apply(String string, String string2, boolean bl) {
                return WHERE_OPERATORS.leftVal(string) + "in\t (" + WHERE_OPERATORS.inFormat(string2, bl) + ")";
            }

            @Override
            public String[] symbol() {
                return new String[]{"in"};
            }
        };

        private static final String[] TABS;
        private static final Pattern LK1_PTN;
        private static final Pattern LK2_PTN;
        private static final Pattern LK3_PTN;

        private static String leftVal(String string) {
            int n = (string.length() - 1) / 4 > 3 ? 3 : (string.length() - 1) / 4;
            return string + TABS[n];
        }

        public abstract String apply(String var1, String var2, boolean var3);

        public abstract String[] symbol();

        private static String inFormat(String string, boolean bl) {
            String[] stringArray;
            StringBuilder stringBuilder = new StringBuilder(200);
            for (String string2 : stringArray = string.split(",")) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                if (bl) {
                    stringBuilder.append(string2);
                    continue;
                }
                stringBuilder.append('\'').append(string2).append('\'');
            }
            return stringBuilder.toString();
        }

        private static String betweenFormat(String string, String string2) {
            StringBuilder stringBuilder = new StringBuilder(string);
            if (string.indexOf("{@") == 0) {
                stringBuilder.insert(stringBuilder.length() - 1, string2);
            } else {
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }

        private static String convert(String string) {
            for (WHERE_OPERATORS wHERE_OPERATORS : WHERE_OPERATORS.values()) {
                if (wHERE_OPERATORS.symbol().length == 1 && string.trim().indexOf(wHERE_OPERATORS.symbol()[0]) == 0) {
                    return wHERE_OPERATORS.toString();
                }
                if (wHERE_OPERATORS.symbol().length != 3) continue;
                Matcher matcher = LK1_PTN.matcher(string);
                if (matcher.find()) {
                    return lk1.toString();
                }
                matcher = LK2_PTN.matcher(string);
                if (matcher.find()) {
                    return lk2.toString();
                }
                matcher = LK3_PTN.matcher(string);
                if (!matcher.find()) continue;
                return lk3.toString();
            }
            return "";
        }

        static {
            TABS = new String[]{"\t\t\t\t", "\t\t\t", "\t\t", "\t"};
            LK1_PTN = Pattern.compile("like\\s+\\'\\{@(\\w*?)\\}%\\'");
            LK2_PTN = Pattern.compile("like\\s+\\'%\\{@(\\w*?)\\}\\'");
            LK3_PTN = Pattern.compile("like\\s+\\'%\\{@(\\w*?)\\}%\\'");
        }
    }

    public static enum TREATS_STRING_FUNCTIONS {
        CASE,
        CEIL,
        ROUND,
        FLOOR,
        TRUNC,
        MOD,
        CHR,
        CONCAT,
        SUBSTR,
        INITCAP,
        SUBSTRB,
        LOWER,
        TRIM,
        LPAD,
        LTRIM,
        UPPER,
        REPLACE,
        USER,
        RPAD,
        ASCII,
        LENGTH,
        LENGTHB,
        INSTR,
        POSITION,
        INSTRB,
        ADD_MONTHS,
        DAYOFMONTH,
        MONTHNAME,
        TIMESTAMPADD,
        CURDATE,
        DAYOFWEEK,
        MONTHS_BETWEEN,
        TIMESTAMPDIFF,
        CURRENT_DATE,
        DAYOFYEAR,
        NEXT_DAY,
        CURRENT_TIME,
        HOUR,
        NOW,
        WEEK,
        CURRENT_TIMESTAMP,
        LAST_DAY,
        YEAR,
        CURTIME,
        MINUTE,
        SECOND,
        DAYNAME,
        MONTH,
        SYSDATE,
        CAST,
        AVG,
        CONVERT,
        DATABASE,
        TO_CHAR,
        DECODE,
        TO_NUMBER,
        EXTRACT,
        TO_DATE,
        GREATEST,
        STDDEV,
        INTERVAL,
        VARIANCE,
        LEAST,
        LOCATE,
        NVL;


        public String update(String string, String ... stringArray) {
            return string;
        }
    }

    public static enum GROUPING_FUNCTIONS {
        MAX,
        MIN,
        SUM,
        COUNT;


        public static boolean contains(String string) {
            for (GROUPING_FUNCTIONS gROUPING_FUNCTIONS : GROUPING_FUNCTIONS.values()) {
                if (!string.equalsIgnoreCase(gROUPING_FUNCTIONS.toString())) continue;
                return true;
            }
            return false;
        }

        public static boolean search(String string) {
            String string2 = string.toUpperCase(Locale.JAPAN);
            for (GROUPING_FUNCTIONS gROUPING_FUNCTIONS : GROUPING_FUNCTIONS.values()) {
                if (string2.indexOf(gROUPING_FUNCTIONS.toString()) <= -1) continue;
                return true;
            }
            return false;
        }
    }
}

