/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.util.ErrMsg;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBColumnConfig;
import org.opengion.hayabusa.resource.CodeData;
import org.opengion.hayabusa.resource.CodeDataLoader;
import org.opengion.hayabusa.resource.ColumnData;
import org.opengion.hayabusa.resource.ColumnDataLoader;
import org.opengion.hayabusa.resource.GUIData;
import org.opengion.hayabusa.resource.GUIDataLoader;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.resource.LabelData;
import org.opengion.hayabusa.resource.LabelDataLoader;
import org.opengion.hayabusa.resource.UserInfo;

public final class ResourceManager {
    private final ColumnDataLoader columnLoader;
    private final CodeDataLoader codeLoader;
    private final LabelDataLoader labelLoader;
    private final GUIDataLoader guiLoader;
    private final Map<String, DBColumn> columnPool = Collections.synchronizedMap(new HashMap(500));
    private final String lang;

    public ResourceManager(String string, String string2, boolean bl) {
        this.lang = string2;
        this.columnLoader = new ColumnDataLoader(string, bl);
        this.labelLoader = new LabelDataLoader(string, this.lang, bl);
        this.codeLoader = new CodeDataLoader(string, bl, this.labelLoader);
        this.guiLoader = new GUIDataLoader(string);
    }

    public String getLang() {
        return this.lang;
    }

    public DBColumn getDBColumn(String string) {
        ColumnData columnData;
        DBColumn dBColumn = this.columnPool.get(string);
        if (dBColumn == null && (columnData = this.columnLoader.getColumnData(string)) != null) {
            String string2 = columnData.getLabelColumn();
            String string3 = columnData.getCodeColumn();
            dBColumn = new DBColumn(this.lang, columnData, this.labelLoader.getLabelData(string2), this.codeLoader.getCodeData(string3));
            this.columnPool.put(string, dBColumn);
        }
        return dBColumn;
    }

    public DBColumn makeDBColumn(String string) {
        DBColumn dBColumn = this.getDBColumn(string);
        if (dBColumn == null) {
            DBColumnConfig dBColumnConfig = new DBColumnConfig(string);
            dBColumnConfig.setLabelData(this.getLabelData(string));
            dBColumnConfig.setLang(this.getLang());
            dBColumn = new DBColumn(dBColumnConfig);
        }
        return dBColumn;
    }

    public void setDBColumn(String string, DBColumn dBColumn) {
        if (string != null && string.length() > 0 && dBColumn != null) {
            this.columnPool.put(string, dBColumn);
        }
    }

    public String getLabel(String string) {
        LabelData labelData = this.labelLoader.getLabelData(string);
        String string2 = labelData.getLabel();
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public String getLabel(String string, String[] stringArray) {
        String string2;
        if (stringArray == null || stringArray.length == 0) {
            string2 = this.getLabel(string);
        } else {
            String[] stringArray2 = this.makeLabelArray(stringArray);
            LabelData labelData = this.labelLoader.getLabelData(string);
            string2 = labelData.getMessage(stringArray2);
        }
        return string2;
    }

    private String getExtLabel(String string) {
        String string2;
        int n = string.indexOf(" %");
        if (n < 0) {
            string2 = this.getLabel(string);
        } else if (n + 2 <= string.length()) {
            string2 = this.getLabel(string.substring(0, n));
        } else {
            String string3 = string.substring(0, n);
            switch (string.charAt(n + 2)) {
                case 'L': {
                    string2 = this.getLabel(string3);
                    break;
                }
                case 'C': 
                case 'S': {
                    string2 = this.getShortLabel(string3);
                    break;
                }
                case 'T': {
                    string2 = this.getLongLabel(string3);
                    break;
                }
                case 'D': {
                    string2 = this.getDescription(string3);
                    break;
                }
                case 'R': {
                    string2 = this.getRawShortLabel(string3);
                    break;
                }
                default: {
                    string2 = this.getLabel(string3);
                }
            }
        }
        return string2;
    }

    private String[] makeLabelArray(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (StringUtil.startsChar((String)string, (char)'#')) {
                if (string.indexOf(44) < 0) {
                    stringArray2[i] = this.getExtLabel(string.substring(1));
                    continue;
                }
                String[] stringArray3 = StringUtil.csv2Array((String)string.substring(1));
                StringBuilder stringBuilder = new StringBuilder(200);
                for (int j = 0; j < stringArray3.length; ++j) {
                    if (j > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(this.getExtLabel(stringArray3[j]));
                }
                stringArray2[i] = this.getExtLabel(stringBuilder.toString());
                continue;
            }
            stringArray2[i] = string;
        }
        return stringArray2;
    }

    public String getLabel(ErrMsg errMsg) {
        return this.getLabel(errMsg.getId(), errMsg.getArgs());
    }

    public String getShortLabel(String string) {
        LabelData labelData = this.labelLoader.getLabelData(string);
        String string2 = labelData.getShortLabel();
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public String getLongLabel(String string) {
        LabelData labelData = this.labelLoader.getLabelData(string);
        String string2 = labelData.getLongLabel();
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public String getRawShortLabel(String string) {
        LabelData labelData = this.labelLoader.getLabelData(string);
        String string2 = labelData.getRawShortLabel();
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public String getDescription(String string) {
        LabelData labelData = this.labelLoader.getLabelData(string);
        String string2 = labelData.getDescription();
        if (string2 != null) {
            return string2;
        }
        return null;
    }

    public String getDescription(String string, String[] stringArray) {
        String string2;
        if (stringArray == null || stringArray.length == 0) {
            string2 = this.getDescription(string);
        } else {
            String[] stringArray2 = this.makeLabelArray(stringArray);
            LabelData labelData = this.labelLoader.getLabelData(string);
            string2 = labelData.getDescription(stringArray2);
        }
        return string2;
    }

    public String getDescription(ErrMsg errMsg) {
        return this.getDescription(errMsg.getId(), errMsg.getArgs());
    }

    public LabelData getLabelData(String string) {
        return this.labelLoader.getLabelData(string);
    }

    public CodeData getCodeData(String string) {
        return this.codeLoader.getCodeData(string);
    }

    public CodeData getCodeData(String string, String string2) {
        return this.codeLoader.getCodeData(string, string2);
    }

    public void makeGUIInfos(UserInfo userInfo) {
        Object object;
        GUIData[] gUIDataArray = this.guiLoader.getAllData();
        HashMap<String, GUIInfo> hashMap = new HashMap<String, GUIInfo>();
        HashSet<String> hashSet = new HashSet<String>();
        for (GUIData object22 : gUIDataArray) {
            Object object2;
            byte by = userInfo.getAccessBitMode(object22.getRoleMode());
            if (by > 0) {
                object2 = object22.getGuiKey();
                object = this.getLabelData(object22.getLabelClm());
                hashMap.put((String)object2, new GUIInfo(object22, (LabelData)object, by));
                continue;
            }
            object2 = object22.getAddress();
            if (((String)object2).indexOf(47) >= 0) continue;
            hashSet.add((String)object2);
        }
        for (GUIInfo gUIInfo : hashMap.values()) {
            String string = gUIInfo.getAddress();
            if (!hashSet.contains(gUIInfo.getAddress())) continue;
            hashSet.remove(string);
        }
        Object[] objectArray = hashMap.values().toArray(new GUIInfo[hashMap.size()]);
        Arrays.sort(objectArray);
        LinkedHashMap<String, GUIInfo> linkedHashMap = new LinkedHashMap<String, GUIInfo>();
        for (Object object2 : objectArray) {
            object = ((GUIInfo)object2).getKey();
            linkedHashMap.put((String)object, (GUIInfo)object2);
        }
        userInfo.setGUIMap(linkedHashMap, hashSet);
    }

    public Map<String, LabelData> getLabelMap(String string) {
        return this.labelLoader.getLabelMap(string);
    }

    public void clear(String string) {
        System.out.println("Key=[" + string + "] \u306e\u90e8\u5206\u30ea\u30bd\u30fc\u30b9\u30af\u30ea\u30a2\u3092\u5b9f\u65bd\u3057\u307e\u3057\u305f\u3002");
        this.columnLoader.clear(string);
        this.codeLoader.clear(string);
        this.labelLoader.clear(string);
        this.columnPool.remove(string);
    }

    public void guiClear() {
        GUIData[] gUIDataArray = this.guiLoader.getAllData();
        for (int i = 0; i < gUIDataArray.length; ++i) {
            String string = gUIDataArray[i].getGuiKey();
            this.labelLoader.clear(string);
        }
        this.codeLoader.clear("CLASSIFY");
        this.guiLoader.clear();
    }

    public void clear() {
        this.columnLoader.clear();
        this.codeLoader.clear();
        this.labelLoader.clear();
        this.guiLoader.clear();
        this.columnPool.clear();
    }
}

