/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opengion.fukurou.util.FileInfo;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.StringUtil;

public final class JacobUtil {
    private static final String VERSION = "6.3.9.0 (2015/11/06)";
    private static final String PDF_SUFIX = "pdf";
    private static final String XLS_SUFIX = "xls,xlsx,xlsm";

    private JacobUtil() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void saveAs(File file, File file2) {
        String string = FileInfo.getSUFIX(file);
        String string2 = FileInfo.getSUFIX(file2);
        if (!XLS_SUFIX.contains(string)) {
            String string3 = "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306e\u62e1\u5f35\u5b50\u304c\u3001\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + HybsConst.CR + " inFile=[" + file + "] , outFile=[" + file2 + "]" + HybsConst.CR + " , IN SUFIX=" + XLS_SUFIX + " \u306e\u3046\u3061\u3001\u3069\u308c\u304b" + HybsConst.CR;
            throw new RuntimeException(string3);
        }
        if (XLS_SUFIX.contains(string2)) {
            JacobUtil.copyExcel(file, file2);
            return;
        }
        if (PDF_SUFIX.contains(string2)) {
            JacobUtil.excel2PDF(file, file2);
            return;
        }
        String string4 = "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u306e\u62e1\u5f35\u5b50\u304c\u3001\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + HybsConst.CR + " inFile=[" + file + "] , outFile=[" + file2 + "]" + HybsConst.CR + " , OUT SUFIX=" + XLS_SUFIX + "," + PDF_SUFIX + " \u306e\u3046\u3061\u3001\u3069\u308c\u304b" + HybsConst.CR;
        throw new RuntimeException(string4);
    }

    public static void copyExcel(File file, File file2) {
        String string = file.getAbsolutePath();
        String string2 = file2.getAbsolutePath();
        ActiveXComponent activeXComponent = new ActiveXComponent("Excel.Application");
        try {
            ComThread.InitSTA();
            activeXComponent.setProperty("DisplayAlerts", Variant.VT_FALSE);
            Dispatch dispatch = activeXComponent.getProperty("Workbooks").toDispatch();
            Dispatch dispatch2 = Dispatch.call((Dispatch)dispatch, (String)"Open", (Object[])new Object[]{string}).toDispatch();
            Dispatch.call((Dispatch)dispatch2, (String)"SaveAs", (Object[])new Object[]{string2});
            Dispatch.call((Dispatch)dispatch2, (String)"Close", (Object[])new Object[]{Variant.VT_FALSE});
        }
        catch (Throwable throwable) {
            String string3 = "ActiveXComponent Copy\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + throwable.getMessage() + HybsConst.CR + " inFile=[" + file + "] , outFile=[" + file2 + "]";
            System.err.println(string3);
            System.err.println(StringUtil.ogStackTrace(throwable));
            throw new RuntimeException(string3, throwable);
        }
        finally {
            activeXComponent.invoke("Quit", new Variant[0]);
            ComThread.Release();
        }
    }

    public static void excel2PDF(File file, File file2) {
        String string = file.getAbsolutePath();
        String string2 = file2.getAbsolutePath();
        ActiveXComponent activeXComponent = new ActiveXComponent("Excel.Application");
        try {
            ComThread.InitSTA();
            activeXComponent.setProperty("DisplayAlerts", Variant.VT_FALSE);
            Dispatch dispatch = activeXComponent.getProperty("Workbooks").toDispatch();
            Dispatch dispatch2 = Dispatch.call((Dispatch)dispatch, (String)"Open", (Object[])new Object[]{string}).toDispatch();
            Dispatch.call((Dispatch)dispatch2, (String)"SaveAs", (Object[])new Object[]{string2, new Variant(57)});
            Dispatch.call((Dispatch)dispatch2, (String)"Close", (Object[])new Object[]{Variant.VT_FALSE});
        }
        catch (Throwable throwable) {
            String string3 = "ActiveXComponent PDF\u5909\u63db\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + throwable.getMessage() + HybsConst.CR + " inFile=[" + file + "] , outPdf=[" + file2 + "]";
            System.err.println(string3);
            System.err.println(StringUtil.ogStackTrace(throwable));
            throw new RuntimeException(string3, throwable);
        }
        finally {
            activeXComponent.invoke("Quit", new Variant[0]);
            ComThread.Release();
        }
    }

    public static void toPrint(File file, String string) {
        String string2 = file.getAbsolutePath();
        ActiveXComponent activeXComponent = new ActiveXComponent("Excel.Application");
        try {
            ComThread.InitSTA();
            activeXComponent.setProperty("DisplayAlerts", Variant.VT_FALSE);
            Dispatch dispatch = activeXComponent.getProperty("Workbooks").toDispatch();
            Dispatch dispatch2 = Dispatch.call((Dispatch)dispatch, (String)"Open", (Object[])new Object[]{string2}).toDispatch();
            Dispatch.call((Dispatch)dispatch2, (String)"PrintOut", (Object[])new Object[]{Variant.DEFAULT, Variant.DEFAULT, Variant.DEFAULT, Variant.VT_FALSE, new Variant((Object)string)});
            Dispatch.call((Dispatch)dispatch2, (String)"Close", (Object[])new Object[]{Variant.VT_FALSE});
        }
        catch (Throwable throwable) {
            String string3 = "ActiveXComponent \u5370\u5237\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + throwable.getMessage() + HybsConst.CR + " inFile=[" + file + "] , printer=[" + string + "]";
            System.err.println(string3);
            System.err.println(StringUtil.ogStackTrace(throwable));
            throw new RuntimeException(string3, throwable);
        }
        finally {
            activeXComponent.invoke("Quit", new Variant[0]);
            ComThread.Release();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java org.opengion.fukurou.model.JacobUtil [-P(DF)] \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d [\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u540d]");
            return;
        }
        if (stringArray[0].indexOf("-P") >= 0) {
            ExecutorService executorService = Executors.newCachedThreadPool();
            ArrayList<Future<String>> arrayList = new ArrayList<Future<String>>();
            for (int i = 1; i < stringArray.length; ++i) {
                File object = new File(stringArray[i] + ".xlsx");
                File file = new File(stringArray[i] + ".pdf");
                arrayList.add(executorService.submit(() -> {
                    JacobUtil.saveAs(object, file);
                    return file.getName();
                }));
            }
            for (Future future : arrayList) {
                try {
                    System.out.println((String)future.get(10L, TimeUnit.MINUTES));
                }
                catch (InterruptedException | ExecutionException | TimeoutException exception) {
                    exception.printStackTrace();
                }
            }
            executorService.shutdown();
        } else {
            File file = new File(stringArray[0]);
            File file2 = stringArray.length == 1 ? file : new File(stringArray[1]);
            JacobUtil.saveAs(file, file2);
        }
    }
}

