/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.opengion.fukurou.util.StringUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XML2TableParser
extends DefaultHandler {
    private static final String PARENT_FULL_TAG_KEY = "PARENT_FULL_TAG";
    private static final String PARENT_TAG_KEY = "PARENT_TAG";
    private String rowCpKey = "";
    private String colCpKeys = "";
    private Map<String, Integer> colCpIdxs = new HashMap<String, Integer>();
    private List<String[]> rows = new ArrayList<String[]>();
    private String[] data;
    private String[] cols;
    private String rtnCpKeys = "";
    private Map<String, String> rtnKeyMap = new HashMap<String, String>();
    private Map<String, String> rtnMap = new HashMap<String, String>();
    private boolean isInRow;
    private String curQName = "";
    private String curFQName = "";
    private int pFullTagIdx = -1;
    private int pTagIdx = -1;
    private String curId = "";
    private List<RowColId> idList = new ArrayList<RowColId>();
    private Map<String, String> idMap = new HashMap<String, String>();
    private final InputStream input;

    public XML2TableParser(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("\u4e0d\u6b63\u306a\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002\u30a8\u30f3\u30b3\u30fc\u30c9=[UTF-8]", unsupportedEncodingException);
        }
        int n = string.indexOf(60);
        this.input = new ByteArrayInputStream(byArray, n, byArray.length - n);
    }

    public XML2TableParser(InputStream inputStream) {
        this.input = inputStream;
    }

    public void setTableCols(String string, String ... stringArray) {
        if (string == null || string.isEmpty() || stringArray == null || stringArray.length == 0) {
            return;
        }
        this.cols = (String[])stringArray.clone();
        this.rowCpKey = string.toUpperCase(Locale.JAPAN);
        this.colCpKeys = "," + StringUtil.array2csv(stringArray).toUpperCase(Locale.JAPAN) + ",";
        for (int i = 0; i < this.cols.length; ++i) {
            String string2 = this.cols[i].toUpperCase(Locale.JAPAN);
            if (PARENT_TAG_KEY.equals(string2)) {
                this.pTagIdx = i;
            } else if (PARENT_FULL_TAG_KEY.equals(string2)) {
                this.pFullTagIdx = i;
            }
            this.colCpIdxs.put(string2, i);
        }
    }

    public void setReturnCols(String ... stringArray) {
        if (stringArray.length > 0) {
            this.rtnCpKeys = "," + StringUtil.array2csv(stringArray).toUpperCase(Locale.JAPAN) + ",";
            for (int i = 0; i < stringArray.length; ++i) {
                this.rtnKeyMap.put(stringArray[i].toUpperCase(Locale.JAPAN), stringArray[i]);
            }
        }
    }

    public String[] getCols() {
        return this.cols == null ? null : (String[])this.cols.clone();
    }

    public String[][] getData() {
        return (String[][])this.rows.toArray((T[])new String[this.rows.size()][0]);
    }

    public Map<String, String> getRtn() {
        return this.rtnMap;
    }

    public void parse() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(this.input, (DefaultHandler)this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("\u30d1\u30fc\u30b5\u30fc\u306e\u8a2d\u5b9a\u306b\u554f\u984c\u304c\u3042\u308a\u307e\u3059\u3002", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", sAXException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("\u30c7\u30fc\u30bf\u306e\u8aad\u307f\u53d6\u308a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", iOException);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.curQName = this.getCpTagName(string3);
        if (this.rowCpKey.equals(this.curQName)) {
            if (this.cols == null) {
                throw new RuntimeException("#setTableCols(String,String...)\u3092\u5148\u306b\u5b9f\u884c\u3057\u3066\u304a\u3044\u3066\u304f\u3060\u3055\u3044\u3002");
            }
            this.isInRow = true;
            this.data = new String[this.cols.length];
            if (this.pTagIdx >= 0) {
                this.data[this.pTagIdx] = this.getCpParentTagName(this.curFQName);
            }
            if (this.pFullTagIdx >= 0) {
                this.data[this.pFullTagIdx] = this.curFQName;
            }
        }
        this.curFQName = this.curFQName + ">" + this.curQName + ">";
        String string4 = attributes.getValue("href");
        if (string4 != null && string4.length() > 0 && string4.charAt(0) == '#') {
            int n = this.getColIdx(this.curQName);
            if (this.isInRow && n >= 0) {
                this.idList.add(new RowColId(this.rows.size(), n, string4.substring(1)));
            }
        }
        this.curId = attributes.getValue("id");
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        String string;
        String string2 = new String(cArray, n, n2);
        int n3 = this.getColIdx(this.curQName);
        if (this.isInRow && n3 >= 0 && this.data != null && this.data.length > n3) {
            this.data[n3] = (this.data[n3] == null ? "" : this.data[n3]) + string2;
        }
        if (this.curQName != null && this.curQName.length() > 0 && this.rtnCpKeys.indexOf(this.curQName) >= 0) {
            string = this.rtnKeyMap.get(this.curQName);
            String string3 = this.rtnMap.get(string);
            this.rtnMap.put(string, (string3 == null ? "" : string3) + string2);
        }
        if (this.curId != null && this.curId.length() > 0 && n3 >= 0) {
            string = this.rtnMap.get(n3 + "__" + this.curId);
            this.idMap.put(n3 + "__" + this.curId, (string == null ? "" : string) + string2);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.curQName = "";
        this.curId = "";
        String string4 = this.getCpTagName(string3);
        if (this.rowCpKey.equals(string4)) {
            this.rows.add(this.data);
            this.isInRow = false;
        }
        this.curFQName = this.curFQName.replace(">" + string4 + ">", "");
    }

    @Override
    public void endDocument() {
        for (RowColId rowColId : this.idList) {
            this.rows.get((int)((RowColId)rowColId).row)[((RowColId)rowColId).col] = this.idMap.get(rowColId.col + "__" + rowColId.id);
        }
    }

    private String getCpTagName(String string) {
        String string2 = string.toUpperCase(Locale.JAPAN);
        int n = string2.indexOf(58);
        if (n >= 0) {
            string2 = string2.substring(n + 1);
        }
        return string2;
    }

    private String getCpParentTagName(String string) {
        String string2 = "";
        int n = string.lastIndexOf(62, string.length() - 2) + 1;
        int n2 = string.length() - 1;
        if (n >= 0 && n2 >= 0 && n < n2) {
            string2 = string.substring(n, n2);
        }
        return string2;
    }

    private int getColIdx(String string) {
        Integer n;
        int n2 = -1;
        if (string != null && string.length() > 0 && this.colCpKeys.indexOf(string) >= 0 && (n = this.colCpIdxs.get(string)) != null) {
            n2 = n;
        }
        return n2;
    }

    private static final class RowColId {
        private final int row;
        private final int col;
        private final String id;

        RowColId(int n, int n2, String string) {
            this.row = n;
            this.col = n2;
            this.id = string;
        }
    }
}

