/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.report;

// import java.io.BufferedWriter;
import java.io.PrintWriter;											// 6.3.8.0 (2015/09/11)

import java.io.File;
// import java.io.FileNotFoundException;
// import java.io.FileOutputStream;
// import java.io.OutputStreamWriter;
// import java.io.UnsupportedEncodingException;

import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.FileUtil;							// 6.3.8.0 (2015/09/11)
import org.opengion.fukurou.util.Closer ;							// 6.3.8.0 (2015/09/11)
// import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.report.AbstractCSVPrintPointService;

import static org.opengion.fukurou.util.HybsConst.CR ;				// 5.9.0.0 (2015/09/04)
// import static org.opengion.fukurou.util.HybsConst.FS ;				// 5.9.0.0 (2015/09/04)
import static org.opengion.fukurou.util.HybsConst.BUFFER_MIDDLE ;	// 5.9.0.0 (2015/09/04)

/**
 * 標準的なCSV形式でデータを作成します。
 * CSVの出力先はGE50系テーブルで指定した場所です。
 *
 * @og.group 帳票システム
 *
 * @version  5.9.0.0
 * @author	 Masakazu Takahashi
 * @since    JDK6.0,
 */
public class CSVPrintPointService_DEFAULT extends AbstractCSVPrintPointService {

//	private static final String CR		= System.getProperty("line.separator");
	private final StringBuilder strCSV	= new StringBuilder( BUFFER_MIDDLE );	// CSVはこれに吐く

	private final String	csvEncode 	= HybsSystem.sys("REPORT_CSV_TEXT_ENCODE");

	/**
	 * 発行処理。
	 * ファイル出力
	 *
	 * @og.rev 6.3.8.0 (2015/09/11) FileUtil#getPrintWriter( File,String ) を使用。
	 *
	 * @return 結果 [true:正常/false:異常]
	 */
	@Override
	public boolean execute(){
		System.out.print( "CSV create ... " );
//		BufferedWriter bw = null;
		PrintWriter    bw = null;				// 6.3.8.0 (2015/09/11)
//		String filename= outdir;				// 6.3.8.0 (2015/09/11) new File( outdir ) で、直接指定する。
//		boolean flg = false;					// 6.3.8.0 (2015/09/11) try ～ catch で、flag判定の意味がなかった。

		try {
			makeheader();
			makebody();

			// 6.3.8.0 (2015/09/11) FileUtil#getPrintWriter( File,String ) を使用。
//			bw = getWriter( filename,false,csvEncode );
			bw = FileUtil.getPrintWriter( new File( outdir ),csvEncode ) ;		// 6.3.8.0 (2015/09/11) 
			bw.write( strCSV.toString() );
			bw.flush();
//			bw.close();

//			flg = true;

//			if( prgfile != null && prgfile.length() > 0){
//				makeShellCommand();
//				flg = programRun();
//			}

		}
		catch ( Throwable ex ) {
			errMsg.append( "CSV Print Request Execution Error. " ).append( CR )
				.append( "==============================" ).append( CR )
				.append( "SYSTEM_ID=[" ).append( systemId ).append( "] , " )
				.append( "YKNO=["    ).append( ykno    ).append( "] , " )
				.append( ex.toString() )
				.append( CR );
//			throw new RuntimeException( errMsg.toString() );
			throw new RuntimeException( errMsg.toString(), ex );
		}
		finally {
			Closer.ioClose( bw );		// 6.3.8.0 (2015/09/11) 
		}
//		return flg;
		return true;			// 6.3.8.0 (2015/09/11) catch 以外は、フラグにtrue がセットされるので、ここでは、true しか返さない。
	}

	/**
	 * ヘッダの出力。
	 *
	 */
	private void makeheader(){
		//ヘッダデータを出力する場合はここで指定する。
		//strCSV.append( listid ).append( CR );

		//１行目にカラム名を出力します。
		// メインテーブルはNULLではない
		for( int clmNo=0; clmNo<table.getColumnCount(); clmNo++ ) {
			// 先頭以外はカンマを付ける
			if( clmNo > 0 ){ strCSV.append( ',' ); } 
			strCSV.append('"').append( table.getColumnName( clmNo )).append( '"' );
		}
		if( tableH != null){
			for( int clmNo=0; clmNo<tableH.getColumnCount(); clmNo++ ) {
//				strCSV.append( ',' )
//					.append("\"H_").append( tableH.getColumnName( clmNo )).append('"');
				strCSV.append( ",\"H_" ).append( tableH.getColumnName( clmNo )).append('"');
			}
		}
		if( tableF != null){
			for( int clmNo=0; clmNo<tableF.getColumnCount(); clmNo++ ) {
//				strCSV.append( ',' )
//					.append("\"F_").append( tableF.getColumnName( clmNo )).append('"');
				strCSV.append(",\"F_").append( tableF.getColumnName( clmNo )).append('"');
			}
		}
		strCSV.append( CR );
	}

	/**
	 * 本体の出力を行います。
	 */
	private void makebody(){

		for( int rowNo=0; rowNo<table.getRowCount(); rowNo++ ) {
			// カラム単位の処理
			for( int clmNo=0; clmNo<table.getColumnCount(); clmNo++ ) {
				// 先頭以外はカンマを付ける
				if( clmNo > 0 ){ strCSV.append( ',' ); } 
				// 全てダブルクウォートで囲う
				strCSV.append('"').append( StringUtil.replace(table.getValue( rowNo, clmNo ),"\"","\"\"" ) ).append('"');
			}

			//ヘッダ、フッタは毎行に必ず付加します。
			//例え複数行あったとしても先頭行のみ有効です
			//ヘッダ
			if( tableH != null){
				final int rowNoH=0;
				for( int clmNo=0; clmNo<tableH.getColumnCount(); clmNo++ ) {
					// 必ずカンマを付ける
//					strCSV.append( ',' )
					// 全てダブルクウォートで囲う
//						.append('"').append( StringUtil.replace(tableH.getValue( rowNoH, clmNo ),"\"","\"\"" ) ).append('"');
					strCSV.append( ",\"" ).append( StringUtil.replace(tableH.getValue( rowNoH, clmNo ),"\"","\"\"" ) ).append('"');
				}
			}

			//フッタ
			if( tableF != null ){
				final int rowNoF=0;
				for( int clmNo=0; clmNo<tableF.getColumnCount(); clmNo++ ) {
					// 必ずカンマを付ける
//					strCSV.append( ',' )
					// 全てダブルクウォートで囲う
//						.append('"').append( StringUtil.replace(table.getValue( rowNoF, clmNo ),"\"","\"\"" ) ).append('"');
					strCSV.append( ",\"" ).append( StringUtil.replace(table.getValue( rowNoF, clmNo ),"\"","\"\"" ) ).append('"');
				}
			}

			strCSV.append( CR );
		}
	}

//	/**
//	 * ファイル書き込み用のライターを返します。
//	 *
//	 * @og.rev 6.3.8.0 (2015/09/11) FileUtil#getPrintWriter( File,String ) を使用。廃止。
//	 *
//	 * @param fileName ファイル名
//	 * @param append アベンドするか
//	 * @param encode エンコード
//	 *
//	 * @return ライター
//	 */
//	private BufferedWriter getWriter( final String fileName, final boolean append, final String encode) {
//		File file = new File ( fileName );
//		BufferedWriter bw;
//
//		try {
//			bw = new BufferedWriter( new OutputStreamWriter( new FileOutputStream( file, append ), encode ) );
//		}
//		catch ( UnsupportedEncodingException ex ) {
//			errMsg.append( "[ERROR] Input File is written by Unsupported Encoding" );
//			throw new HybsSystemException( ex );
//		}
//		catch ( FileNotFoundException ex ) {
//			errMsg.append( "[ERROR] File not Found" );
//			throw new HybsSystemException( ex );
//		}
//		return bw;
//	}
}
